/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.entities.misc.MobArrowEntity;
import io.github.flemmli97.runecraftory.common.entities.monster.Goblin;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinition;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.StayWithinDistanceOfAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.StrafeTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import org.joml.Vector3d;

public class GoblinArcher
extends Goblin {
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder(Goblin.BUILDER, new String[]{SLEEP});
    public static final String BOW = BUILDER.add("bow", AnimationsBuilder.definition((double)0.8).marker("attack", new double[]{0.52}));
    public static final String TRIPLE = BUILDER.add("triple", BOW);
    public static final String KICK = BUILDER.add("kick", AnimationsBuilder.definition((double)0.56).marker("attack", new double[]{0.32}));
    public static final String INTERACT = BUILDER.add("interact", KICK);
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private final AnimationHandler<GoblinArcher> animationHandler = new AnimationHandler((Entity)this, ANIMS);

    public GoblinArcher(EntityType<? extends Goblin> type, Level level) {
        super(type, level);
    }

    @Override
    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.BOW));
        this.setDropChance(EquipmentSlot.MAINHAND, 0.0f);
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(new String[]{KICK}).play(MonsterBehaviourUtils.requireInRangePlay()).condition(MonsterBehaviourUtils.inAABBRange(KICK)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(5).start(new String[]{BOW}).play(MonsterBehaviourUtils.cooldownedPlay()).condition(e -> e.getMainHandItem().getItem() instanceof BowItem).prepare(new ExtendedBehaviour[]{new StrafeTarget().strafeDistance(10.0f)}).end(7).start(new String[]{TRIPLE}).play(MonsterBehaviourUtils.cooldownedPlay()).condition(e -> e.getMainHandItem().getItem() instanceof BowItem).prepare(new ExtendedBehaviour[]{new StrafeTarget().strafeDistance(10.0f)}).end(4).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(2, new ExtendedBehaviour[]{new StayWithinDistanceOfAttackTarget().maxDistance(15.0f)}).add(3, new ExtendedBehaviour[]{new StrafeTarget()}).add(1, MonsterBehaviourUtils.ifCloserThan(10.0), new ExtendedBehaviour[]{new SetRandomWalkTarget(), MonsterBehaviourUtils.moveTo()}).add(2, MonsterBehaviourUtils.ifFurtherThan(7.0), new ExtendedBehaviour[]{new Idle()}).build();
    }

    @Override
    public void setupAttack(AnimationDefinition anim) {
        if (anim.is(new String[]{BOW, TRIPLE})) {
            this.startUsingItem(InteractionHand.MAIN_HAND);
        }
        super.setupAttack(anim);
    }

    @Override
    public void handleAttack(AnimationState anim) {
        if (anim.is(new String[]{BOW, TRIPLE})) {
            this.getNavigation().stop();
            if (anim.isAt("attack")) {
                boolean withTarget;
                boolean bl = withTarget = this.getTarget() != null && this.getSensing().hasLineOfSight((Entity)this.getTarget());
                if (anim.is(new String[]{BOW})) {
                    if (withTarget) {
                        this.shootArrow(this.getTarget());
                    } else {
                        this.shootArrowFromRotation((LivingEntity)this);
                    }
                } else if (withTarget) {
                    this.shootTripleArrow(this.getTarget());
                } else {
                    this.shootTripleArrowFromRotation((LivingEntity)this);
                }
                this.stopUsingItem();
            }
        } else {
            super.handleAttack(anim);
        }
    }

    @Override
    public AABB attackBB(AnimationState anim) {
        double width = (double)this.getBbWidth() * 1.3;
        double length = (double)this.getBbWidth() * 1.7;
        return new AABB(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.getBbHeight() + 0.02, length);
    }

    public AnimationHandler<GoblinArcher> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, (Entity)this.getControllingPassenger(), command == 2 ? (Spell)RuneCraftorySpells.TRIPLE_ARROW.get() : null)) {
                return;
            }
            if (command == 2) {
                this.getAnimationHandler().setAnimation(TRIPLE);
            } else if (command == 1) {
                this.getAnimationHandler().setAnimation(BOW);
            } else {
                this.getAnimationHandler().setAnimation(KICK);
            }
        }
    }

    private void shootArrow(LivingEntity target) {
        MobArrowEntity arrow = new MobArrowEntity(this.level(), (LivingEntity)this, 0.8f);
        Vec3 dir = new Vec3(target.getX() - arrow.getX(), target.getY(0.33) - arrow.getY(), target.getZ() - arrow.getZ());
        double l = Math.sqrt(dir.x * dir.x + dir.z * dir.z);
        dir = dir.add(0.0, l * 0.2, 0.0);
        arrow.shoot(dir.x, dir.y, dir.z, 1.3f, 7 - this.level().getDifficulty().getId() * 2);
        this.playSound(SoundEvents.SKELETON_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
        this.level().addFreshEntity((Entity)arrow);
    }

    private void shootArrowFromRotation(LivingEntity shooter) {
        MobArrowEntity arrow = new MobArrowEntity(this.level(), (LivingEntity)this, 0.8f);
        arrow.shootFromRotation((Entity)shooter, shooter.getXRot(), shooter.getYRot(), 0.0f, 1.3f, 7 - this.level().getDifficulty().getId() * 2);
        this.playSound(SoundEvents.SKELETON_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
        this.level().addFreshEntity((Entity)arrow);
    }

    private void shootTripleArrow(LivingEntity target) {
        MobArrowEntity arrow = new MobArrowEntity(this.level(), (LivingEntity)this, 0.8f);
        Vec3 dir = new Vec3(target.getX() - arrow.getX(), target.getY(0.33) - arrow.getY(), target.getZ() - arrow.getZ());
        double l = Math.sqrt(dir.x * dir.x + dir.z * dir.z);
        dir = dir.add(0.0, l * 0.2, 0.0);
        arrow.shoot(dir.x, dir.y, dir.z, 1.3f, 7 - this.level().getDifficulty().getId() * 2);
        this.level().addFreshEntity((Entity)arrow);
        Vec3 up = this.getUpVector(1.0f);
        Vector3d dir3d = new Vector3d(dir.x(), dir.y(), dir.z());
        for (float y = -15.0f; y <= 15.0f; y += 30.0f) {
            Vector3d newDir = dir3d.rotateAxis((double)(y * ((float)Math.PI / 180)), up.x(), up.y(), up.z(), new Vector3d());
            MobArrowEntity arrowO = new MobArrowEntity(this.level(), (LivingEntity)this, 0.8f);
            arrowO.shoot(newDir.x(), newDir.y(), newDir.z(), 1.3f, 7 - this.level().getDifficulty().getId() * 2);
            this.level().addFreshEntity((Entity)arrowO);
        }
        this.playSound(SoundEvents.SKELETON_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
    }

    private void shootTripleArrowFromRotation(LivingEntity shooter) {
        for (int i = 0; i < 3; ++i) {
            MobArrowEntity arrow = new MobArrowEntity(this.level(), (LivingEntity)this, 0.8f);
            arrow.shootFromRotation((Entity)shooter, shooter.getXRot(), shooter.getYRot() + (float)((i - 1) * 15), 0.0f, 1.3f, 7 - this.level().getDifficulty().getId() * 2);
            this.playSound(SoundEvents.SKELETON_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
            this.level().addFreshEntity((Entity)arrow);
        }
    }

    @Override
    public String getInteractAnimation() {
        return INTERACT;
    }
}

