/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.entities.ai.control.FreeMoveControl;
import io.github.flemmli97.runecraftory.common.entities.ai.pathing.FloatingFlyNavigator;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.spells.SleepAuraSpell;
import io.github.flemmli97.runecraftory.common.spells.WindBladeSpell;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetWithinDist;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.StayWithinDistanceOfAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomHoverTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import org.jetbrains.annotations.Nullable;

public class LeafBall
extends BaseMonster {
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String MELEE = BUILDER.add("tackle", AnimationsBuilder.definition((double)0.68).marker("attack", new double[]{0.36}));
    public static final String INTERACT = BUILDER.add("interact", MELEE);
    public static final String WIND = BUILDER.add("wind_blade", AnimationsBuilder.definition((double)1.12).marker("attack", new double[]{0.52}));
    public static final String SLEEP_ATTACK = BUILDER.add("sleep_aura", AnimationsBuilder.definition((double)0.8).marker("attack", new double[]{0.44}));
    public static final String STILL = BUILDER.add("still", AnimationsBuilder.definition((double)0.0).infinite());
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private final AnimationHandler<LeafBall> animationHandler = new AnimationHandler((Entity)this, ANIMS);

    public LeafBall(EntityType<? extends LeafBall> type, Level level) {
        super(type, level);
        this.setNoGravity(true);
        this.moveControl = new FreeMoveControl((Mob)this, 60.0f, 30.0f, () -> true);
    }

    @Override
    protected PathNavigation createNavigation(Level level) {
        return new FloatingFlyNavigator((Mob)this, level);
    }

    @Override
    protected void applyAttributes() {
        this.getAttribute(Attributes.FOLLOW_RANGE).setBaseValue(32.0);
        this.getAttribute(Attributes.FLYING_SPEED).setBaseValue(0.28);
        super.applyAttributes();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(new String[]{MELEE}).play(MonsterBehaviourUtils.requireInRangePlay()).condition(MonsterBehaviourUtils.inAABBRange(MELEE)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(3).start(new String[]{WIND}).play(MonsterBehaviourUtils.cooldownedPlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(2.0).max(6.0)}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(6).start(new String[]{SLEEP_ATTACK}).play(MonsterBehaviourUtils.cooldownedPlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(MonsterBehaviourUtils.closeEnough(5))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(4).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(6, new ExtendedBehaviour[]{new StayWithinDistanceOfAttackTarget().maxDistance(15.0f)}).add(2, MonsterBehaviourUtils.ifCloserThan(10.0), new ExtendedBehaviour[]{new SetRandomHoverTarget(), MonsterBehaviourUtils.moveTo()}).build();
    }

    @Override
    public int animationCooldown(@Nullable String anim) {
        int diffAdd = this.difficultyCooldown();
        if (anim == null) {
            return this.getRandom().nextInt(20) + 30 + diffAdd;
        }
        return this.getRandom().nextInt(40) + 25 + diffAdd;
    }

    @Override
    public AABB attackBB(AnimationState anim) {
        double width = (double)this.getBbWidth() * 1.4;
        double length = this.getBbWidth() * 2.0f;
        return new AABB(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.getBbHeight() + 0.02, length);
    }

    @Override
    public void handleAttack(AnimationState anim) {
        if (anim.is(new String[]{WIND})) {
            this.getNavigation().stop();
            if (anim.isAt("attack")) {
                ((WindBladeSpell)RuneCraftorySpells.DOUBLE_SONIC.get()).use((LivingEntity)this);
            }
        } else if (anim.is(new String[]{SLEEP_ATTACK})) {
            this.getNavigation().stop();
            if (anim.isAt("attack")) {
                ((SleepAuraSpell)RuneCraftorySpells.SLEEP_AURA.get()).use((LivingEntity)this);
            }
        } else {
            super.handleAttack(anim);
        }
    }

    public AnimationHandler<LeafBall> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, (Entity)this.getControllingPassenger(), command == 0 ? (Spell)RuneCraftorySpells.DOUBLE_BULLET.get() : null)) {
                return;
            }
            if (command == 1) {
                this.getAnimationHandler().setAnimation(MELEE);
            } else {
                this.getAnimationHandler().setAnimation(WIND);
            }
        }
    }

    @Override
    public String getInteractAnimation() {
        return INTERACT;
    }

    @Override
    public String getSleepAnimation() {
        return STILL;
    }
}

