/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.common.entities.monster.Chipsqueek;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class MineralSqueek
extends Chipsqueek {
    public static final ResourceKey<LootTable> MINERAL_SQUEEK_HURT = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)RuneCraftory.modRes("entities/mineral_squeek_hurt"));

    public MineralSqueek(EntityType<? extends Chipsqueek> type, Level level) {
        super(type, level);
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        Player player;
        ItemStack main;
        Entity entity = source.getEntity();
        if (entity instanceof Player && !this.canBeDamagedBy(main = (player = (Player)entity).getMainHandItem())) {
            return false;
        }
        return super.hurt(source, amount);
    }

    protected boolean canBeDamagedBy(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        double[] val = new double[]{0.0};
        stack.forEachModifier(EquipmentSlot.MAINHAND, (att, mod) -> {
            if (att.is(Attributes.ATTACK_DAMAGE) && mod.operation() == AttributeModifier.Operation.ADD_VALUE) {
                val[0] = val[0] + mod.amount();
            }
        });
        return val[0] > 1.0;
    }

    @Override
    protected void actuallyHurt(DamageSource source, float damageAmount) {
        damageAmount = Math.max(1.0f, damageAmount);
        float health = this.getHealth();
        super.actuallyHurt(source, damageAmount);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (health - this.getHealth() >= 1.0f) {
                LootTable lootTable = serverLevel.getServer().reloadableRegistries().getLootTable(MINERAL_SQUEEK_HURT);
                LootParams.Builder builder = new LootParams.Builder(serverLevel).withParameter(LootContextParams.THIS_ENTITY, (Object)this).withParameter(LootContextParams.ORIGIN, (Object)this.position()).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)source).withOptionalParameter(LootContextParams.ATTACKING_ENTITY, (Object)source.getEntity()).withOptionalParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)source.getDirectEntity());
                Entity entity = source.getEntity();
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    builder = builder.withParameter(LootContextParams.LAST_DAMAGE_PLAYER, (Object)player).withLuck(player.getLuck());
                }
                LootParams lootParams = builder.create(LootContextParamSets.ENTITY);
                lootTable.getRandomItems(lootParams, arg_0 -> ((MineralSqueek)this).spawnAtLocation(arg_0));
            }
        }
    }

    protected float getDamageAfterArmorAbsorb(DamageSource damageSource, float damageAmount) {
        return damageAmount;
    }

    protected float getDamageAfterMagicAbsorb(DamageSource damageSource, float damageAmount) {
        return damageAmount;
    }
}

