/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.common.entities.BossMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.pathing.StaticNavigator;
import io.github.flemmli97.runecraftory.common.entities.misc.SarcophagusTeleporter;
import io.github.flemmli97.runecraftory.common.entities.utils.RunecraftoryBossbar;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class SanoUno
extends BossMonster {
    private static final EntityDataAccessor<Boolean> CAN_BE_REMOVED = SynchedEntityData.defineId(SanoUno.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private UUID linkedID;
    protected boolean reversedSwipe;

    public SanoUno(EntityType<? extends SanoUno> type, Level level) {
        super((EntityType<? extends BossMonster>)type, level);
        this.lookControl = new NonLookControl((Mob)this);
    }

    @Override
    public RunecraftoryBossbar createBossBar() {
        return new RunecraftoryBossbar(RuneCraftoryEntities.SANO_AND_UNO.getID(), this.getDisplayName(), BossEvent.BossBarColor.YELLOW, BossEvent.BossBarOverlay.PROGRESS).setMusic((SoundEvent)RuneCraftorySounds.SANO_UNO_FIGHT.get());
    }

    @Override
    protected PathNavigation createNavigation(Level level) {
        return new StaticNavigator((Mob)this, level);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(CAN_BE_REMOVED, (Object)false);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (this.linkedID != null) {
            compound.putUUID("LinkedID", this.linkedID);
        }
        compound.putBoolean("CanBeRemoved", ((Boolean)this.entityData.get(CAN_BE_REMOVED)).booleanValue());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.hasUUID("LinkedID")) {
            this.linkedID = compound.getUUID("LinkedID");
        }
        this.entityData.set(CAN_BE_REMOVED, (Object)compound.getBoolean("CanBeRemoved"));
    }

    public void linkUsing(UUID uuid) {
        this.linkedID = uuid;
        this.bossInfo.setMusicID(this.linkedID);
    }

    @Nullable
    public UUID getLinkedID() {
        return this.linkedID;
    }

    public void push(double x, double y, double z) {
    }

    public void lookAt(Entity entity, float maxYRotIncrease, float maxXRotIncrease) {
    }

    @Override
    protected Vec3 directionToLookAt() {
        return null;
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    @Override
    public void travel(Vec3 vec) {
        this.xxa = 0.0f;
        this.yya = 0.0f;
        this.zza = 0.0f;
        this.setDeltaMovement(0.0, this.getDeltaMovement().y - 0.08, 0.0);
        this.move(MoverType.SELF, this.getDeltaMovement());
    }

    @Override
    protected boolean checkRage() {
        return false;
    }

    protected void playStepSound(BlockPos pos, BlockState blockIn) {
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        if (source.is(DamageTypes.IN_WALL)) {
            return false;
        }
        if (!source.is(DamageTypeTags.BYPASSES_INVULNERABILITY) && this.deathTime == this.maxDeathTime() - 1) {
            this.remove(Entity.RemovalReason.KILLED);
            return true;
        }
        return super.hurt(source, amount);
    }

    @Override
    protected void tickDeath() {
        SanoUno other;
        if (!this.level().isClientSide && this.deathTime == 0 && (other = this.getLinked()) != null && !((Boolean)this.entityData.get(CAN_BE_REMOVED)).booleanValue()) {
            other.entityData.set(CAN_BE_REMOVED, (Object)true);
        }
        if (this.deathTime == this.maxDeathTime() - 1) {
            if (this.level().isClientSide) {
                this.deathRays = 0;
                return;
            }
            other = this.getLinked();
            if (!((Boolean)this.entityData.get(CAN_BE_REMOVED)).booleanValue() && other != null && !other.isRemoved()) {
                return;
            }
        }
        super.tickDeath();
    }

    @Override
    public double deathRayOffset() {
        return (double)this.getBbHeight() * 0.5;
    }

    @Override
    public void remove(Entity.RemovalReason reason) {
        if (!this.level().isClientSide && reason == Entity.RemovalReason.KILLED && this.linkedID != null) {
            Vec3 dir = Vec3.directionFromRotation((float)0.0f, (float)this.getYRot());
            SarcophagusTeleporter teleporter = new SarcophagusTeleporter((EntityType)RuneCraftoryEntities.SARCOPHAGUS_TELEPORTER.get(), this.level());
            teleporter.setPos(this.position().add(dir.scale(-2.0)));
            this.level().addFreshEntity((Entity)teleporter);
        }
        super.remove(reason);
    }

    @Override
    public boolean reversed() {
        return this.reversedSwipe;
    }

    public abstract SanoUno getLinked();

    static class NonLookControl
    extends LookControl {
        public NonLookControl(Mob mob) {
            super(mob);
        }

        public void tick() {
            boolean b = false;
        }
    }
}

