/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ChargingMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.SetChargeTarget;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.SetWaterPrioritizingWalkTarget;
import io.github.flemmli97.runecraftory.common.entities.ai.control.SwimWalkMoveController;
import io.github.flemmli97.runecraftory.common.entities.ai.pathing.AmphibiousNavigator;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;

public class Tortas
extends ChargingMonster {
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String BITE = BUILDER.add("bite", AnimationsBuilder.definition((double)0.56).marker("attack", new double[]{0.32}));
    public static final String INTERACT = BUILDER.add("interact", BITE);
    public static final String SPIN = BUILDER.add("spin", AnimationsBuilder.definition((double)2.5).marker("attack_start", new double[]{0.0}));
    public static final String SLEEP = BUILDER.add("sleep", AnimationsBuilder.definition((double)0.0).infinite());
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    protected final PathNavigation waterNavigator;
    protected final PathNavigation groundNavigator;
    private final AnimationHandler<Tortas> animationHandler = new AnimationHandler((Entity)this, ANIMS);

    public Tortas(EntityType<? extends Tortas> type, Level level) {
        super((EntityType<? extends ChargingMonster>)type, level);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = new SwimWalkMoveController((Mob)this, 1.2);
        this.waterNavigator = new AmphibiousNavigator((Mob)this, level);
        this.groundNavigator = this.navigation;
    }

    @Override
    protected void applyAttributes() {
        this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.18);
        this.getAttribute(Attributes.STEP_HEIGHT).setBaseValue(((Attribute)Attributes.STEP_HEIGHT.value()).getDefaultValue() + 1.0);
        super.applyAttributes();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(new String[]{BITE}).play(MonsterBehaviourUtils.requireInRangePlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(2).start(new String[]{BITE}).play(MonsterBehaviourUtils.requireInRangePlay()).condition(MonsterBehaviourUtils.ifCloserThan(4.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(5).start(new String[]{SPIN}).play(MonsterBehaviourUtils.cooldownedPlay()).prepare(new ExtendedBehaviour[]{new SetChargeTarget()}).end(5).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(2, new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget(), MonsterBehaviourUtils.moveTo()}).add(1, MonsterBehaviourUtils.ifCloserThan(7.0), new ExtendedBehaviour[]{new SetRandomWalkTarget(), MonsterBehaviourUtils.moveTo()}).add(4, MonsterBehaviourUtils.withCondition(MonsterBehaviourUtils.ifCloserThan(9.0)), new ExtendedBehaviour[]{new Idle()}).build();
    }

    @Override
    protected ExtendedBehaviour<? extends BaseMonster> getWanderBehaviour() {
        return new SetWaterPrioritizingWalkTarget();
    }

    @Override
    protected int wanderChance() {
        return this.isSwimming() ? 5 : 100;
    }

    @Override
    protected boolean canFloatInWater() {
        return false;
    }

    @Override
    public AABB attackBB(AnimationState anim) {
        double width = (double)this.getBbWidth() * 1.2;
        double length = (double)this.getBbWidth() * 1.4;
        return new AABB(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.getBbHeight() + 0.02, length);
    }

    @Override
    public int animationCooldown(String anim) {
        if (anim != null && anim.equals(SPIN)) {
            int diffAdd = this.difficultyCooldown();
            return this.getRandom().nextInt(50) + 30 + diffAdd;
        }
        return super.animationCooldown(anim);
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimationState anim, Vec3 target, double grow) {
        if (anim != null && anim.is(new String[]{SPIN})) {
            return new OrientedBoundingBox(OrientedBoundingBox.originAABB((Entity)this).inflate(0.2), this.getYRot(), 0.0f, this.position());
        }
        return super.calculateAttackAABB(anim, target, grow);
    }

    public AnimationHandler<Tortas> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    protected boolean isChargingAnim(String anim) {
        return anim.equals(SPIN);
    }

    @Override
    public double chargingSpeed() {
        return 0.3f;
    }

    @Override
    public boolean handleChargeMovement(AnimationState anim) {
        Vec3 prevMotion = this.getDeltaMovement();
        if (this.getTarget() != null) {
            Vec3 pos = this.position();
            Vec3 target = this.getTarget().position();
            Vec3 mot = target.subtract(pos.x, this.isInWater() ? pos.y : target.y, pos.z).normalize().scale(0.27);
            this.setDeltaMovement(mot.x, mot.y, mot.z);
            if (!this.onGround() && !this.isInWater()) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, prevMotion.y, 0.0));
            }
        } else {
            Vec3 look = this.calculateViewVector(this.isInWater() ? this.getXRot() : 0.0f, this.getYRot()).scale(0.27);
            this.setDeltaMovement(look.x, look.y, look.z);
            if (!this.onGround() && !this.isInWater()) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, prevMotion.y, 0.0));
            }
        }
        return true;
    }

    @Override
    public void doWhileCharge() {
        if (this.tickCount % 4 == 0) {
            this.playSound((SoundEvent)RuneCraftorySounds.PLAYER_ATTACK_SWOOSH_LIGHT.get(), 1.0f, (this.getRandom().nextFloat() - this.getRandom().nextFloat()) * 0.2f + 1.0f);
        }
        if (this.tickCount % 8 == 0) {
            this.hitEntity.clear();
        }
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, (Entity)this.getControllingPassenger(), null)) {
                return;
            }
            if (command == 1) {
                this.getAnimationHandler().setAnimation(SPIN);
            } else {
                this.getAnimationHandler().setAnimation(BITE);
            }
        }
    }

    @Override
    public void setDoJumping(boolean jump) {
        if (this.isInWater()) {
            super.setDoJumping(jump);
        }
    }

    @Override
    public void travel(Vec3 vec) {
        if (this.isEffectiveAi() && this.isInWater()) {
            this.handleFreeTravel(vec);
        } else {
            super.travel(vec);
        }
    }

    @Override
    public double ridingSpeedModifier() {
        return 0.8;
    }

    @Override
    protected Vec3 directionToLookAt() {
        if (this.getAnimationHandler().isCurrent(new String[]{SPIN})) {
            return this.getDeltaMovement();
        }
        return super.directionToLookAt();
    }

    @Override
    public boolean adjustRotFromRider(LivingEntity rider) {
        return true;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.TURTLE_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.TURTLE_DEATH;
    }

    public float getVoicePitch() {
        return (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 0.75f;
    }

    protected void playStepSound(BlockPos pos, BlockState blockIn) {
    }

    public void updateSwimming() {
        if (!this.level().isClientSide) {
            if (this.isInWater()) {
                this.navigation = this.waterNavigator;
                this.setSwimming(true);
            } else {
                this.navigation = this.groundNavigator;
                this.setSwimming(false);
            }
        }
    }

    public boolean isPushedByFluid() {
        return false;
    }

    @Override
    public String getInteractAnimation() {
        return INTERACT;
    }

    @Override
    public String getSleepAnimation() {
        return SLEEP;
    }
}

