/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.entities.monster.BigMuck;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.spells.StatusBallSpell;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetAwayFromTarget;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;

public class TrickyMuck
extends BigMuck {
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder(BigMuck.BUILDER, new String[]{SLAP, SPORE, INTERACT, SLEEP});
    public static final String SPORE_BALL = BUILDER.add("spore_ball", SPORE);
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private final AnimationHandler<BigMuck> animationHandler = new AnimationHandler((Entity)this, ANIMS);

    public TrickyMuck(EntityType<? extends TrickyMuck> type, Level level) {
        super((EntityType<? extends BigMuck>)type, level);
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(new String[]{SLAP}).play(MonsterBehaviourUtils.requireInRangePlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(1).start(new String[]{SPORE}).play(MonsterBehaviourUtils.requireInRangePlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(2).start(new String[]{SPORE_BALL}).play(MonsterBehaviourUtils.cooldownedPlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetAwayFromTarget()}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(4).build();
    }

    @Override
    public void handleAttack(AnimationState anim) {
        if (anim.is(new String[]{SPORE_BALL})) {
            this.getNavigation().stop();
            if (anim.isAt("attack")) {
                ((StatusBallSpell)RuneCraftorySpells.POISON_BALL.get()).use((LivingEntity)this);
            }
        } else {
            super.handleAttack(anim);
        }
    }

    @Override
    public AnimationHandler<BigMuck> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, (Entity)this.getControllingPassenger(), command == 2 ? (Spell)RuneCraftorySpells.POISON_BALL.get() : null)) {
                return;
            }
            if (command == 2 && this.getProp().rideActionCosts.canRun(command, (Entity)this.getControllingPassenger(), (Spell)RuneCraftorySpells.POISON_BALL.get())) {
                this.getAnimationHandler().setAnimation(SPORE_BALL);
            }
            if (command == 1) {
                if (this.getProp().rideActionCosts.canRun(command, (Entity)this.getControllingPassenger(), (Spell)RuneCraftorySpells.SPORE_CIRCLE_SPELL.get())) {
                    this.getAnimationHandler().setAnimation(SPORE);
                }
            } else {
                this.getAnimationHandler().setAnimation(SLAP);
            }
        }
    }
}

