/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster.boss;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.BossMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.entities.misc.PollenEntity;
import io.github.flemmli97.runecraftory.common.entities.utils.RunecraftoryBossbar;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.spells.ButterflySpell;
import io.github.flemmli97.runecraftory.common.spells.SleepBallSpell;
import io.github.flemmli97.runecraftory.common.spells.WaveSpell;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.common.entity.ai.TargetPosition;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetAwayFromTarget;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.data.AnimationPlayHolder;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinition;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedDataContainer;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedEntityData;
import io.github.flemmli97.tenshilib.common.registry.TenshilibSyncableEntityDatas;
import io.github.flemmli97.tenshilib.common.utils.TypedResource;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import java.util.function.BiConsumer;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.StrafeTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;

public class Ambrosia
extends BossMonster {
    public static final TypedResource<Vec3> MOVE_DIRECTION = new TypedResource(RuneCraftory.modRes("move_direction"));
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String KICK_1 = BUILDER.add("kick_1", AnimationsBuilder.definition((double)0.8).marker("move", new double[]{0.44}).marker("attack", new double[]{0.52}));
    public static final String KICK_2 = BUILDER.add("kick_2", AnimationsBuilder.definition((double)0.6).marker("move", new double[]{0.24}).marker("attack", new double[]{0.32}));
    public static final String KICK_3 = BUILDER.add("kick_3", AnimationsBuilder.definition((double)0.84).marker("move", new double[]{0.44}).marker("attack", new double[]{0.28}));
    public static final String BUTTERFLY = BUILDER.add("butterfly", AnimationsBuilder.definition((double)2.08).marker("attack", new double[]{0.36}));
    public static final String WAVE = BUILDER.add("wave", AnimationsBuilder.definition((double)2.24).marker("attack", new double[]{0.24}));
    public static final String SLEEP = BUILDER.add("sleep", AnimationsBuilder.definition((double)1.0).marker("attack", new double[]{0.52}));
    public static final String POLLEN = BUILDER.add("pollen", AnimationsBuilder.definition((double)0.96).marker("attack", new double[]{0.52}));
    public static final String POLLEN_2 = BUILDER.add("pollen_2", AnimationsBuilder.definition((double)0.8).marker("attack", new double[]{0.4}));
    public static final String INTERACT = BUILDER.add("interact", KICK_1);
    public static final String SPAWN = BUILDER.add("spawn", AnimationsBuilder.definition((double)2.0).marker("sound", new double[]{0.4}));
    public static final String ANGRY = BUILDER.add("angry", AnimationsBuilder.definition((double)2.0).marker("sound", new double[]{0.24}));
    public static final String DEFEAT = BUILDER.add("defeat", AnimationsBuilder.definition((double)DEATH_DURATION, (boolean)false).infinite());
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private static final ImmutableMap<String, BiConsumer<AnimationState, Ambrosia>> ATTACK_HANDLER = Ambrosia.createAnimationHandler(b -> {
        b.put((Object)BUTTERFLY, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((ButterflySpell)RuneCraftorySpells.BUTTERFLY.get()).use((LivingEntity)entity);
            }
        });
        BiConsumer<AnimationState, Ambrosia> kick = (anim, entity) -> {
            LivingEntity target = entity.getTarget();
            if (anim.isAt("move")) {
                Vec3 dir;
                if (target != null) {
                    dir = target.position().subtract(entity.position());
                    dir = new Vec3(dir.x(), 0.0, dir.z()).normalize();
                } else {
                    dir = EntityUtils.horizontalLookAngle((Entity)entity);
                }
                entity.move(MoverType.SELF, dir.scale(0.7));
            }
            if (anim.isAt("attack")) {
                entity.mobAttack((AnimationState)anim, target, entity::doHurtTarget);
            }
        };
        b.put((Object)KICK_1, kick);
        b.put((Object)KICK_2, kick);
        b.put((Object)KICK_3, kick);
        b.put((Object)SLEEP, (anim, entity) -> {
            entity.getNavigation().stop();
            if (anim.isAt("attack")) {
                ((SleepBallSpell)RuneCraftorySpells.SLEEP_BALLS.get()).use((LivingEntity)entity);
            }
        });
        b.put((Object)WAVE, (anim, entity) -> {
            entity.getNavigation().stop();
            if (anim.isAt("attack")) {
                ((WaveSpell)RuneCraftorySpells.WAVE.get()).use((LivingEntity)entity);
            }
        });
        BiConsumer<AnimationState, Ambrosia> pollenHandler = (anim, entity) -> {
            if (entity.getMoveDirection() == null) {
                entity.setMoveDirection(EntityUtils.getTargetDirection((Mob)entity, EntityAnchorArgument.Anchor.FEET, true).scale(0.35));
            }
            entity.setDeltaMovement(entity.getMoveDirection());
            if (anim.isAt("attack") && !EntityUtils.sealed((LivingEntity)entity)) {
                entity.getNavigation().stop();
                PollenEntity pollen = new PollenEntity(entity.level(), (LivingEntity)entity);
                pollen.setDamageMultiplier(1.1f);
                pollen.setPos(pollen.getX(), pollen.getY() + 0.5, pollen.getZ());
                entity.level().addFreshEntity((Entity)pollen);
            }
        };
        b.put((Object)POLLEN, pollenHandler);
        b.put((Object)POLLEN_2, pollenHandler);
        b.put((Object)SPAWN, (anim, entity) -> {
            if (anim.isAt("sound")) {
                entity.playSound((SoundEvent)RuneCraftorySounds.ENTITY_AMBROSIA_SPAWN.get(), 1.0f, 0.8f + (entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.2f);
            }
        });
        b.put((Object)ANGRY, (anim, entity) -> {
            if (anim.isAt("sound")) {
                entity.playSound((SoundEvent)RuneCraftorySounds.ENTITY_AMBROSIA_ANGRY.get(), 1.0f, 1.0f + (entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.2f);
            }
        });
    });
    private final AnimationHandler<Ambrosia> animationHandler = new AnimationHandler((Entity)this, ANIMS).withChangeListener(anim -> {
        if (!this.level().isClientSide && anim == null) {
            this.setMoveDirection(null);
        }
        return false;
    });

    public Ambrosia(EntityType<? extends Ambrosia> type, Level level) {
        super((EntityType<? extends BossMonster>)type, level);
    }

    @Override
    public RunecraftoryBossbar createBossBar() {
        return new RunecraftoryBossbar(RuneCraftoryEntities.AMBROSIA.getID(), this.getDisplayName(), BossEvent.BossBarColor.GREEN, BossEvent.BossBarOverlay.PROGRESS).setMusic((SoundEvent)RuneCraftorySounds.AMBROSIA_FIGHT.get());
    }

    @Override
    protected void definedAdditinoalSyncedData(SyncedDataContainer.Builder<BaseMonster> builder) {
        super.definedAdditinoalSyncedData(builder);
        builder.define(MOVE_DIRECTION, (SyncedEntityData)TenshilibSyncableEntityDatas.VEC_3.get(), null);
    }

    @Override
    protected void applyAttributes() {
        this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.29);
        super.applyAttributes();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(MonsterBehaviourUtils.checkedAttack(AnimationPlayHolder.builder((String)KICK_1).start(KICK_2).chain(KICK_3).build())).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(7.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((e, t) -> Float.valueOf(1.2f))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement()}).end(7).start(MonsterBehaviourUtils.checkedAttack(SLEEP)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(7.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((e, t) -> Float.valueOf(1.2f)).closeEnoughDist(MonsterBehaviourUtils.closeEnough(1))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement()}).end(10).start(MonsterBehaviourUtils.checkedAttack(WAVE)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(20.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((e, t) -> Float.valueOf(1.2f)).closeEnoughDist(MonsterBehaviourUtils.closeEnough(8))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement()}).end(10).start(MonsterBehaviourUtils.checkedAttack(BUTTERFLY)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(24.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetAwayFromTarget().speedMod(1.1f).radius(8.0)}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(8).start(MonsterBehaviourUtils.checkedAttack(AnimationPlayHolder.builder((String)POLLEN).start(POLLEN_2).build())).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.and(BossMonster::isEnraged, MonsterBehaviourUtils.ifCloserThan(10.0))).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((e, t) -> Float.valueOf(1.2f)).closeEnoughDist(MonsterBehaviourUtils.closeEnough(3))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement()}).end(9).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(1, new ExtendedBehaviour[]{new StrafeTarget().strafeDistance(10.0f)}).build();
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        return !this.getAnimationHandler().isCurrent(new String[]{WAVE}) && super.hurt(source, amount);
    }

    @Override
    public boolean shouldFreezeTravel() {
        return this.getAnimationHandler().isCurrent(new String[]{WAVE});
    }

    @Override
    protected Vec3 directionToLookAt() {
        if (this.getAnimationHandler().isCurrent(new String[]{POLLEN, POLLEN_2})) {
            return this.getMoveDirection();
        }
        return super.directionToLookAt();
    }

    @Override
    public void setupAttack(AnimationDefinition anim) {
        super.setupAttack(anim);
        if (anim.is(new String[]{BUTTERFLY}) && this.getTarget() != null) {
            LivingEntity target = this.getTarget();
            this.setTargetPosition(new TargetPosition(target.position(), target.getY(), target.getY() + (double)target.getBbHeight() * 0.3));
        }
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimationState anim, Vec3 target, double grow) {
        if (anim.is(new String[]{POLLEN})) {
            return new OrientedBoundingBox(OrientedBoundingBox.originAABB((Entity)this).inflate(grow + 2.0, grow, grow + 2.0), this.getYRot(), this.getXRot(), this.position());
        }
        return super.calculateAttackAABB(anim, target, grow);
    }

    @Override
    public AABB attackBB(AnimationState anim) {
        double width = (double)this.getBbWidth() * 1.6;
        double length = (double)this.getBbWidth() * 2.1;
        return new AABB(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.getBbHeight() + 0.02, length);
    }

    @Override
    public void handleAttack(AnimationState anim) {
        BiConsumer handler = (BiConsumer)ATTACK_HANDLER.get((Object)anim.getID());
        if (handler != null) {
            handler.accept(anim, this);
        }
    }

    public AnimationHandler<Ambrosia> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (command == 2) {
                if (this.getProp().rideActionCosts.canRun(command, (Entity)this.getControllingPassenger(), (Spell)RuneCraftorySpells.WAVE.get())) {
                    this.getAnimationHandler().setAnimation(WAVE);
                }
            } else if (command == 1) {
                if (this.getProp().rideActionCosts.canRun(command, (Entity)this.getControllingPassenger(), (Spell)RuneCraftorySpells.SLEEP_BALLS.get())) {
                    this.getAnimationHandler().setAnimation(SLEEP);
                }
            } else if (this.getProp().rideActionCosts.canRun(command, (Entity)this.getControllingPassenger(), null)) {
                this.getAnimationHandler().setAnimation(KICK_1);
            }
        }
    }

    protected void playStepSound(BlockPos pos, BlockState blockIn) {
    }

    public void push(double x, double y, double z) {
        if (this.getAnimationHandler().isCurrent(new String[]{POLLEN, ANGRY, DEFEAT})) {
            return;
        }
        super.push(x, y, z);
    }

    public Vec3 getMoveDirection() {
        return (Vec3)this.getDataContainer().get(MOVE_DIRECTION);
    }

    public void setMoveDirection(Vec3 direction) {
        this.getDataContainer().set(MOVE_DIRECTION, (Object)direction);
    }

    @Override
    public String getInteractAnimation() {
        return INTERACT;
    }

    @Override
    public String getSpawnAnimation() {
        return SPAWN;
    }

    @Override
    public String getAngryAnimation() {
        return ANGRY;
    }

    @Override
    public String getDeathAnimation() {
        return DEFEAT;
    }
}

