/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster.boss;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.BossMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.entities.utils.RunecraftoryBossbar;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.spells.ElementBallBarrageSpell;
import io.github.flemmli97.runecraftory.common.spells.SlashSpell;
import io.github.flemmli97.runecraftory.common.spells.WaterLaserSpell;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetAwayFromTarget;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetWithinDist;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.data.AnimationPlayHolder;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedDataContainer;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedEntityData;
import io.github.flemmli97.tenshilib.common.registry.TenshilibSyncableEntityDatas;
import io.github.flemmli97.tenshilib.common.utils.TypedResource;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;

public class Chimera
extends BossMonster {
    public static final TypedResource<Vec3> CHARGE_MOTION = new TypedResource(RuneCraftory.modRes("charge_motion"));
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String LEAP = BUILDER.add("leap", AnimationsBuilder.definition((double)1.68).marker("attack_start", new double[]{0.36}).marker("attack_end", new double[]{1.44}));
    public static final String FIRE_TAIL_BUBBLE = BUILDER.add("tail_beam", AnimationsBuilder.definition((double)1.48).marker("attack", new double[]{0.44}));
    public static final String WATER_TAIL_BUBBLE = BUILDER.add("water_tail_bubble", FIRE_TAIL_BUBBLE);
    public static final String WATER_TAIL_BEAM = BUILDER.add("water_tail_beam", FIRE_TAIL_BUBBLE);
    public static final String FIRE_BREATH = BUILDER.add("breath_attack", AnimationsBuilder.definition((double)1.24).marker("attack", new double[]{0.48}));
    public static final String BUBBLE_BEAM = BUILDER.add("bubble_beam", FIRE_BREATH);
    public static final String SLASH = BUILDER.add("claw_attack", AnimationsBuilder.definition((double)0.76).marker("attack", new double[]{0.48}));
    public static final String INTERACT = BUILDER.add("interact", SLASH);
    public static final String BITE = BUILDER.add("bite_attack", AnimationsBuilder.definition((double)1.04).marker("attack_1", new double[]{0.4}).marker("attack_2", new double[]{0.76}));
    public static final String SLEEP = BUILDER.add("sleep", AnimationsBuilder.definition((double)0.0).infinite());
    public static final String SPAWN = BUILDER.add("spawn", AnimationsBuilder.definition((double)2.0).marker("sound", new double[]{0.32}));
    public static final String ANGRY = BUILDER.add("angry", AnimationsBuilder.definition((double)2.0).marker("sound", new double[]{0.32}));
    public static final String DEFEAT = BUILDER.add("defeat", AnimationsBuilder.definition((double)DEATH_DURATION, (boolean)false).infinite());
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private static final ImmutableMap<String, BiConsumer<AnimationState, Chimera>> ATTACK_HANDLER = Chimera.createAnimationHandler(b -> {
        BiConsumer<AnimationState, Chimera> summonFire = (anim, entity) -> {
            if (!anim.isPast("attack") && entity.getTarget() != null) {
                entity.setTargetPosition(entity.getTarget());
            }
            if (anim.isAt("attack")) {
                ((ElementBallBarrageSpell)RuneCraftorySpells.FIREBALL_BARRAGE.get()).use((LivingEntity)entity);
            }
        };
        b.put((Object)FIRE_TAIL_BUBBLE, summonFire);
        b.put((Object)FIRE_BREATH, summonFire);
        BiConsumer<AnimationState, Chimera> summonWater = (anim, entity) -> {
            if (!anim.isPast("attack") && entity.getTarget() != null) {
                entity.setTargetPosition(entity.getTarget());
            }
            if (anim.isAt("attack")) {
                ((ElementBallBarrageSpell)RuneCraftorySpells.BUBBLE_BEAM.get()).use((LivingEntity)entity);
            }
        };
        b.put((Object)BUBBLE_BEAM, summonWater);
        b.put((Object)WATER_TAIL_BUBBLE, summonWater);
        b.put((Object)WATER_TAIL_BEAM, (anim, entity) -> {
            if (!anim.isPast("attack") && entity.getTarget() != null) {
                entity.setTargetPosition(entity.getTarget());
            }
            if (anim.isAt("attack")) {
                ((WaterLaserSpell)RuneCraftorySpells.WATER_LASER.get()).use((LivingEntity)entity);
            }
        });
        b.put((Object)LEAP, (anim, entity) -> {
            if (anim.isPast("attack_start") && !anim.isPast("attack_end")) {
                Vec3 dir;
                if (entity.hitEntity == null) {
                    entity.hitEntity = new ArrayList<LivingEntity>();
                }
                if (entity.getChargeMotion() == null) {
                    dir = EntityUtils.getTargetDirection((Mob)entity, EntityAnchorArgument.Anchor.FEET, true).scale(0.5);
                    entity.setChargeMotion(new Vec3(dir.x, 0.0, dir.z));
                }
                dir = entity.getChargeMotion();
                entity.setDeltaMovement(dir.x, entity.getDeltaMovement().y, dir.z);
                entity.mobAttack((AnimationState)anim, null, e -> {
                    if (!entity.hitEntity.contains(e) && CombatUtils.mobAttack((LivingEntity)entity, (Entity)e, new DynamicDamage.Builder((Entity)entity).hurtResistant(5).knock(DynamicDamage.KnockBackType.UP, 0.4f))) {
                        entity.chargeAttackSuccess = true;
                        entity.hitEntity.add((LivingEntity)e);
                    }
                });
            }
        });
        b.put((Object)SLASH, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((SlashSpell)RuneCraftorySpells.SLASH.get()).use((LivingEntity)entity);
            }
        });
        b.put((Object)BITE, (anim, entity) -> {
            if (anim.isAt("attack_1")) {
                entity.mobAttack((AnimationState)anim, entity.getTarget(), e -> CombatUtils.mobAttack((LivingEntity)entity, (Entity)e, new DynamicDamage.Builder((Entity)entity).hurtResistant(5).noKnockback()));
            } else if (anim.isAt("attack_2")) {
                entity.mobAttack((AnimationState)anim, entity.getTarget(), entity::doHurtTarget);
            }
        });
        BiConsumer<AnimationState, Chimera> trigger = (anim, entity) -> {
            if (anim.isAt("sound")) {
                entity.playSound((SoundEvent)RuneCraftorySounds.ENTITY_CHIMERA_ROAR.get(), 1.0f, 1.0f + (entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.2f);
            }
        };
        b.put((Object)SPAWN, trigger);
        b.put((Object)ANGRY, trigger);
    });
    private final AnimationHandler<Chimera> animationHandler = new AnimationHandler((Entity)this, ANIMS).withChangeListener(anim -> {
        if (!this.level().isClientSide) {
            if (anim == null) {
                this.setChargeMotion(null);
            } else if (anim.is(new String[]{LEAP})) {
                this.chargeAttackSuccess = false;
            }
            this.hitEntity = null;
            return false;
        }
        return false;
    });
    protected boolean chargeAttackSuccess;
    protected List<LivingEntity> hitEntity;

    public Chimera(EntityType<? extends Chimera> type, Level level) {
        super((EntityType<? extends BossMonster>)type, level);
    }

    @Override
    public RunecraftoryBossbar createBossBar() {
        return new RunecraftoryBossbar(RuneCraftoryEntities.CHIMERA.getID(), this.getDisplayName(), BossEvent.BossBarColor.BLUE, BossEvent.BossBarOverlay.PROGRESS).setMusic((SoundEvent)RuneCraftorySounds.CHIMERA_FIGHT.get());
    }

    @Override
    protected void definedAdditinoalSyncedData(SyncedDataContainer.Builder<BaseMonster> builder) {
        super.definedAdditinoalSyncedData(builder);
        builder.define(CHARGE_MOTION, (SyncedEntityData)TenshilibSyncableEntityDatas.VEC_3.get(), null);
    }

    @Override
    protected void applyAttributes() {
        this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.31);
        this.getAttribute(Attributes.STEP_HEIGHT).setBaseValue(((Attribute)Attributes.STEP_HEIGHT.value()).getDefaultValue() + 1.0);
        super.applyAttributes();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(MonsterBehaviourUtils.checkedAttack(AnimationPlayHolder.builder((String)LEAP).start(BITE, m -> m.chargeAttackSuccess).build())).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(12.0)).end(10).start(MonsterBehaviourUtils.checkedAttack(FIRE_TAIL_BUBBLE)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(18.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().speedMod((e, t) -> Float.valueOf(1.1f)).min(4.0).max(10.0)}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(8).start(MonsterBehaviourUtils.checkedAttack(FIRE_TAIL_BUBBLE)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(18.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().speedMod((e, t) -> Float.valueOf(1.1f)).min(4.0).max(10.0)}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(8).start(MonsterBehaviourUtils.checkedAttack(WATER_TAIL_BUBBLE)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(18.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().speedMod((e, t) -> Float.valueOf(1.1f)).min(4.0).max(10.0)}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(8).start(MonsterBehaviourUtils.checkedAttack(WATER_TAIL_BEAM)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(18.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().speedMod((e, t) -> Float.valueOf(1.1f)).min(4.0).max(10.0)}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(8).start(MonsterBehaviourUtils.checkedAttack(BUBBLE_BEAM)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(18.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().speedMod((e, t) -> Float.valueOf(1.1f)).min(4.0).max(10.0)}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(8).start(MonsterBehaviourUtils.checkedAttack(SLASH)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(10.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((e, t) -> Float.valueOf(1.1f))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement()}).end(10).start(MonsterBehaviourUtils.checkedAttack(SLASH)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(5.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((e, t) -> Float.valueOf(1.1f))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement()}).end(15).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(10, new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((e, t) -> Float.valueOf(1.1f)), MonsterBehaviourUtils.moveTo()}).add(7, MonsterBehaviourUtils.ifCloserThan(12.0), new ExtendedBehaviour[]{new SetWalkTargetAwayFromTarget().radius(4.0).speedMod((e, t) -> Float.valueOf(1.1f)), MonsterBehaviourUtils.moveTo()}).build();
    }

    @Override
    protected ExtendedBehaviour<? extends BaseMonster> getWanderBehaviour() {
        return new SetRandomWalkTarget().speedModifier(0.7f);
    }

    @Override
    public double sprintSpeedThreshold() {
        return 0.9;
    }

    public void push(double x, double y, double z) {
        if (this.getAnimationHandler().isCurrent(new String[]{LEAP})) {
            return;
        }
        super.push(x, y, z);
    }

    @Override
    protected Vec3 directionToLookAt() {
        if (this.getAnimationHandler().isCurrent(new String[]{LEAP})) {
            return this.getChargeMotion();
        }
        return super.directionToLookAt();
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimationState anim, Vec3 target, double grow) {
        Vec3 dir;
        if (anim.is(new String[]{LEAP})) {
            return new OrientedBoundingBox(OrientedBoundingBox.originAABB((Entity)this).inflate(0.3, 0.1, 0.3 + this.getDeltaMovement().scale(0.3).length()), this.getYRot(), 0.0f, this.position());
        }
        if (!anim.is(new String[]{BITE})) {
            return super.calculateAttackAABB(anim, target, grow);
        }
        double reach = (double)this.getBbWidth() * 0.9;
        float offset = anim.isAt("attack_1") ? 45.0f : -5.0f;
        LivingEntity livingEntity = this.getControllingPassenger();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            dir = Vec3.directionFromRotation((float)player.getXRot(), (float)(player.getYRot() + offset));
        } else if (target != null) {
            reach = Math.min(reach, this.position().distanceTo(target));
            dir = target.subtract(this.position()).normalize().yRot(offset * ((float)Math.PI / 180));
        } else {
            dir = Vec3.directionFromRotation((float)this.getXRot(), (float)(this.getYRot() + offset));
        }
        Vec3 attackPos = this.position().add(dir.scale(reach));
        return new OrientedBoundingBox(this.attackBB(anim).inflate(grow, 0.0, grow), this.getYRot() + 45.0f, 0.0f, attackPos);
    }

    @Override
    public AABB attackBB(AnimationState anim) {
        double width = (double)this.getBbWidth() * 1.6;
        double length = (double)this.getBbWidth() * 1.7;
        if (anim.is(new String[]{BITE})) {
            width = (double)this.getBbWidth() * 1.2;
            length = (double)this.getBbWidth() * 1.3;
        }
        return new AABB(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.getBbHeight() + 0.02, length);
    }

    @Override
    public void handleAttack(AnimationState anim) {
        BiConsumer handler = (BiConsumer)ATTACK_HANDLER.get((Object)anim.getID());
        if (handler != null) {
            handler.accept(anim, this);
        }
    }

    public AnimationHandler<Chimera> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (command == 2) {
                if (this.getProp().rideActionCosts.canRun(command, (Entity)this.getControllingPassenger(), (Spell)RuneCraftorySpells.BUBBLE_BEAM.get())) {
                    this.getAnimationHandler().setAnimation(BUBBLE_BEAM);
                }
            } else if (command == 1) {
                if (this.getProp().rideActionCosts.canRun(command, (Entity)this.getControllingPassenger(), (Spell)RuneCraftorySpells.SLASH.get())) {
                    this.getAnimationHandler().setAnimation(SLASH);
                }
            } else if (this.getProp().rideActionCosts.canRun(command, (Entity)this.getControllingPassenger(), null)) {
                this.getAnimationHandler().setAnimation(LEAP);
            }
        }
    }

    @Override
    public double ridingSpeedModifier() {
        return 1.5;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)RuneCraftorySounds.ENTITY_CHIMERA_AMBIENT.get();
    }

    public Vec3 getChargeMotion() {
        return (Vec3)this.getDataContainer().get(CHARGE_MOTION);
    }

    public void setChargeMotion(Vec3 direction) {
        this.getDataContainer().set(CHARGE_MOTION, (Object)direction);
    }

    @Override
    public String getInteractAnimation() {
        return INTERACT;
    }

    @Override
    public String getSleepAnimation() {
        return SLEEP;
    }

    @Override
    public String getSpawnAnimation() {
        return SPAWN;
    }

    @Override
    public String getAngryAnimation() {
        return ANGRY;
    }

    @Override
    public String getDeathAnimation() {
        return DEFEAT;
    }
}

