/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster.boss;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.BossMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.entities.ai.control.FreeMoveControl;
import io.github.flemmli97.runecraftory.common.entities.ai.pathing.FloatingFlyNavigator;
import io.github.flemmli97.runecraftory.common.entities.utils.BoundEntityListHandler;
import io.github.flemmli97.runecraftory.common.entities.utils.BoundEntityListListener;
import io.github.flemmli97.runecraftory.common.entities.utils.RunecraftoryBossbar;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.network.S2CScreenShake;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.spells.BigPlateSpell;
import io.github.flemmli97.runecraftory.common.spells.DarkBeamSpell;
import io.github.flemmli97.runecraftory.common.spells.DarkBulletsSpell;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.utils.MathsHelper;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetWithinDist;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedDataContainer;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedEntityData;
import io.github.flemmli97.tenshilib.common.registry.TenshilibSyncableEntityDatas;
import io.github.flemmli97.tenshilib.common.utils.TypedResource;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import java.util.function.BiConsumer;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.StrafeTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;

public class Handonetta
extends BossMonster
implements BoundEntityListListener {
    public static final TypedResource<Vec3> MOVE_DIRECTION = new TypedResource(RuneCraftory.modRes("move_direction"));
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String SWIPE = BUILDER.add("swipe", AnimationsBuilder.definition((double)1.28).marker("attack", new double[]{0.64}));
    public static final String INTERACT = BUILDER.add("interact", SWIPE);
    public static final String FLICK = BUILDER.add("flick", AnimationsBuilder.definition((double)1.32).marker("attack", new double[]{0.64}));
    public static final String SHOOT = BUILDER.add("shoot", AnimationsBuilder.definition((double)1.52).marker("attack", new double[]{0.44}));
    public static final String LASER = BUILDER.add("laser", AnimationsBuilder.definition((double)1.24).marker("aim", new double[]{0.3}).marker("attack", new double[]{0.4}));
    public static final String PLATE = BUILDER.add("plate", AnimationsBuilder.definition((double)0.88).marker("attack", new double[]{0.56}));
    public static final String GRAB = BUILDER.add("grab", AnimationsBuilder.definition((double)1.2).marker("attack", new double[]{0.56}).marker("invis_start", new double[]{0.72}).marker("grab_done", new double[]{1.04}));
    public static final String GRAB_CAUGHT = BUILDER.add("grab_caught", AnimationsBuilder.definition((double)1.96).marker("attack", new double[]{0.12, 0.6, 1.04, 1.48}).marker("attack_end", new double[]{1.8}));
    public static final String PUNCH = BUILDER.add("punch", AnimationsBuilder.definition((double)1.2).marker("attack_start", new double[]{0.28}).marker("attack_end", new double[]{1.04}));
    public static final String SPAWN = BUILDER.add("spawn", AnimationsBuilder.definition((double)2.0).marker("sound", new double[]{0.6}));
    public static final String ANGRY = BUILDER.add("angry", AnimationsBuilder.definition((double)2.0).marker("sound", new double[]{0.6}));
    public static final String DEFEAT = BUILDER.add("defeat", AnimationsBuilder.definition((double)DEATH_DURATION, (boolean)false).infinite());
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private static final ImmutableMap<String, BiConsumer<AnimationState, Handonetta>> ATTACK_HANDLER = Handonetta.createAnimationHandler(b -> {
        b.put((Object)SWIPE, (anim, entity) -> {
            LivingEntity target = entity.getTarget();
            entity.getNavigation().stop();
            if (anim.isAt("attack")) {
                entity.mobAttack((AnimationState)anim, target, entity::doHurtTarget);
            }
        });
        b.put((Object)FLICK, (anim, entity) -> {
            LivingEntity target = entity.getTarget();
            entity.getNavigation().stop();
            if (anim.isAt("attack")) {
                entity.mobAttack((AnimationState)anim, target, entity::doHurtTarget);
            }
        });
        b.put((Object)PUNCH, (anim, entity) -> {
            entity.getNavigation().stop();
            if (entity.getMoveDirection() == null) {
                entity.setMoveDirection(EntityUtils.getTargetDirection((Mob)entity, EntityAnchorArgument.Anchor.FEET).scale(0.75));
                entity.caughtEntities.clear();
            }
            entity.setDeltaMovement(entity.getMoveDirection());
            if (anim.isPast("attack_start") && !anim.isPast("attack_end")) {
                entity.mobAttack((AnimationState)anim, null, e -> {
                    if (!entity.caughtEntities.has((LivingEntity)e) && CombatUtils.mobAttack((LivingEntity)entity, (Entity)e, new DynamicDamage.Builder((Entity)entity).hurtResistant(8))) {
                        entity.caughtEntities.add((LivingEntity)e);
                        S2CScreenShake.sendAround((Entity)entity, 32.0, 4, 2.0f);
                    }
                });
            }
        });
        b.put((Object)SHOOT, (anim, entity) -> {
            entity.getNavigation().stop();
            if (anim.isAt("attack")) {
                ((DarkBulletsSpell)RuneCraftorySpells.DARK_BULLETS.get()).use((LivingEntity)entity);
            }
        });
        b.put((Object)LASER, (anim, entity) -> {
            entity.getNavigation().stop();
            if (entity.getTarget() != null && !anim.isPast("aim")) {
                entity.setTargetPosition(entity.getTarget());
            }
            if (anim.isAt("attack")) {
                ((DarkBeamSpell)RuneCraftorySpells.DARK_BEAM.get()).use((LivingEntity)entity);
            }
        });
        b.put((Object)PLATE, (anim, entity) -> {
            entity.getNavigation().stop();
            if (anim.isAt("attack")) {
                ((BigPlateSpell)RuneCraftorySpells.PLATE.get()).use((LivingEntity)entity);
            }
        });
        b.put((Object)GRAB, (anim, entity) -> {
            entity.getNavigation().stop();
            if (entity.getMoveDirection() == null) {
                entity.setMoveDirection(EntityUtils.getTargetDirection((Mob)entity, EntityAnchorArgument.Anchor.FEET).scale(0.45));
            }
            entity.setDeltaMovement(entity.getMoveDirection());
            if (anim.isPast("grab_done")) {
                if (!entity.caughtEntities.isEmpty()) {
                    entity.getAnimationHandler().setAnimation(GRAB_CAUGHT);
                }
            } else if (anim.isPast("attack") && !anim.isPast("grab_done")) {
                entity.mobAttack((AnimationState)anim, null, e -> {
                    if (!entity.getType().is(RunecraftoryTags.EntityTypes.HANDONETTA_GRAP_IGNORE) && !entity.caughtEntities.has((LivingEntity)e)) {
                        entity.catchEntity((LivingEntity)e);
                    }
                });
            }
        });
        b.put((Object)GRAB_CAUGHT, (anim, entity) -> {
            entity.getNavigation().stop();
            entity.setDeltaMovement(entity.getDeltaMovement().scale(0.1));
            if (anim.isAt("attack")) {
                entity.caughtEntities.forEach(entity::doHurtTarget);
                S2CScreenShake.sendAround((Entity)entity, 24.0, 4, 1.0f);
            }
            if (anim.isPast("attack_end") && !entity.caughtEntities.isEmpty()) {
                Platform.INSTANCE.getEntityData((LivingEntity)entity).setInvis(0);
                entity.caughtEntities.clear();
            }
        });
        BiConsumer<AnimationState, Handonetta> trigger = (anim, entity) -> {
            if (anim.isAt("sound")) {
                entity.playSound((SoundEvent)RuneCraftorySounds.ENTITY_HANDONETTA_ROAR.get(), 1.0f, 1.0f + (entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.2f);
            }
        };
        b.put((Object)SPAWN, trigger);
        b.put((Object)ANGRY, trigger);
    });
    private final AnimationHandler<Handonetta> animationHandler = new AnimationHandler((Entity)this, ANIMS).withChangeListener(anim -> {
        this.setMoveDirection(null);
        if (anim != null) {
            this.setDeltaMovement(this.getDeltaMovement().scale(0.1));
        }
        return false;
    });
    private final BoundEntityListHandler<Handonetta> caughtEntities = new BoundEntityListHandler<Handonetta>(this);

    public Handonetta(EntityType<? extends Handonetta> type, Level level) {
        super((EntityType<? extends BossMonster>)type, level);
        this.setNoGravity(true);
        this.moveControl = new HandonettaMoveController((Mob)this);
    }

    @Override
    public RunecraftoryBossbar createBossBar() {
        return new RunecraftoryBossbar(RuneCraftoryEntities.HANDONETTA.getID(), this.getDisplayName(), BossEvent.BossBarColor.WHITE, BossEvent.BossBarOverlay.PROGRESS).setMusic((SoundEvent)RuneCraftorySounds.HANDONETTA_FIGHT.get());
    }

    @Override
    protected void definedAdditinoalSyncedData(SyncedDataContainer.Builder<BaseMonster> builder) {
        super.definedAdditinoalSyncedData(builder);
        builder.define(MOVE_DIRECTION, (SyncedEntityData)TenshilibSyncableEntityDatas.VEC_3.get(), null);
    }

    @Override
    protected PathNavigation createNavigation(Level level) {
        return new FloatingFlyNavigator((Mob)this, level);
    }

    @Override
    protected void applyAttributes() {
        this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.26);
        this.getAttribute(Attributes.FOLLOW_RANGE).setBaseValue(32.0);
        this.getAttribute(Attributes.FLYING_SPEED).setBaseValue(0.32);
        super.applyAttributes();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(MonsterBehaviourUtils.checkedAttack(SWIPE)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(7.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((e, t) -> Float.valueOf(1.1f))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement()}).end(11).start(MonsterBehaviourUtils.checkedAttack(FLICK)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(7.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((e, t) -> Float.valueOf(1.1f))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement()}).end(11).start(MonsterBehaviourUtils.checkedAttack(PUNCH)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(20.0)).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(10).start(MonsterBehaviourUtils.checkedAttack(LASER)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(20.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(4.0).max(12.0)}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(10).start(MonsterBehaviourUtils.checkedAttack(PLATE)).play(MonsterBehaviourUtils.cooldownedPlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(3.0).max(14.0)}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(9).start(MonsterBehaviourUtils.checkedAttack(GRAB)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifCloserThan(16.0).and(BossMonster::isEnraged)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(MonsterBehaviourUtils.closeEnough(7))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(8).start(MonsterBehaviourUtils.checkedAttack(SHOOT)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.and(BossMonster::isEnraged, MonsterBehaviourUtils.ifCloserThan(16.0))).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(3.0).max(11.0)}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(8).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(1, new ExtendedBehaviour[]{new StrafeTarget().strafeDistance(12.0f)}).build();
    }

    @Override
    public void travel(Vec3 vec) {
        this.handleFreeTravel(vec);
    }

    public void push(Entity entityIn) {
        if (this.getAnimationHandler().isCurrent(new String[]{PUNCH, GRAB})) {
            return;
        }
        super.push(entityIn);
    }

    public void push(double x, double y, double z) {
        if (this.getAnimationHandler().isCurrent(new String[]{ANGRY, DEFEAT})) {
            return;
        }
        super.push(x, y, z);
    }

    @Override
    public void baseTick() {
        super.baseTick();
        if (this.getAnimationHandler().isCurrent(new String[]{GRAB, GRAB_CAUGHT})) {
            boolean invis = this.getAnimationHandler().isCurrent(new String[]{GRAB}) ? this.getAnimationHandler().getAnimation().isPast("invis_start") : this.getAnimationHandler().isCurrent(new String[]{GRAB_CAUGHT});
            this.caughtEntities.forEach(entity -> {
                if (entity.isAlive()) {
                    entity.setDeltaMovement(Vec3.ZERO);
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)entity;
                        player.moveTo(this.getX(), this.getY(0.5), this.getZ());
                    } else {
                        entity.setPos(this.getX(), this.getY(0.5), this.getZ());
                    }
                    if (invis) {
                        Platform.INSTANCE.getEntityData((LivingEntity)entity).setInvis(10);
                    }
                    entity.hurtMarked = true;
                }
            });
        }
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        LivingEntity living;
        Entity entity;
        if (this.getAnimationHandler().isCurrent(new String[]{GRAB, GRAB_CAUGHT}) && (entity = source.getEntity()) instanceof LivingEntity && this.caughtEntities.has(living = (LivingEntity)entity)) {
            return false;
        }
        return super.hurt(source, amount);
    }

    @Override
    protected Vec3 directionToLookAt() {
        if (this.getAnimationHandler().isCurrent(new String[]{PUNCH, GRAB})) {
            return this.getMoveDirection();
        }
        return super.directionToLookAt();
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimationState anim, Vec3 target, double grow) {
        Vec3 dir = this.getMoveDirection();
        if (dir == null) {
            dir = target != null ? target.subtract(this.position()) : this.getViewVector(1.0f);
        }
        if (anim.is(new String[]{PUNCH})) {
            float[] rots = MathsHelper.YXRotFrom(dir);
            return new OrientedBoundingBox(OrientedBoundingBox.originAABB((Entity)this).inflate(grow + 0.2, grow, grow + 1.2), rots[0], rots[1], this.position());
        }
        if (anim.is(new String[]{GRAB})) {
            float[] rots = MathsHelper.YXRotFrom(dir);
            return new OrientedBoundingBox(OrientedBoundingBox.originAABB((Entity)this).inflate(grow + 0.5, 0.0, grow + 1.0), rots[0], rots[1], this.position());
        }
        return super.calculateAttackAABB(anim, target, grow).inflate(0.0, grow * 2.0, 0.0);
    }

    @Override
    public AABB attackBB(AnimationState anim) {
        double width = (double)this.getBbWidth() * 2.2;
        double length = (double)this.getBbWidth() * 1.7;
        if (anim.is(new String[]{FLICK})) {
            width = (double)this.getBbWidth() * 1.6;
            length = (double)this.getBbWidth() * 1.8;
        }
        return new AABB(-width * 0.5, -0.5, 0.0, width * 0.5, (double)this.getBbHeight() + 0.5, length);
    }

    @Override
    public void handleAttack(AnimationState anim) {
        BiConsumer handler = (BiConsumer)ATTACK_HANDLER.get((Object)anim.getID());
        if (handler != null) {
            handler.accept(anim, this);
        }
    }

    @Override
    public DynamicDamage.Builder damageSourceAttack() {
        DynamicDamage.Builder builder = super.damageSourceAttack();
        if (this.getAnimationHandler().isCurrent(new String[]{SWIPE})) {
            builder.knock(DynamicDamage.KnockBackType.BACK, 1.2f);
        }
        if (this.getAnimationHandler().isCurrent(new String[]{FLICK})) {
            builder.knock(DynamicDamage.KnockBackType.UP, 0.9f);
        }
        return builder;
    }

    public AnimationHandler<Handonetta> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, (Entity)this.getControllingPassenger(), command == 2 ? (Spell)RuneCraftorySpells.DARK_BULLETS.get() : null)) {
                return;
            }
            if (command == 2) {
                this.getAnimationHandler().setAnimation(SHOOT);
            } else if (command == 1) {
                this.getAnimationHandler().setAnimation(FLICK);
            } else {
                this.getAnimationHandler().setAnimation(SWIPE);
            }
        }
    }

    @Override
    public void setEnraged(boolean flag, boolean load) {
        super.setEnraged(flag, load);
        if (flag && !load) {
            this.getAnimationHandler().setAnimation(ANGRY);
        }
    }

    protected void checkFallDamage(double y, boolean onGround, BlockState state, BlockPos pos) {
        super.checkFallDamage(y, false, state, pos);
    }

    private void catchEntity(LivingEntity entity) {
        this.caughtEntities.add(entity);
    }

    public Vec3 getMoveDirection() {
        return (Vec3)this.getDataContainer().get(MOVE_DIRECTION);
    }

    public void setMoveDirection(Vec3 direction) {
        this.getDataContainer().set(MOVE_DIRECTION, (Object)direction);
    }

    @Override
    public String getInteractAnimation() {
        return INTERACT;
    }

    @Override
    public String getSpawnAnimation() {
        return SPAWN;
    }

    @Override
    public String getAngryAnimation() {
        return ANGRY;
    }

    @Override
    public String getDeathAnimation() {
        return DEFEAT;
    }

    @Override
    public BoundEntityListHandler<?> getList() {
        return this.caughtEntities;
    }

    static class HandonettaMoveController
    extends FreeMoveControl {
        public HandonettaMoveController(Mob mob) {
            super(mob);
        }

        @Override
        public void tick() {
            MoveControl.Operation current = this.operation;
            super.tick();
            if (current == MoveControl.Operation.STRAFE && this.mob.getTarget() != null) {
                Vec3 target = this.mob.getTarget().position().add(0.0, (double)this.mob.getTarget().getBbHeight(), 0.0);
                Vec3 dist = this.mob.position().subtract(target);
                if (dist.y() < 3.0) {
                    this.mob.setYya(1.0f);
                } else {
                    this.mob.setYya(-1.0f);
                }
                if (dist.horizontalDistanceSqr() < 16.0) {
                    this.mob.setSpeed(this.mob.getSpeed() * 2.0f);
                    this.mob.setZza(-1.0f);
                    this.mob.setXxa(this.mob.xxa * 0.5f);
                }
            }
        }
    }
}

