/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster.boss;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.BossMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.entities.utils.RunecraftoryBossbar;
import io.github.flemmli97.runecraftory.common.network.S2CScreenShake;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.spells.BigLightningBoltSpell;
import io.github.flemmli97.runecraftory.common.spells.Laser5Spell;
import io.github.flemmli97.runecraftory.common.spells.LaserAOESpell;
import io.github.flemmli97.runecraftory.common.spells.WindBladeSpell;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.data.AnimationPlayHolder;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedDataContainer;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedEntityData;
import io.github.flemmli97.tenshilib.common.registry.TenshilibSyncableEntityDatas;
import io.github.flemmli97.tenshilib.common.utils.TypedResource;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.StrafeTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;

public class Thunderbolt
extends BossMonster {
    private static final float RANGE_THRESHOLD = 0.7f;
    private static final float FEINT_THRESHOLD = 0.35f;
    public static final TypedResource<Vec3> CHARGE_MOTION = new TypedResource(RuneCraftory.modRes("charge_motion"));
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String BACK_KICK = BUILDER.add("back_kick", AnimationsBuilder.definition((double)0.84).marker("attack", new double[]{0.56}));
    public static final String BACK_KICK_HORN = BUILDER.add("back_kick_horn", BACK_KICK);
    public static final String LASER_X5 = BUILDER.add("laser_x5", AnimationsBuilder.definition((double)1.52).marker("attack", new double[]{1.32}));
    public static final String LASER_AOE = BUILDER.add("laser_aoe", LASER_X5);
    public static final String STOMP = BUILDER.add("stomp", AnimationsBuilder.definition((double)0.6).marker("attack", new double[]{0.44}));
    public static final String INTERACT = BUILDER.add("interact", STOMP);
    public static final String HORN_ATTACK = BUILDER.add("horn_attack", AnimationsBuilder.definition((double)0.56).marker("attack", new double[]{0.4}));
    public static final String CHARGE = BUILDER.add("charge", AnimationsBuilder.definition((double)1.68).marker("attack_start", new double[]{0.6}).marker("attack_end", new double[]{1.24}));
    public static final String CHARGE_2 = BUILDER.add("charge_2", CHARGE);
    public static final String CHARGE_3 = BUILDER.add("charge_3", CHARGE);
    public static final String LASER_KICK = BUILDER.add("laser_kick", AnimationsBuilder.definition((double)1.32).marker("attack", new double[]{0.4}));
    public static final String LASER_KICK_2 = BUILDER.add("laser_kick_2", LASER_KICK);
    public static final String LASER_KICK_3 = BUILDER.add("laser_kick_3", LASER_KICK);
    public static final String WIND_BLADE = BUILDER.add("wind_blade", AnimationsBuilder.definition((double)0.8).marker("attack", new double[]{0.44}));
    public static final String FEINT = BUILDER.add("feint", AnimationsBuilder.definition((double)7.52).marker("neigh", new double[]{6.2}));
    public static final String SPAWN = BUILDER.add("spawn", AnimationsBuilder.definition((double)2.0).marker("sound", new double[]{0.44}));
    public static final String ANGRY = BUILDER.add("angry", AnimationsBuilder.definition((double)2.0).marker("sound", new double[]{0.44}));
    public static final String DEFEAT = BUILDER.add("defeat", AnimationsBuilder.definition((double)DEATH_DURATION, (boolean)false).infinite());
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private static final ImmutableMap<String, BiConsumer<AnimationState, Thunderbolt>> ATTACK_HANDLER = Thunderbolt.createAnimationHandler(b -> {
        BiConsumer<AnimationState, Thunderbolt> kick = (anim, entity) -> {
            LivingEntity target = entity.getTarget();
            if (anim.isAt("attack")) {
                entity.mobAttack((AnimationState)anim, target, e -> {
                    if (entity.doHurtTarget((Entity)e)) {
                        e.setDeltaMovement(0.0, 0.05, 0.0);
                        e.hasImpulse = true;
                        e.knockback((double)0.8f, entity.getX() - e.getX(), entity.getZ() - e.getZ());
                    }
                });
            }
        };
        b.put((Object)BACK_KICK, kick);
        b.put((Object)BACK_KICK_HORN, kick);
        b.put((Object)HORN_ATTACK, (anim, entity) -> {
            LivingEntity target = entity.getTarget();
            if (anim.isAt("attack")) {
                AtomicBoolean bool = new AtomicBoolean(false);
                entity.mobAttack((AnimationState)anim, target, e -> {
                    if (entity.doHurtTarget((Entity)e)) {
                        if (!bool.get()) {
                            bool.set(true);
                        }
                        e.setDeltaMovement(0.0, 0.65, 0.0);
                        e.hasImpulse = true;
                    }
                });
                if (bool.get() && !entity.isVehicle()) {
                    entity.hornAttackSuccess = true;
                }
            }
        });
        b.put((Object)STOMP, (anim, entity) -> {
            if (anim.isAt("attack")) {
                entity.mobAttack((AnimationState)anim, entity.getTarget(), entity::doHurtTarget);
            }
        });
        b.put((Object)WIND_BLADE, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((WindBladeSpell)RuneCraftorySpells.DOUBLE_SONIC.get()).use((LivingEntity)entity);
            }
        });
        b.put((Object)LASER_X5, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((Laser5Spell)RuneCraftorySpells.LASER5.get()).use((LivingEntity)entity);
            }
        });
        b.put((Object)LASER_AOE, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((LaserAOESpell)RuneCraftorySpells.LASER_AOE.get()).use((LivingEntity)entity);
            }
        });
        BiConsumer<AnimationState, Thunderbolt> bigLaser = (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((BigLightningBoltSpell)RuneCraftorySpells.BIG_LIGHTNING.get()).use((LivingEntity)entity);
            }
        };
        b.put((Object)LASER_KICK, bigLaser);
        b.put((Object)LASER_KICK_2, bigLaser);
        b.put((Object)LASER_KICK_3, bigLaser);
        BiConsumer<AnimationState, Thunderbolt> charge = (anim, entity) -> {
            if (entity.getChargeMotion() == null) {
                entity.setChargeMotion(EntityUtils.getTargetDirection((Mob)entity, EntityAnchorArgument.Anchor.FEET, true).scale(3.0));
            }
            if (anim.isAt("attack_start")) {
                Vec3 dir = entity.getChargeMotion();
                entity.setDeltaMovement(dir.x(), 0.25, dir.z());
            }
            if (anim.isPast("attack_start") && !anim.isPast("attack_end") && !entity.chargeAttackSuccess) {
                entity.mobAttack((AnimationState)anim, null, e -> {
                    if (entity.doHurtTarget((Entity)e)) {
                        entity.chargeAttackSuccess = true;
                        entity.setDeltaMovement(0.0, entity.getDeltaMovement().y, 0.0);
                    }
                });
            }
        };
        b.put((Object)CHARGE, charge);
        b.put((Object)CHARGE_2, charge);
        b.put((Object)CHARGE_3, charge);
        b.put((Object)FEINT, (anim, entity) -> {
            if (anim.isAt("neigh")) {
                entity.playSound((SoundEvent)RuneCraftorySounds.ENTITY_THUNDERBOLT_NEIGH.get(), 1.0f, (entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.2f + 1.0f);
            }
        });
        BiConsumer<AnimationState, Thunderbolt> trigger = (anim, entity) -> {
            if (anim.isAt("sound")) {
                entity.playSound((SoundEvent)RuneCraftorySounds.ENTITY_THUNDERBOLT_NEIGH.get(), 1.0f, (entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.2f + 1.0f);
            }
        };
        b.put((Object)SPAWN, trigger);
        b.put((Object)ANGRY, trigger);
    });
    private final AnimationHandler<Thunderbolt> animationHandler = new AnimationHandler((Entity)this, ANIMS).withChangeListener(anim -> {
        if (!this.level().isClientSide) {
            this.setChargeMotion(null);
            if (anim != null) {
                if (anim.is(new String[]{CHARGE, CHARGE_2, CHARGE_3})) {
                    this.chargeAttackSuccess = false;
                }
                if (anim.is(new String[]{HORN_ATTACK})) {
                    this.hornAttackSuccess = false;
                }
            }
        }
        return false;
    });
    protected boolean feintedDeath;
    protected boolean hornAttackSuccess;
    protected boolean chargeAttackSuccess;

    public Thunderbolt(EntityType<? extends BossMonster> type, Level level) {
        super(type, level);
    }

    @Override
    public RunecraftoryBossbar createBossBar() {
        return new RunecraftoryBossbar(RuneCraftoryEntities.THUNDERBOLT.getID(), this.getDisplayName(), BossEvent.BossBarColor.BLUE, BossEvent.BossBarOverlay.PROGRESS).setMusic((SoundEvent)RuneCraftorySounds.THUNDERBOLT_FIGHT.get());
    }

    @Override
    protected void definedAdditinoalSyncedData(SyncedDataContainer.Builder<BaseMonster> builder) {
        super.definedAdditinoalSyncedData(builder);
        builder.define(CHARGE_MOTION, (SyncedEntityData)TenshilibSyncableEntityDatas.VEC_3.get(), null);
    }

    @Override
    protected void applyAttributes() {
        this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.34);
        this.getAttribute(Attributes.STEP_HEIGHT).setBaseValue(((Attribute)Attributes.STEP_HEIGHT.value()).getDefaultValue() + 1.0);
        super.applyAttributes();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(MonsterBehaviourUtils.checkedAttack(BACK_KICK)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(m -> !m.feintedDeath && MonsterBehaviourUtils.ifCloserThan(5.0).test(m)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((e, t) -> Float.valueOf(1.2f))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement()}).end(10).start(MonsterBehaviourUtils.checkedAttack(STOMP)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(m -> !m.feintedDeath && MonsterBehaviourUtils.ifCloserThan(5.0).test(m)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((e, t) -> Float.valueOf(1.2f))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement()}).end(11).start(MonsterBehaviourUtils.checkedAttack(AnimationPlayHolder.builder((String)HORN_ATTACK).start(BACK_KICK, m -> m.hornAttackSuccess).build())).play(MonsterBehaviourUtils.cooldownedPlay()).condition(m -> !m.feintedDeath && MonsterBehaviourUtils.ifCloserThan(5.0).test(m)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((e, t) -> Float.valueOf(1.2f))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(9).start(MonsterBehaviourUtils.checkedAttack(LASER_X5)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(m -> !m.isEnraged() && !m.feintedDeath && MonsterBehaviourUtils.ifCloserThan(16.0).test(m)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(MonsterBehaviourUtils.closeEnough(8)).speedMod((e, t) -> Float.valueOf(1.2f))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(10).start(MonsterBehaviourUtils.checkedAttack(AnimationPlayHolder.builder((String)CHARGE).start(CHARGE_2, m -> !m.chargeAttackSuccess).build())).play(MonsterBehaviourUtils.cooldownedPlay()).condition(m -> !m.feintedDeath && MonsterBehaviourUtils.ifCloserThan(16.0).test(m)).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(9).start(MonsterBehaviourUtils.checkedAttack(LASER_AOE)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(m -> m.isEnraged() && !m.feintedDeath && MonsterBehaviourUtils.ifCloserThan(16.0).test(m)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(MonsterBehaviourUtils.closeEnough(8)).speedMod((e, t) -> Float.valueOf(1.2f))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(8).start(MonsterBehaviourUtils.checkedAttack(AnimationPlayHolder.builder((String)LASER_KICK).start(LASER_KICK_2).build())).play(MonsterBehaviourUtils.cooldownedPlay()).condition(m -> m.isEnraged() && !m.feintedDeath && MonsterBehaviourUtils.ifCloserThan(12.0).test(m)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(MonsterBehaviourUtils.closeEnough(8)).speedMod((e, t) -> Float.valueOf(1.2f))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement(50, 80)}).end(8).start(MonsterBehaviourUtils.checkedAttack(WIND_BLADE)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(m -> m.isEnraged() && !m.feintedDeath && MonsterBehaviourUtils.ifCloserThan(24.0).test(m)).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(7).start(MonsterBehaviourUtils.checkedAttack(WIND_BLADE)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(m -> m.isEnraged() && !m.feintedDeath && m.getTarget() != null && m.getTarget().getY() - m.getY() > 4.0 && MonsterBehaviourUtils.ifCloserThan(24.0).test(m)).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(10).start(MonsterBehaviourUtils.checkedAttack(LASER_AOE)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.and(Thunderbolt::afterFeint, MonsterBehaviourUtils.ifCloserThan(16.0))).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(MonsterBehaviourUtils.closeEnough(8)).speedMod((e, t) -> Float.valueOf(1.2f))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(7).start(MonsterBehaviourUtils.checkedAttack(AnimationPlayHolder.builder((String)CHARGE).start(CHARGE_2, m -> !m.chargeAttackSuccess).chain(CHARGE_3).build())).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.and(Thunderbolt::afterFeint, MonsterBehaviourUtils.ifCloserThan(16.0))).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(11).start(MonsterBehaviourUtils.checkedAttack(AnimationPlayHolder.builder((String)LASER_KICK).start(LASER_KICK_2).chain(LASER_KICK_3).build())).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.and(Thunderbolt::afterFeint, MonsterBehaviourUtils.ifCloserThan(16.0))).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(MonsterBehaviourUtils.closeEnough(8)).speedMod((e, t) -> Float.valueOf(1.2f))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement(50, 80)}).end(12).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(7, new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((e, t) -> Float.valueOf(1.1f)), MonsterBehaviourUtils.moveTo()}).add(10, new ExtendedBehaviour[]{new StrafeTarget().strafeDistance(8.0f)}).build();
    }

    @Override
    protected ExtendedBehaviour<? extends BaseMonster> getWanderBehaviour() {
        return new SetRandomWalkTarget().speedModifier(0.7f);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Feint", this.feintedDeath);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.feintedDeath = compound.getBoolean("Feint");
    }

    @Override
    public void setEnraged(boolean flag, boolean load) {
        if (flag && !load) {
            if (!this.isEnraged()) {
                this.getAnimationHandler().setAnimation(ANGRY);
                this.getNavigation().stop();
            } else {
                this.getAnimationHandler().setAnimation(FEINT);
                this.getNavigation().stop();
                this.feintDeath();
                this.bossInfo.setProgress(0.0f);
            }
        }
        super.setEnraged(flag, load);
    }

    @Override
    protected void updateBossBar() {
        if (!this.feintedDeath || this.getAnimationHandler().isCurrent(new String[]{FEINT})) {
            this.bossInfo.setProgress((this.getHealth() - this.getMaxHealth() * 0.35f) / (this.getMaxHealth() * 0.65f));
        } else {
            this.bossInfo.setProgress(this.getHealth() / this.getMaxHealth());
        }
    }

    @Override
    protected boolean checkRage() {
        if (this.getHealth() / this.getMaxHealth() < 0.35f) {
            return !this.feintedDeath;
        }
        if (this.getHealth() / this.getMaxHealth() < 0.7f) {
            return !this.isEnraged();
        }
        return false;
    }

    @Override
    protected void fullyHeal() {
        super.fullyHeal();
        this.feintedDeath = false;
    }

    private boolean afterFeint() {
        return !this.isTamed() && this.isEnraged() && this.feintedDeath;
    }

    @Override
    public void baseTick() {
        super.baseTick();
        if (this.getAnimationHandler().isCurrent(new String[]{FEINT}) && !this.isTamed()) {
            Vec3 delta = this.getDeltaMovement();
            int tick = (int)this.getAnimationHandler().getAnimation().getTick(1.0f);
            this.setDeltaMovement(0.0, delta.y, 0.0);
            if (tick < 50) {
                if (tick % 10 == 0) {
                    ++this.deathRays;
                    S2CScreenShake.sendAround((Entity)this, 24.0, 4, 1.0f);
                    this.level().playLocalSound((Entity)this, (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), this.getSoundSource(), 2.0f, 0.8f);
                }
            } else if (tick < 65) {
                if (tick % 5 == 0) {
                    ++this.deathRays;
                    S2CScreenShake.sendAround((Entity)this, 24.0, 4, 1.0f);
                    this.level().playLocalSound((Entity)this, (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), this.getSoundSource(), 2.0f, 0.8f);
                }
            } else if (tick > 100) {
                this.deathRays = 0;
            }
        }
    }

    @Override
    public double sprintSpeedThreshold() {
        return 0.9;
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        return !this.getAnimationHandler().isCurrent(new String[]{FEINT}) && super.hurt(source, amount);
    }

    @Override
    protected boolean isImmobile() {
        return super.isImmobile() || this.getAnimationHandler().isCurrent(new String[]{FEINT});
    }

    @Override
    public double ridingSpeedModifier() {
        return 1.5;
    }

    protected void feintDeath() {
        this.feintedDeath = true;
        this.getAnimationHandler().setAnimation(FEINT);
        STAT_INCREASE.forEach(att -> {
            AttributeInstance inst = this.getAttribute((Holder)att.get());
            inst.removeModifier(STAT_INCREASE_ID);
            inst.addPermanentModifier(new AttributeModifier(STAT_INCREASE_ID, 0.33, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        });
    }

    public boolean isAlive() {
        return super.isAlive() && (this.getAnimationHandler() == null || !this.getAnimationHandler().isCurrent(new String[]{FEINT, DEFEAT}));
    }

    public void push(double x, double y, double z) {
        if (this.getAnimationHandler().isCurrent(new String[]{FEINT, DEFEAT})) {
            return;
        }
        super.push(x, y, z);
    }

    @Override
    protected Vec3 directionToLookAt() {
        if (this.getAnimationHandler().isCurrent(new String[]{CHARGE, CHARGE_2, CHARGE_3})) {
            return this.getChargeMotion();
        }
        return super.directionToLookAt();
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimationState anim, Vec3 target, double grow) {
        if (anim.is(new String[]{STOMP})) {
            return new OrientedBoundingBox(OrientedBoundingBox.originAABB((Entity)this).inflate(1.7, -0.4, 1.7), this.getYRot(), 0.0f, this.position());
        }
        if (anim.is(new String[]{CHARGE, CHARGE_2, CHARGE_3})) {
            return new OrientedBoundingBox(OrientedBoundingBox.originAABB((Entity)this).inflate(grow + 1.0), this.getYRot(), 0.0f, this.position());
        }
        return super.calculateAttackAABB(anim, target, grow);
    }

    @Override
    public AABB attackBB(AnimationState anim) {
        double width = (double)this.getBbWidth() * 1.6;
        double length = (double)this.getBbWidth() * 1.5;
        if (anim.is(new String[]{HORN_ATTACK})) {
            width = (double)this.getBbWidth() * 1.3;
            length = (double)this.getBbWidth() * 1.8;
        }
        return new AABB(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.getBbHeight() + 0.02, length);
    }

    @Override
    public int animationCooldown(String anim) {
        int cooldown = super.animationCooldown(anim);
        if (anim != null && this.feintedDeath && (anim.equals(LASER_KICK) || anim.equals(LASER_AOE) || anim.equals(CHARGE))) {
            cooldown += 40;
        }
        return cooldown;
    }

    @Override
    public void handleAttack(AnimationState anim) {
        BiConsumer handler = (BiConsumer)ATTACK_HANDLER.get((Object)anim.getID());
        if (handler != null) {
            handler.accept(anim, this);
        }
    }

    public AnimationHandler<Thunderbolt> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, (Entity)this.getControllingPassenger(), command == 2 ? (Spell)RuneCraftorySpells.LASER5.get() : null)) {
                return;
            }
            if (command == 2) {
                this.getAnimationHandler().setAnimation(LASER_X5);
            } else if (command == 1) {
                this.getAnimationHandler().setAnimation(STOMP);
            } else {
                this.getAnimationHandler().setAnimation(HORN_ATTACK);
            }
        }
    }

    @Override
    public boolean allowAnimation(String prev, String other) {
        if (this.feintedDeath) {
            return true;
        }
        return super.allowAnimation(prev, other);
    }

    @Override
    public double deathRayOffset() {
        return (double)this.getBbHeight() * 0.25;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)RuneCraftorySounds.ENTITY_THUNDERBOLT_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)RuneCraftorySounds.ENTITY_THUNDERBOLT_HURT.get();
    }

    public float getVoicePitch() {
        return 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.2f;
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        if (!state.liquid()) {
            BlockState blockstate = this.level().getBlockState(pos.above());
            SoundType soundtype = Platform.INSTANCE.getSoundType(state, this.level(), pos, (Entity)this);
            if (blockstate.is(Blocks.SNOW)) {
                soundtype = Platform.INSTANCE.getSoundType(blockstate, this.level(), pos, (Entity)this);
            }
            this.playSound((SoundEvent)RuneCraftorySounds.ENTITY_THUNDERBOLT_GALLOP.get(), soundtype.getVolume() * 0.15f, soundtype.getPitch());
        }
    }

    public Vec3 getChargeMotion() {
        return (Vec3)this.getDataContainer().get(CHARGE_MOTION);
    }

    public void setChargeMotion(Vec3 direction) {
        this.getDataContainer().set(CHARGE_MOTION, (Object)direction);
    }

    @Override
    public String getInteractAnimation() {
        return INTERACT;
    }

    @Override
    public String getSpawnAnimation() {
        return SPAWN;
    }

    @Override
    public String getDeathAnimation() {
        return DEFEAT;
    }
}

