/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.npc;

import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.entities.utils.DailyEntityUpdater;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;

public class DailyNPCUpdater
extends DailyEntityUpdater<NPCEntity> {
    private int bread;
    private final Set<UUID> acceptedRandomQuest = new HashSet<UUID>();

    public DailyNPCUpdater(NPCEntity entity) {
        super(entity);
        this.bread = entity.getRandom().nextInt(4) + 1;
    }

    @Override
    protected void onUpdate() {
        super.onUpdate();
        this.bread = ((NPCEntity)this.entity).getRandom().nextInt(4) + 1;
        this.acceptedRandomQuest.clear();
    }

    public void acceptRandomQuest(ServerPlayer player) {
        this.acceptedRandomQuest.add(player.getUUID());
    }

    public boolean alreadyAcceptedRandomquest(ServerPlayer player) {
        return this.acceptedRandomQuest.contains(player.getUUID());
    }

    public int getBreadToBuy() {
        return this.bread;
    }

    public void onBuyBread() {
        --this.bread;
    }

    @Override
    public CompoundTag save() {
        CompoundTag tag = super.save();
        tag.putInt("Bread", this.bread);
        ListTag quests = new ListTag();
        this.acceptedRandomQuest.forEach(uuid -> quests.add((Object)StringTag.valueOf((String)uuid.toString())));
        tag.put("AcceptedRandomQuests", (Tag)quests);
        return tag;
    }

    @Override
    public void read(CompoundTag compound) {
        super.read(compound);
        this.bread = compound.getInt("Bread");
        ListTag quests = compound.getList("AcceptedRandomQuests", 8);
        quests.forEach(t -> this.acceptedRandomQuest.add(UUID.fromString(t.getAsString())));
    }
}

