/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.npc.features;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.registry.NPCFeature;
import io.github.flemmli97.runecraftory.api.registry.NPCFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryNPCLooks;
import io.github.flemmli97.runecraftory.common.utils.StreamCodecUtils;
import io.github.flemmli97.tenshilib.common.utils.CodecUtils;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;

public record CustomModelFeatureType(List<Pair<ResourceLocation, List<ResourceLocation>>> models, Location location) implements NPCFeature.NPCFeatureHolder<ModelFeature>
{
    private static final Codec<Pair<ResourceLocation, List<ResourceLocation>>> VALUE_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("model").forGetter(Pair::getFirst), (App)ExtraCodecs.nonEmptyList((Codec)ResourceLocation.CODEC.listOf()).fieldOf("textures").forGetter(Pair::getSecond)).apply((Applicative)instance, Pair::of));
    public static final MapCodec<CustomModelFeatureType> TYPE_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.nonEmptyList((Codec)VALUE_CODEC.listOf()).fieldOf("models").forGetter(CustomModelFeatureType::models), (App)CodecUtils.stringEnumCodec(Location.class, null).fieldOf("location").forGetter(CustomModelFeatureType::location)).apply((Applicative)instance, CustomModelFeatureType::new));
    public static MapCodec<ModelFeature> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("model").forGetter(ModelFeature::model), (App)ResourceLocation.CODEC.fieldOf("model").forGetter(ModelFeature::texture), (App)CodecUtils.stringEnumCodec(Location.class, null).fieldOf("location").forGetter(ModelFeature::location)).apply((Applicative)instance, ModelFeature::new));
    public static final StreamCodec<ByteBuf, ModelFeature> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, ModelFeature::model, (StreamCodec)ResourceLocation.STREAM_CODEC, ModelFeature::texture, StreamCodecUtils.ofEnum(Location.class), ModelFeature::location, ModelFeature::new);

    @Override
    public ModelFeature create(NPCEntity npc) {
        if (this.models.isEmpty()) {
            throw new IllegalStateException("No models defined!");
        }
        Pair<ResourceLocation, List<ResourceLocation>> selected = this.models.get(npc.getRandom().nextInt(this.models.size()));
        return new ModelFeature((ResourceLocation)selected.getFirst(), (ResourceLocation)((List)selected.getSecond()).get(npc.getRandom().nextInt(((List)selected.getSecond()).size())), this.location());
    }

    @Override
    public NPCFeatureType<ModelFeature> getType() {
        return (NPCFeatureType)RuneCraftoryNPCLooks.MODEL.get();
    }

    public static enum Location {
        HEAD,
        BODY,
        LEFT_ARM,
        RIGHT_ARM,
        LEFT_LEG,
        RIGHT_LEG;

    }

    public record ModelFeature(ResourceLocation model, ResourceLocation texture, Location location) implements NPCFeature
    {
        public NPCFeatureType<ModelFeature> type() {
            return (NPCFeatureType)RuneCraftoryNPCLooks.MODEL.get();
        }
    }
}

