/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.npc.features;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.registry.NPCFeature;
import io.github.flemmli97.runecraftory.api.registry.NPCFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.entities.npc.features.ColorSetting;
import io.github.flemmli97.runecraftory.common.entities.npc.features.TypedIndexRange;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryNPCLooks;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public record HairFeatureType(TypedIndexRange types, ColorSetting color) implements NPCFeature.NPCFeatureHolder<HairFeature>
{
    public static final MapCodec<HairFeatureType> TYPE_CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)TypedIndexRange.CODEC.fieldOf("styles").forGetter(d -> d.types), (App)ColorSetting.CODEC.fieldOf("colors").forGetter(d -> d.color)).apply((Applicative)inst, HairFeatureType::new));
    public static MapCodec<HairFeature> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.STRING.fieldOf("style").forGetter(HairFeature::hair), (App)Codec.INT.fieldOf("index").forGetter(HairFeature::index), (App)Codec.INT.fieldOf("color").forGetter(HairFeature::color)).apply((Applicative)inst, HairFeature::new));
    public static final StreamCodec<ByteBuf, HairFeature> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, HairFeature::hair, (StreamCodec)ByteBufCodecs.INT, HairFeature::index, (StreamCodec)ByteBufCodecs.INT, HairFeature::color, HairFeature::new);

    @Override
    public HairFeature create(NPCEntity npc) {
        Pair<String, Integer> style = this.types.getRandom(npc.getRandom());
        return new HairFeature((String)style.getFirst(), (Integer)style.getSecond(), this.color.getRandom(npc.getRandom()));
    }

    @Override
    public NPCFeatureType<HairFeature> getType() {
        return (NPCFeatureType)RuneCraftoryNPCLooks.HAIR.get();
    }

    public record HairFeature(String hair, int index, int color) implements NPCFeature
    {
        public NPCFeatureType<HairFeature> type() {
            return (NPCFeatureType)RuneCraftoryNPCLooks.HAIR.get();
        }
    }
}

