/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.npc.features;

import com.mojang.serialization.DynamicOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.registry.NPCFeature;
import io.github.flemmli97.runecraftory.api.registry.NPCFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import org.apache.logging.log4j.Logger;

public class NPCFeatureContainer {
    private final Map<NPCFeatureType<?>, NPCFeature> map = new HashMap();
    public final Map<NPCFeatureType<?>, NPCFeature> view = Collections.unmodifiableMap(this.map);

    public <T extends NPCFeature> T getFeature(NPCFeatureType<T> type) {
        return (T)this.map.get(type);
    }

    public void buildFromLooks(NPCEntity npc, Collection<NPCFeature.NPCFeatureHolder<?>> features) {
        this.map.clear();
        features.forEach(feat -> this.map.put(feat.getType(), (NPCFeature)feat.create(npc)));
    }

    public Tag save(HolderLookup.Provider provider) {
        return (Tag)NPCFeature.FEATURE_CODEC.listOf().encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), List.copyOf(this.map.values())).getOrThrow();
    }

    public NPCFeatureContainer read(Tag tag, HolderLookup.Provider provider) {
        this.map.clear();
        ((List)NPCFeature.FEATURE_CODEC.listOf().parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).promotePartial(arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0)).getOrThrow()).forEach(feature -> this.map.put(feature.type(), (NPCFeature)feature));
        return this;
    }

    public void toBuffer(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.map.size());
        this.map.forEach((type, feat) -> NPCFeature.STREAM_CODEC.encode((Object)buf, feat));
    }

    public NPCFeatureContainer fromBuffer(RegistryFriendlyByteBuf buf) {
        this.map.clear();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            NPCFeature feat = (NPCFeature)NPCFeature.STREAM_CODEC.decode((Object)buf);
            this.map.put(feat.type(), feat);
        }
        return this;
    }

    public void with(NPCFeatureContainer other) {
        this.map.clear();
        this.map.putAll(other.map);
    }
}

