/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.pathing;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import org.jetbrains.annotations.Nullable;

public class NPCWalkNodeEvaluator
extends WalkNodeEvaluator {
    @Nullable
    protected Node findAcceptedNode(int i, int j, int k, int l, double d, Direction direction, PathType blockPathTypes) {
        Node node = super.findAcceptedNode(i, j, k, l, d, direction, blockPathTypes);
        if (node != null && node.type == PathType.TRAPDOOR) {
            BlockState state = this.mob.level().getBlockState(new BlockPos(node.x, node.y, node.z));
            if (!(state.getBlock() instanceof TrapDoorBlock)) {
                return node;
            }
            boolean tryGoOver = false;
            if (((Boolean)state.getValue((Property)TrapDoorBlock.OPEN)).booleanValue()) {
                Direction facing = (Direction)state.getValue((Property)TrapDoorBlock.FACING);
                if (facing == direction.getOpposite() || facing == direction) {
                    tryGoOver = true;
                }
            } else if (state.getValue((Property)TrapDoorBlock.HALF) == Half.TOP) {
                tryGoOver = true;
            }
            if (tryGoOver) {
                return this.findAcceptedNode(i, j + 1, k, l, d, direction, blockPathTypes);
            }
        }
        return node;
    }

    public PathType getPathType(PathfindingContext context, int x, int y, int z) {
        PathType type = super.getPathType(context, x, y, z);
        if (type == PathType.UNPASSABLE_RAIL) {
            return PathType.OPEN;
        }
        return type;
    }
}

