/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.utils;

import io.github.flemmli97.runecraftory.common.network.S2CBossbarInfoAdd;
import io.github.flemmli97.runecraftory.common.network.S2CBossbarInfoRemove;
import io.github.flemmli97.runecraftory.common.network.S2CBossbarMusicUpdate;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.BossEvent;
import org.jetbrains.annotations.Nullable;

public class RunecraftoryBossbar
extends ServerBossEvent {
    public final ResourceLocation type;
    private SoundEvent music;
    private UUID musicID;

    public RunecraftoryBossbar(@Nullable ResourceLocation type, Component name, BossEvent.BossBarColor color, BossEvent.BossBarOverlay overlay) {
        super(name, color, overlay);
        this.type = type;
    }

    public RunecraftoryBossbar setMusic(SoundEvent music) {
        if (this.music != music) {
            this.music = music;
            this.broadcast(false);
        }
        return this;
    }

    public RunecraftoryBossbar setMusicID(UUID uuid) {
        if (this.musicID == null || !this.musicID.equals(uuid)) {
            this.musicID = uuid;
            this.broadcast(false);
        }
        return this;
    }

    public UUID getMusicId() {
        return this.musicID != null ? this.musicID : this.getId();
    }

    public void addPlayer(ServerPlayer player) {
        boolean contained = this.getPlayers().contains(player);
        super.addPlayer(player);
        if (!contained) {
            this.broadcast(false);
        }
    }

    public void removePlayer(ServerPlayer player) {
        if (this.getPlayers().contains(player)) {
            this.broadcast(true);
        }
        super.removePlayer(player);
    }

    public void removePlayerFading(ServerPlayer player) {
        if (this.getPlayers().contains(player)) {
            this.broadcast(true, false);
        }
        super.removePlayer(player);
    }

    public void setVisible(boolean visible) {
        boolean prev = this.isVisible();
        super.setVisible(visible);
        if (visible != prev) {
            this.broadcast(!visible);
        }
    }

    public void setProgress(float progress) {
        block2: {
            float prev;
            block3: {
                progress = Math.max(0.0f, progress);
                prev = this.progress;
                super.setProgress(progress);
                if (!this.isVisible()) break block2;
                if (prev == 0.0f || progress != 0.0f) break block3;
                S2CBossbarMusicUpdate pkt = new S2CBossbarMusicUpdate(this.getId(), this.getMusicId());
                for (ServerPlayer serverPlayer : this.getPlayers()) {
                    LoaderNetwork.INSTANCE.sendToPlayer((CustomPacketPayload)pkt, serverPlayer);
                }
                break block2;
            }
            if (prev != 0.0f || progress == 0.0f) break block2;
            S2CBossbarMusicUpdate pkt = new S2CBossbarMusicUpdate(this.getId(), this.getMusicId(), this.music);
            for (ServerPlayer serverPlayer : this.getPlayers()) {
                LoaderNetwork.INSTANCE.sendToPlayer((CustomPacketPayload)pkt, serverPlayer);
            }
        }
    }

    private void broadcast(boolean remove) {
        this.broadcast(remove, true);
    }

    private void broadcast(boolean remove, boolean immediate) {
        if (this.isVisible()) {
            Object pkt = remove ? new S2CBossbarInfoRemove(this.getId(), immediate) : new S2CBossbarInfoAdd(this.getId(), this.getMusicId(), this.type, this.music);
            for (ServerPlayer serverPlayer : this.getPlayers()) {
                LoaderNetwork.INSTANCE.sendToPlayer((CustomPacketPayload)pkt, serverPlayer);
            }
        }
    }
}

