/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.events;

import io.github.flemmli97.runecraftory.api.attachment.Skills;
import io.github.flemmli97.runecraftory.api.datapack.CropProperties;
import io.github.flemmli97.runecraftory.api.datapack.FoodProperties;
import io.github.flemmli97.runecraftory.api.datapack.SimpleEffect;
import io.github.flemmli97.runecraftory.api.registry.ArmorEffect;
import io.github.flemmli97.runecraftory.api.registry.action.AttackAction;
import io.github.flemmli97.runecraftory.api.registry.action.DataKey;
import io.github.flemmli97.runecraftory.common.advancements.CropHarvestTrigger;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.attackactions.NaiveBladeAttack;
import io.github.flemmli97.runecraftory.common.blocks.MineralBlock;
import io.github.flemmli97.runecraftory.common.blocks.util.Growable;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.config.MobConfig;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.entities.misc.HoeTillableItemEntity;
import io.github.flemmli97.runecraftory.common.entities.utils.IBaseMob;
import io.github.flemmli97.runecraftory.common.items.tools.ItemToolHammer;
import io.github.flemmli97.runecraftory.common.items.tools.ItemToolSickle;
import io.github.flemmli97.runecraftory.common.lib.LibConstants;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.network.S2CCalendar;
import io.github.flemmli97.runecraftory.common.network.S2CCapSync;
import io.github.flemmli97.runecraftory.common.network.S2CSyncConfig;
import io.github.flemmli97.runecraftory.common.network.S2CTriggers;
import io.github.flemmli97.runecraftory.common.quests.QuestHandler;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttackActions;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryCriteria;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEffects;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryItems;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CropUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemComponentUtils;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.common.world.data.RunecraftorySavedData;
import io.github.flemmli97.runecraftory.common.world.data.family.FamilyHandler;
import io.github.flemmli97.runecraftory.common.world.data.farming.FarmlandHandler;
import io.github.flemmli97.runecraftory.mixin.AttributeMapAccessor;
import io.github.flemmli97.runecraftory.mixin.LivingEntityAccessor;
import io.github.flemmli97.runecraftory.mixinhelper.AttributeInstanceExtension;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class EntityCalls {
    public static void joinPlayer(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            LoaderNetwork.INSTANCE.sendToPlayer((CustomPacketPayload)new S2CCalendar(RunecraftorySavedData.get(serverPlayer.getServer()).getCalendar()), serverPlayer);
            PlayerData data = Platform.INSTANCE.getPlayerData(player);
            data.onJoin();
            QuestHandler.removeNPCQuestsFor(serverPlayer);
            LoaderNetwork.INSTANCE.sendToPlayer((CustomPacketPayload)new S2CSyncConfig(), serverPlayer);
            FamilyHandler.get(serverPlayer.getServer()).getOrCreateEntry((Player)serverPlayer).updateName((Entity)player);
        }
    }

    public static void onPlayerLoad(ServerPlayer serverPlayer) {
        serverPlayer.getServer().tell((Runnable)new TickTask(2, () -> {
            Set<RunecraftorySavedData.UnloadedPartyMember> party = RunecraftorySavedData.get(serverPlayer.getServer()).getUnloadedPartyMembersFor((Player)serverPlayer);
            party.forEach(p -> {
                GlobalPos pos = p.pos();
                ServerLevel level = serverPlayer.serverLevel();
                if (level.dimension() != p.pos().dimension()) {
                    level = serverPlayer.getServer().getLevel(pos.dimension());
                }
                if (level != null) {
                    level.getChunkSource().addRegionTicket(TicketType.PORTAL, new ChunkPos(pos.pos()), 3, (Object)pos.pos());
                }
            });
            party.clear();
        }));
        Set<UUID> toRemove = RunecraftorySavedData.get(serverPlayer.getServer()).removedPartyMembersFor((Player)serverPlayer);
        PlayerData data = Platform.INSTANCE.getPlayerData((Player)serverPlayer);
        toRemove.forEach(data.party::removePartyMember);
        toRemove.clear();
    }

    public static boolean handleItemJoinLevel(ItemEntity entity) {
        if (DataPackHandler.INSTANCE.fertilizerManager().get(entity.getItem().getItem()) != null) {
            entity.discard();
            entity.level().addFreshEntity((Entity)new HoeTillableItemEntity(entity.level(), entity));
            return true;
        }
        return false;
    }

    public static void onLoadEntity(LivingEntity living) {
        if (living instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)living;
            EntityCalls.onPlayerLoad(player);
            LoaderNetwork.INSTANCE.sendToPlayer((CustomPacketPayload)new S2CCapSync(Platform.INSTANCE.getPlayerData((Player)player)), player);
            EntityCalls.updateWeaponState(living);
        }
    }

    public static void updateEquipment(LivingEntity entity, Map<EquipmentSlot, ItemStack> changed, ItemStack lastMainhandItem, Function<EquipmentSlot, ItemStack> lastArmor) {
        for (Map.Entry<EquipmentSlot, ItemStack> entry : changed.entrySet()) {
            if (entry.getKey().getType() != EquipmentSlot.Type.HUMANOID_ARMOR) continue;
            ItemStack now = entry.getValue();
            ItemStack last = lastArmor.apply(entry.getKey());
            ArmorEffect.runArmorEffectFor(last, effect -> effect.onRemove(entity, last));
            ArmorEffect.runArmorEffectFor(now, effect -> effect.onEquip(entity, now));
        }
        if (changed.containsKey(EquipmentSlot.MAINHAND) || changed.containsKey(EquipmentSlot.OFFHAND)) {
            float shieldEfficiency = ItemComponentUtils.getShieldEfficiency(entity);
            EntityCalls.recalcOffhandBonus(entity, shieldEfficiency);
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            EntityUtils.sendAttributesTo((LivingEntity)serverPlayer, serverPlayer);
            EntityCalls.updateWeaponState(entity);
        }
    }

    private static void updateWeaponState(LivingEntity entity) {
        boolean weapon = ItemComponentUtils.isWeapon(entity.getMainHandItem());
        AttributeInstance inst = entity.getAttribute(Attributes.ATTACK_DAMAGE);
        if (inst != null) {
            ((AttributeInstanceExtension)inst).runecraftory$setAttributeModifierFilter(weapon ? null : mod -> !mod.id().getNamespace().equals("runecraftory"));
        }
    }

    private static void recalcOffhandBonus(LivingEntity entity, float efficiency) {
        if (efficiency == 1.0f) {
            ((AttributeMapAccessor)entity.getAttributes()).getAttributes().forEach((att, inst) -> inst.removeModifier(LibConstants.SHIELD_PENALTY));
            return;
        }
        float reduction = 1.0f - efficiency;
        HashMap<Holder, AttributeModifier> offhandMods = new HashMap<Holder, AttributeModifier>();
        ((AttributeMapAccessor)entity.getAttributes()).getAttributes().forEach((att, inst) -> {
            AttributeModifier mod = inst.getModifier(LibConstants.EQUIPMENT_MODIFIERS.get(EquipmentSlot.OFFHAND));
            if (mod != null) {
                offhandMods.put((Holder)att, mod);
            }
        });
        offhandMods.forEach((att, mod) -> entity.getAttributes().getInstance(att).addTransientModifier(new AttributeModifier(LibConstants.SHIELD_PENALTY, -mod.amount() * (double)reduction, AttributeModifier.Operation.ADD_VALUE)));
    }

    public static boolean playerAttack(Player player, Entity target) {
        if (!player.level().isClientSide && ItemComponentUtils.isWeapon(player.getMainHandItem())) {
            CombatUtils.attackWithItem(player, target, true, true);
            return true;
        }
        return false;
    }

    public static boolean cancelLivingAttack(DamageSource source, Entity target, float amount) {
        LivingEntity living;
        Entity attacker = source.getEntity();
        if (!source.is(DamageTypeTags.BYPASSES_INVULNERABILITY) && target instanceof Player) {
            Player player = (Player)target;
            PlayerData data = Platform.INSTANCE.getPlayerData(player);
            if (data.getWeaponHandler().isInvulnerable((LivingEntity)player)) {
                return true;
            }
            if (source.getDirectEntity() != null && amount > 0.0f && NaiveBladeAttack.canCounter(data.getWeaponHandler())) {
                data.getWeaponHandler().doWeaponAttack((AttackAction)RuneCraftoryAttackActions.NAIVE_BLADE.get(), player.getMainHandItem(), null);
                return true;
            }
        }
        if (source instanceof DynamicDamage || attacker instanceof Player) {
            return false;
        }
        if (attacker instanceof LivingEntity && (living = (LivingEntity)attacker).getMainHandItem().is(RunecraftoryTags.Items.UPGRADABLE_HELD) && !living.getType().is(RunecraftoryTags.EntityTypes.HELD_WEAPON_EXEMPT)) {
            CombatUtils.mobAttack(living, target);
            return true;
        }
        return false;
    }

    public static float damageCalculation(LivingEntity entity, DamageSource source, float dmg) {
        float damage = CombatUtils.reduceDamageFromStats(entity, source, dmg);
        if (damage < 0.0f) {
            entity.heal(-damage);
        } else if (damage > 1.0f && !source.is(DamageTypeTags.BYPASSES_INVULNERABILITY) && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            LevelCalc.levelSkill(Platform.INSTANCE.getPlayerData((Player)player), Skills.DEFENCE, Math.min(7.0f, (float)(0.5 + Math.log((double)damage * 0.25))) * 1.5f);
        }
        return damage;
    }

    public static void postDamage(LivingEntity entity, DamageSource src, float amount) {
        LivingEntity living;
        float drainPercent;
        Entity attacker = src.getEntity();
        if (attacker instanceof LivingEntity) {
            entity.removeEffect(RuneCraftoryEffects.SLEEP.asHolder());
        }
        if (amount > 0.0f && attacker instanceof LivingEntity && (drainPercent = (float)CombatUtils.statusEffectValue(living = (LivingEntity)attacker, (Holder<Attribute>)RuneCraftoryAttributes.DRAIN.asHolder(), (Entity)entity)) > 0.0f) {
            if (attacker instanceof Player) {
                Player player = (Player)attacker;
                player.heal(drainPercent * amount);
            } else {
                living.heal(drainPercent * amount);
            }
        }
    }

    public static boolean playerDeath(LivingEntity entity, DamageSource source) {
        if (!entity.level().isClientSide) {
            Object object;
            if (!source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
                Player player;
                ItemStack deathProt = ItemStack.EMPTY;
                for (ItemStack stack : entity.getAllSlots()) {
                    if (stack.getItem() != RuneCraftoryItems.LAWN.get()) continue;
                    deathProt = stack;
                }
                if (deathProt.isEmpty() && entity instanceof Player) {
                    player = (Player)entity;
                    object = player.getInventory().items.iterator();
                    while (object.hasNext()) {
                        ItemStack stack = (ItemStack)object.next();
                        if (stack.getItem() != RuneCraftoryItems.LAWN.get()) continue;
                        deathProt = stack;
                    }
                }
                if (!deathProt.isEmpty()) {
                    if (entity instanceof ServerPlayer) {
                        player = (ServerPlayer)entity;
                        player.awardStat(Stats.ITEM_USED.get((Object)deathProt.getItem()));
                        CriteriaTriggers.CONSUME_ITEM.trigger((ServerPlayer)player, deathProt);
                    }
                    entity.setHealth(entity.getMaxHealth() * 0.33f);
                    entity.removeAllEffects();
                    entity.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 5, 100));
                    entity.level().broadcastEntityEvent((Entity)entity, (byte)35);
                    deathProt.shrink(1);
                    return true;
                }
            }
            if (MobConfig.vanillaGiveXp && entity instanceof Mob) {
                Mob m = (Mob)entity;
                if (!(entity instanceof IBaseMob) && (object = source.getEntity()) instanceof LivingEntity) {
                    LivingEntity attacker = (LivingEntity)object;
                    LevelCalc.addXP(attacker, (int)Math.log(m.getMaxHealth() + 1.0f) * 10, 0, 0, false);
                }
            }
        }
        return false;
    }

    public static void dropInventoryDeath(LivingEntity entity) {
        ServerPlayer player;
        if (entity instanceof ServerPlayer && !(player = (ServerPlayer)entity).level().getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY)) {
            Platform.INSTANCE.getPlayerData((Player)player).getInv().dropItemsAt((LivingEntity)player);
        }
    }

    public static void clone(Player origin, Player player, boolean death) {
        if (player instanceof ServerPlayer) {
            PlayerData data = Platform.INSTANCE.getPlayerData(origin);
            if (death) {
                data.useMoney((int)((double)data.getMoney() * 0.2));
            }
            Platform.INSTANCE.getPlayerData(player).readFromNBT(data.writeToNBT(new CompoundTag(), death));
        }
    }

    public static void cropRightClickHarvest(Player player, BlockState state, BlockPos pos, InteractionHand hand) {
        Block block;
        if (!player.level().isClientSide && (block = state.getBlock()) instanceof CropBlock) {
            CropBlock crop = (CropBlock)block;
            ItemStack stack = player.getItemInHand(hand);
            if (stack.is(RunecraftoryTags.Items.QUICKHARVEST_BYPASS)) {
                return;
            }
            if (crop.isMaxAge(state)) {
                CropProperties props = CropUtils.getPropertiesFor(crop);
                CropUtils.harvestCropRightClick(state, player.level(), pos, (Entity)player, player.getMainHandItem(), props, hand, null);
            }
        }
    }

    public static boolean onTryBonemeal(Level level, ItemStack stack, BlockState state, BlockPos pos, @Nullable Player player) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos targetPos = null;
            boolean swing = false;
            if (state.getBlock() instanceof Growable) {
                BlockPos below;
                CropProperties props = DataPackHandler.INSTANCE.cropManager().get(state.getBlock().getCloneItemStack((LevelReader)level, pos, state).getItem());
                if (props != null && FarmlandHandler.isFarmBlock(level.getBlockState(below = pos.below()))) {
                    targetPos = below;
                }
                swing = !(state.getBlock() instanceof BonemealableBlock);
            } else if (FarmlandHandler.isFarmBlock(state)) {
                targetPos = pos;
                swing = true;
            }
            if (targetPos != null) {
                BlockPos target = targetPos;
                if (player != null && swing) {
                    player.swing(player.getOffhandItem().equals(stack) ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND, true);
                }
                FarmlandHandler.get(serverLevel.getServer()).getData(serverLevel, target).ifPresent(d -> {
                    if (d.canUseBonemeal()) {
                        d.applyBonemeal(serverLevel);
                        stack.shrink(1);
                        LoaderNetwork.INSTANCE.sendToAll((CustomPacketPayload)new S2CTriggers(S2CTriggers.TriggerType.FERTILIZER, target), level.getServer());
                    }
                });
                return true;
            }
        }
        return player == null && FarmlandHandler.isFarmBlock(state);
    }

    public static void updateLivingTick(LivingEntity entity) {
        Mob mob;
        boolean disabled;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Platform.INSTANCE.getPlayerData(player).tick();
            if (GeneralConfig.disableHunger) {
                int food = player.hasEffect(RuneCraftoryEffects.PARALYSIS.asHolder()) ? 6 : 14;
                player.getFoodData().setFoodLevel(food);
                player.getFoodData().setSaturation(0.0f);
            }
        }
        for (Player slot : EquipmentSlot.values()) {
            if (slot.getType() != EquipmentSlot.Type.HUMANOID_ARMOR) continue;
            ItemStack stack = entity.getItemBySlot((EquipmentSlot)slot);
            ArmorEffect.runArmorEffectFor(stack, effect -> effect.onTick(entity, stack));
        }
        if (entity instanceof Mob && (disabled = EntityUtils.isDisabled((LivingEntity)(mob = (Mob)entity))) && !mob.getNavigation().isDone()) {
            mob.getNavigation().stop();
        }
        Platform.INSTANCE.getEntityData(entity).tick();
    }

    public static boolean rootTick(LivingEntity entity) {
        if (entity instanceof Player) {
            return false;
        }
        if (entity.hasEffect(RuneCraftoryEffects.STUNNED.asHolder())) {
            ((LivingEntityAccessor)entity).tickEffectsManually();
            --entity.invulnerableTime;
            return true;
        }
        return false;
    }

    public static void foodHandling(LivingEntity entity, ItemStack stack) {
        if (!entity.level().isClientSide) {
            if (entity instanceof IBaseMob) {
                IBaseMob mob = (IBaseMob)entity;
                mob.applyFoodEffect(stack);
                return;
            }
            FoodProperties prop = DataPackHandler.INSTANCE.foodManager().get(stack.getItem());
            if (prop == null) {
                if (entity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)entity;
                    if (stack.has(DataComponents.FOOD)) {
                        PlayerData data = Platform.INSTANCE.getPlayerData((Player)player);
                        if (data.foodBuff().duration() <= 0) {
                            LevelCalc.levelSkill(data, Skills.EATING, 5.0f);
                        }
                        data.regenRunePoints(EntityUtils.getRPFromVanillaFood(stack));
                    }
                }
                return;
            }
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                PlayerData data = Platform.INSTANCE.getPlayerData((Player)player);
                if (data.foodBuff().duration() <= 0) {
                    data.getDailyUpdater().onFoodEaten();
                }
                data.applyFoodEffect(stack);
                data.regenRunePoints(prop.getRPRegen() + (int)((double)(data.getMaxRunePoints() * prop.getRpPercentRegen()) * 0.01));
            }
            int healthGain = prop.getHPGain();
            EntityUtils.foodHealing(entity, healthGain);
            int healthPercent = prop.getHpPercentGain();
            EntityUtils.foodHealing(entity, entity.getMaxHealth() * (float)healthPercent * 0.01f);
            if (prop.potionHeals() != null) {
                for (Holder holder : prop.potionHeals()) {
                    entity.removeEffect(holder);
                }
            }
            if (prop.potionApply() != null) {
                for (SimpleEffect simpleEffect : prop.potionApply()) {
                    entity.addEffect(simpleEffect.create());
                }
            }
        }
    }

    public static void wakeUp(Player player) {
        if (GeneralConfig.healOnWakeUp && player instanceof ServerPlayer) {
            player.heal(player.getMaxHealth());
            PlayerData data = Platform.INSTANCE.getPlayerData(player);
            data.regenRunePoints(data.getMaxRunePoints());
            LevelCalc.levelSkill(data, Skills.SLEEPING, 75.0f);
            player.removeEffect(RuneCraftoryEffects.FATIGUE.asHolder());
        }
    }

    public static boolean disableNatural(MobSpawnType spawnType, EntityType<?> entity) {
        if (MobConfig.disableNaturalSpawn) {
            return (spawnType == MobSpawnType.CHUNK_GENERATION || spawnType == MobSpawnType.NATURAL) && entity != RuneCraftoryEntities.GATE.get();
        }
        return false;
    }

    public static void onBlockBreak(ServerPlayer player, BlockState state, BlockPos pos) {
        if (state.getBlock() instanceof CropBlock) {
            ((CropHarvestTrigger)((Object)RuneCraftoryCriteria.HARVEST_CROP.get())).trigger(player, state);
        }
        if (!player.hasCorrectToolForDrops(state)) {
            return;
        }
        PlayerData data = Platform.INSTANCE.getPlayerData((Player)player);
        if (state.is(RunecraftoryTags.Blocks.HAMMER_BREAKABLE)) {
            ItemToolHammer.onHammering(player, true);
        } else if (state.is(BlockTags.MINEABLE_WITH_PICKAXE)) {
            LevelCalc.levelSkill(data, Skills.MINING, state.getBlock() instanceof MineralBlock ? 10.0f : 1.0f);
        }
        if (state.is(BlockTags.MINEABLE_WITH_AXE)) {
            LevelCalc.levelSkill(data, Skills.LOGGING, 1.0f);
        }
        if (state.is(BlockTags.MINEABLE_WITH_HOE) && !(player.getMainHandItem().getItem() instanceof ItemToolSickle)) {
            LevelCalc.levelSkill(data, Skills.FARMING, 1.0f);
        }
        if (state.getBlock() instanceof BushBlock) {
            LevelCalc.levelSkill(data, Skills.FARMING, 0.5f);
        }
    }

    public static void onLootTableBlockGen(Player player) {
        if (player instanceof ServerPlayer) {
            PlayerData data = Platform.INSTANCE.getPlayerData(player);
            LevelCalc.levelSkill(data, Skills.SEARCHING, 7.0f);
        }
    }

    public static boolean shouldPreventFarmlandTrample(Entity entity, LevelAccessor world) {
        return GeneralConfig.disableFarmlandTrample;
    }

    public static boolean onPlayerUseItem(Player player, InteractionHand hand) {
        PlayerData data = Platform.INSTANCE.getPlayerData(player);
        return data.getWeaponHandler().getCurrentAction() == RuneCraftoryAttackActions.NONE.get() || ItemStack.isSameItemSameComponents((ItemStack)player.getItemInHand(hand), (ItemStack)data.getWeaponHandler().get(DataKey.USED_WEAPON));
    }
}

