/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.inventory;

import io.github.flemmli97.runecraftory.api.datapack.ItemStat;
import io.github.flemmli97.runecraftory.common.advancements.ShippingTrigger;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.inventory.SimpleItemContainer;
import io.github.flemmli97.runecraftory.common.quests.QuestHandler;
import io.github.flemmli97.runecraftory.common.quests.progress.ShippingTracker;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryCriteria;
import io.github.flemmli97.runecraftory.common.utils.ItemUtils;
import io.github.flemmli97.runecraftory.platform.Platform;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class InventoryShippingBin
extends SimpleItemContainer {
    public InventoryShippingBin() {
        super(54);
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return DataPackHandler.INSTANCE.itemStatManager().get(stack.getItem()).map(ItemStat::getSell).orElse(0) > 0;
    }

    public void shipItems(ServerPlayer player) {
        PlayerData data = Platform.INSTANCE.getPlayerData((Player)player);
        int money = 0;
        for (int i = 0; i < this.getContainerSize(); ++i) {
            int basePrice;
            ItemStack stack = this.getItem(i);
            if (stack.isEmpty() || (basePrice = ItemUtils.getSellPrice(stack)) <= 0) continue;
            money += basePrice * stack.getCount();
            data.addShippingItem(stack);
            ((ShippingTrigger)((Object)RuneCraftoryCriteria.SHIPPING_TRIGGER.get())).trigger(player, data, stack);
            QuestHandler.getData(player).trigger(ShippingTracker.KEY, stack);
            this.setItem(i, ItemStack.EMPTY);
        }
        data.giveMoney(money);
        if (money != 0) {
            player.displayClientMessage((Component)Component.translatable((String)"runecraftory.misc.shipping.money", (Object[])new Object[]{money}).withStyle(ChatFormatting.GOLD), true);
        }
    }
}

