/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.inventory;

import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class InventoryShop
implements Container {
    public static final int SHOP_SIZE = 30;
    private final NonNullList<ItemStack> slots = NonNullList.withSize((int)30, (Object)ItemStack.EMPTY);
    private final NonNullList<ItemStack> shop;
    private int index;
    private ItemStack output = ItemStack.EMPTY;
    public final NPCEntity npc;

    public InventoryShop(NPCEntity npc, NonNullList<ItemStack> shop) {
        this.npc = npc;
        this.shop = shop;
        this.updateInv();
    }

    public int getContainerSize() {
        return this.slots.size() + 1;
    }

    public boolean isEmpty() {
        if (!this.output.isEmpty()) {
            return false;
        }
        for (ItemStack itemstack : this.slots) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int index) {
        if (index == 30) {
            return this.output;
        }
        return (ItemStack)this.slots.get(index);
    }

    public ItemStack removeItem(int index, int count) {
        if (index == 30) {
            return this.output.split(count);
        }
        return ContainerHelper.removeItem(this.slots, (int)index, (int)count);
    }

    public ItemStack removeItemNoUpdate(int index) {
        if (index == 30) {
            ItemStack stack = this.output.copy();
            this.output = ItemStack.EMPTY;
            return stack;
        }
        return ContainerHelper.takeItem(this.slots, (int)index);
    }

    public void setItem(int index, ItemStack stack) {
        if (index == 30) {
            this.output = stack;
        } else {
            stack.setCount(this.getMaxStackSize());
            this.slots.set(index, (Object)stack);
        }
    }

    public void setChanged() {
        this.updateInv();
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void clearContent() {
        this.slots.clear();
    }

    public int getMaxStackSize() {
        return 1;
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return false;
    }

    public void next() {
        this.index = Math.min(this.shop.size() / 30, ++this.index);
        this.updateInv();
    }

    public void prev() {
        this.index = Math.max(0, --this.index);
        this.updateInv();
    }

    public boolean hasNext() {
        return this.index < this.shop.size() / 30;
    }

    public boolean hasPrev() {
        return this.index > 0;
    }

    private void updateInv() {
        NonNullList<ItemStack> list = this.shop;
        for (int i = 0; i < this.slots.size(); ++i) {
            int slot = i + 30 * this.index;
            ItemStack stack = ItemStack.EMPTY;
            if (slot < list.size()) {
                stack = (ItemStack)list.get(slot);
            }
            this.slots.set(i, (Object)stack);
        }
    }
}

