/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.inventory;

import java.util.function.Consumer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class WrappedContainer
implements Container {
    protected final Container container;
    protected final Consumer<Container> listener;

    public WrappedContainer(Container container) {
        this(container, null);
    }

    public WrappedContainer(Container container, Consumer<Container> listener) {
        this.container = container;
        this.listener = listener;
    }

    public int getContainerSize() {
        return this.container.getContainerSize();
    }

    public boolean isEmpty() {
        return this.container.isEmpty();
    }

    public ItemStack getItem(int slot) {
        return this.container.getItem(slot);
    }

    public ItemStack removeItem(int slot, int count) {
        ItemStack stack = this.container.removeItem(slot, count);
        this.setChanged();
        return stack;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        ItemStack stack = this.container.removeItemNoUpdate(slot);
        this.setChanged();
        return stack;
    }

    public void setItem(int slot, ItemStack stack) {
        this.container.setItem(slot, stack);
        this.setChanged();
    }

    public int getMaxStackSize() {
        return this.container.getMaxStackSize();
    }

    public void setChanged() {
        this.container.setChanged();
        if (this.listener != null) {
            this.listener.accept(this);
        }
    }

    public boolean stillValid(Player player) {
        return this.container.stillValid(player);
    }

    public void startOpen(Player player) {
        this.container.startOpen(player);
    }

    public void stopOpen(Player player) {
        this.container.stopOpen(player);
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        return this.container.canPlaceItem(slot, stack);
    }

    public void clearContent() {
        this.container.clearContent();
    }
}

