/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.inventory.container;

import io.github.flemmli97.runecraftory.api.attachment.Skills;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.inventory.PlayerBoundCraftingContainer;
import io.github.flemmli97.runecraftory.common.inventory.container.ContainerCrafting;
import io.github.flemmli97.runecraftory.common.recipes.SextupleRecipe;
import io.github.flemmli97.runecraftory.common.recipes.SpecialSextupleRecipe;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryCriteria;
import io.github.flemmli97.runecraftory.common.utils.CraftingUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemComponentUtils;
import io.github.flemmli97.runecraftory.platform.Platform;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;

public class CraftingOutputSlot
extends Slot {
    private final PlayerBoundCraftingContainer ingredientInv;
    private final ContainerCrafting craftingContainer;
    private final int id;
    private int amountCrafted;
    private boolean prepareForSync;

    public CraftingOutputSlot(Container output, ContainerCrafting container, PlayerBoundCraftingContainer ingredientInv, int id, int x, int y) {
        super(output, id, x, y);
        this.ingredientInv = ingredientInv;
        this.craftingContainer = container;
        this.id = id;
    }

    public void setSyncState(boolean syncing) {
        this.prepareForSync = syncing;
    }

    public ItemStack getItem() {
        return this.prepareForSync ? this.container.getItem(this.id + 1) : super.getItem();
    }

    protected void onQuickCraft(ItemStack stack, int amount) {
        this.amountCrafted += amount;
        this.checkTakeAchievements(stack);
    }

    protected void onSwapCraft(int amount) {
        super.onSwapCraft(amount);
        this.amountCrafted += amount;
    }

    protected void checkTakeAchievements(ItemStack stack) {
        Player player = this.ingredientInv.getPlayer();
        if (this.amountCrafted > 0) {
            stack.onCraftedBy(player.level(), player, this.amountCrafted);
            Platform.INSTANCE.craftingEvent(player, stack, this.ingredientInv);
            Platform.INSTANCE.getPlayerData(player).onCrafted(player);
        }
        this.amountCrafted = 0;
    }

    public void onTake(Player player, ItemStack stack) {
        NonNullList remaining;
        this.checkTakeAchievements(stack);
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        NonNullList nonNullList = remaining = this.craftingContainer.getSelected() != null ? ((SextupleRecipe)this.craftingContainer.getSelected().value()).getRemainingItems(this.ingredientInv) : NonNullList.withSize((int)0, (Object)ItemStack.EMPTY);
        if (this.craftingContainer.runepointCost() >= 0) {
            PlayerData data = Platform.INSTANCE.getPlayerData(player);
            data.useRunePoints(this.craftingContainer.runepointCost(), true);
            RecipeHolder<? extends SextupleRecipe> recipe = this.craftingContainer.getSelected();
            if (recipe != null && !(recipe.value() instanceof SpecialSextupleRecipe) && !data.getRecipeKeeper().isUnlocked(recipe)) {
                data.getRecipeKeeper().unlockRecipe(player, recipe);
                this.craftingContainer.sendCraftingRecipesToClient(serverPlayer, data);
            }
            switch (this.craftingContainer.craftingType()) {
                case FORGE: {
                    CraftingUtils.giveCraftingXPTo(data, Skills.FORGING, (SextupleRecipe)this.craftingContainer.getSelected().value());
                    break;
                }
                case ACCESSORY_WORKBENCH: {
                    CraftingUtils.giveCraftingXPTo(data, Skills.CRAFTING, (SextupleRecipe)this.craftingContainer.getSelected().value());
                    break;
                }
                case CHEMISTRY_SET: {
                    CraftingUtils.giveCraftingXPTo(data, Skills.CHEMISTRY, (SextupleRecipe)this.craftingContainer.getSelected().value());
                    break;
                }
                case COOKING_TABLE: {
                    CraftingUtils.giveCraftingXPTo(data, Skills.COOKING, (SextupleRecipe)this.craftingContainer.getSelected().value());
                }
            }
        }
        if (ItemComponentUtils.usedLightOre(stack)) {
            ((PlayerTrigger)RuneCraftoryCriteria.LIGHT_ORE.get()).trigger(serverPlayer);
        }
        switch (this.craftingContainer.craftingType()) {
            case FORGE: {
                ((PlayerTrigger)RuneCraftoryCriteria.FORGING.get()).trigger(serverPlayer);
                break;
            }
            case ACCESSORY_WORKBENCH: {
                ((PlayerTrigger)RuneCraftoryCriteria.CRAFTING.get()).trigger(serverPlayer);
                break;
            }
            case CHEMISTRY_SET: {
                ((PlayerTrigger)RuneCraftoryCriteria.MEDICINE.get()).trigger(serverPlayer);
                break;
            }
            case COOKING_TABLE: {
                ((PlayerTrigger)RuneCraftoryCriteria.COOKING.get()).trigger(serverPlayer);
            }
        }
        boolean refreshRecipe = false;
        for (int i = 0; i < remaining.size(); ++i) {
            ItemStack itemstack = this.ingredientInv.getItem(i);
            ItemStack remainingStack = (ItemStack)remaining.get(i);
            if (!itemstack.isEmpty()) {
                this.ingredientInv.removeItem(i, 1);
                itemstack = this.ingredientInv.getItem(i);
                if (itemstack.isEmpty()) {
                    refreshRecipe = true;
                }
            }
            if (remainingStack.isEmpty()) continue;
            if (itemstack.isEmpty()) {
                this.ingredientInv.setItem(i, remainingStack);
                continue;
            }
            if (ItemStack.isSameItemSameComponents((ItemStack)itemstack, (ItemStack)remainingStack)) {
                remainingStack.grow(itemstack.getCount());
                this.ingredientInv.setItem(i, remainingStack);
                continue;
            }
            if (player.getInventory().add(remainingStack)) continue;
            player.drop(remainingStack, false);
        }
        if (refreshRecipe) {
            this.craftingContainer.slotsChanged(this.ingredientInv);
        }
        super.onTake(player, stack);
    }

    public boolean mayPlace(ItemStack stack) {
        return false;
    }

    public ItemStack remove(int amount) {
        if (this.hasItem()) {
            this.amountCrafted += Math.min(amount, this.getItem().getCount());
        }
        return super.remove(amount);
    }

    public boolean mayPickup(Player player) {
        if (!GeneralConfig.useRp) {
            return true;
        }
        return player.isCreative() || Platform.INSTANCE.getPlayerData(player).getMaxRunePoints() >= this.craftingContainer.runepointCost();
    }
}

