/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.inventory.container;

import io.github.flemmli97.runecraftory.api.attachment.Skills;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.inventory.PlayerBoundCraftingContainer;
import io.github.flemmli97.runecraftory.common.inventory.container.ContainerUpgrade;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemStaffBase;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryCriteria;
import io.github.flemmli97.runecraftory.common.utils.CraftingUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemComponentUtils;
import io.github.flemmli97.runecraftory.platform.Platform;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class UpgradeOutputSlot
extends Slot {
    private final PlayerBoundCraftingContainer ingredientInv;
    private final ContainerUpgrade container;
    private int amountCrafted;

    public UpgradeOutputSlot(Container output, ContainerUpgrade container, PlayerBoundCraftingContainer ingredientInv, int id, int x, int y) {
        super(output, id, x, y);
        this.ingredientInv = ingredientInv;
        this.container = container;
    }

    protected void onQuickCraft(ItemStack stack, int amount) {
        this.amountCrafted += amount;
        this.checkTakeAchievements(stack);
    }

    protected void onSwapCraft(int amount) {
        super.onSwapCraft(amount);
        this.amountCrafted += amount;
    }

    protected void checkTakeAchievements(ItemStack stack) {
        Player player = this.ingredientInv.getPlayer();
        if (this.amountCrafted > 0) {
            stack.onCraftedBy(player.level(), player, this.amountCrafted);
            Platform.INSTANCE.craftingEvent(player, stack, this.ingredientInv);
        }
        this.amountCrafted = 0;
    }

    public void onTake(Player player, ItemStack stack) {
        this.checkTakeAchievements(stack);
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        ItemStack toUpgrade = this.ingredientInv.getItem(0);
        ItemStack material = this.ingredientInv.getItem(1);
        ((PlayerTrigger)RuneCraftoryCriteria.UPGRADE_ITEM.get()).trigger(serverPlayer);
        if (ItemComponentUtils.getElement(toUpgrade) != ItemComponentUtils.getElement(stack)) {
            ((PlayerTrigger)RuneCraftoryCriteria.CHANGE_ELEMENT.get()).trigger(serverPlayer);
        }
        PlayerData data = Platform.INSTANCE.getPlayerData((Player)serverPlayer);
        if (stack.getItem() instanceof ItemStaffBase && DataPackHandler.INSTANCE.itemStatManager().get(material.getItem()).map(s -> s.getTier1Spell().isPresent() || s.getTier2Spell().isPresent() || s.getTier3Spell().isPresent()).orElse(false).booleanValue()) {
            ((PlayerTrigger)RuneCraftoryCriteria.CHANGE_SPELL.get()).trigger(serverPlayer);
        }
        data.useRunePoints(this.container.rpCost(), true);
        switch (this.container.craftingType()) {
            case FORGE: {
                CraftingUtils.giveUpgradeXPTo(data, Skills.FORGING, toUpgrade, material);
                break;
            }
            case ACCESSORY_WORKBENCH: {
                CraftingUtils.giveUpgradeXPTo(data, Skills.CRAFTING, toUpgrade, material);
            }
        }
        ItemStack ing1 = this.ingredientInv.getItem(0);
        ItemStack ing2 = this.ingredientInv.getItem(1);
        if (!ing1.isEmpty()) {
            this.ingredientInv.removeItem(0, 1);
            ing1 = this.ingredientInv.getItem(0);
        }
        if (!ing2.isEmpty()) {
            this.ingredientInv.removeItem(1, 1);
            ing2 = this.ingredientInv.getItem(1);
        }
        player.level().playSound(null, player.blockPosition(), SoundEvents.ANVIL_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
        if (ing1.isEmpty() || ing2.isEmpty()) {
            this.container.slotsChanged(this.ingredientInv);
        }
    }

    public boolean mayPlace(ItemStack stack) {
        return false;
    }

    public ItemStack remove(int amount) {
        if (this.hasItem()) {
            this.amountCrafted += Math.min(amount, this.getItem().getCount());
        }
        return super.remove(amount);
    }

    public boolean mayPickup(Player player) {
        return player.isCreative() || Platform.INSTANCE.getPlayerData(player).getMaxRunePoints() >= this.container.rpCost();
    }
}

