/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.items;

import com.google.common.base.Suppliers;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryItems;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public enum ItemElement {
    NONE(ChatFormatting.GRAY, "none", 0xFFFFFF, null),
    WATER(ChatFormatting.DARK_BLUE, "water", 0x101099, (Supplier<ItemStack>)Suppliers.memoize(() -> new ItemStack((ItemLike)RuneCraftoryItems.CRYSTAL_WATER.get()))),
    EARTH(ChatFormatting.YELLOW, "earth", 15132176, (Supplier<ItemStack>)Suppliers.memoize(() -> new ItemStack((ItemLike)RuneCraftoryItems.CRYSTAL_EARTH.get()))),
    WIND(ChatFormatting.GREEN, "wind", 0x55FF55, (Supplier<ItemStack>)Suppliers.memoize(() -> new ItemStack((ItemLike)RuneCraftoryItems.CRYSTAL_WIND.get()))),
    FIRE(ChatFormatting.DARK_RED, "fire", 0x991010, (Supplier<ItemStack>)Suppliers.memoize(() -> new ItemStack((ItemLike)RuneCraftoryItems.CRYSTAL_FIRE.get()))),
    LIGHT(ChatFormatting.WHITE, "light", 0xFFFF60, (Supplier<ItemStack>)Suppliers.memoize(() -> new ItemStack((ItemLike)RuneCraftoryItems.CRYSTAL_LIGHT.get()))),
    DARK(ChatFormatting.DARK_PURPLE, "dark", 8523906, (Supplier<ItemStack>)Suppliers.memoize(() -> new ItemStack((ItemLike)RuneCraftoryItems.CRYSTAL_DARK.get()))),
    LOVE(ChatFormatting.RED, "love", 16539900, (Supplier<ItemStack>)Suppliers.memoize(() -> new ItemStack((ItemLike)RuneCraftoryItems.CRYSTAL_LOVE.get())));

    public static final String PREFIX = "runecraftory.element.";
    public final Supplier<ItemStack> icon;
    private final String translation;
    private final ChatFormatting color;
    private final int particleColor;

    private ItemElement(ChatFormatting color, String key, int particleColor, Supplier<ItemStack> icon) {
        this.color = color;
        this.translation = PREFIX + key;
        this.particleColor = particleColor;
        this.icon = icon;
    }

    public static ItemElement opposing(ItemElement element) {
        switch (element.ordinal()) {
            case 6: {
                return LIGHT;
            }
            case 2: {
                return WIND;
            }
            case 4: {
                return WATER;
            }
            case 5: {
                return DARK;
            }
            case 0: {
                return LOVE;
            }
            case 1: {
                return FIRE;
            }
            case 3: {
                return EARTH;
            }
        }
        return NONE;
    }

    public String getTranslation() {
        return this.translation;
    }

    public ChatFormatting getColor() {
        return this.color;
    }

    public int getParticleColor() {
        return this.particleColor;
    }
}

