/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.items.consumables;

import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEffects;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class ItemObjectX
extends Item {
    public ItemObjectX(Item.Properties properties) {
        super(properties);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity livingEntity) {
        if (stack.has(DataComponents.FOOD) && !livingEntity.level().isClientSide) {
            return ItemObjectX.applyEffect(livingEntity, stack);
        }
        return stack;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public static ItemStack applyEffect(LivingEntity livingEntity, ItemStack stack) {
        ItemStack eat = livingEntity.eat(livingEntity.level(), stack);
        List<Holder.Reference> list = BuiltInRegistries.MOB_EFFECT.holders().filter(effect -> ((MobEffect)effect.value()).getCategory() == MobEffectCategory.HARMFUL).toList();
        if (!list.isEmpty()) {
            int r = livingEntity.getRandom().nextInt(4) + 1;
            for (int i = 0; i < r; ++i) {
                Holder.Reference effect2 = list.get(livingEntity.getRandom().nextInt(list.size()));
                int amp = livingEntity.getRandom().nextInt(2);
                MobEffectInstance inst = livingEntity.getEffect((Holder)effect2);
                if (inst != null) {
                    amp += inst.getAmplifier();
                }
                int duration = effect2.value() == RuneCraftoryEffects.SLEEP.get() ? 80 : 600;
                livingEntity.addEffect(new MobEffectInstance((Holder)effect2, duration, amp));
            }
        }
        return eat;
    }
}

