/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.items.creative;

import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryDataComponentTypes;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.common.world.data.farming.FarmlandHandler;
import io.github.flemmli97.tenshilib.common.item.AnimationDebugger;
import io.github.flemmli97.tenshilib.common.item.ExtendedWeapon;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.EntityGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ItemDebug
extends AnimationDebugger
implements ExtendedWeapon {
    public ItemDebug(Item.Properties props) {
        super(props, RuneCraftoryDataComponentTypes.SELECTED_UUID, RuneCraftoryDataComponentTypes.SELECTED_ANIMATION);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, list, tooltipFlag);
        list.add((Component)Component.translatable((String)"runecraftory.item.creative.tooltip").withStyle(ChatFormatting.DARK_RED));
        list.add((Component)Component.translatable((String)"runecraftory.item.creative.tooltip.mode", (Object[])new Object[]{Component.translatable((String)this.getCurrentMode((ItemStack)stack).translationKey).withStyle(ChatFormatting.AQUA)}).withStyle(ChatFormatting.DARK_RED));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (this.getCurrentMode(player.getItemInHand(hand)) == Mode.ANIMATION) {
            return super.use(level, player, hand);
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return InteractionResultHolder.success((Object)player.getItemInHand(hand));
        }
        return super.use(level, player, hand);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int lvl = LevelCalc.levelFromPos(serverLevel, Vec3.atCenterOf((Vec3i)context.getClickedPos()), LevelCalc.playersAround((EntityGetter)serverLevel, Vec3.atCenterOf((Vec3i)context.getClickedPos()), 256.0));
            context.getPlayer().displayClientMessage((Component)Component.literal((String)("GateLevel at pos: " + lvl)), false);
            FarmlandHandler.get(serverLevel.getServer()).getData(serverLevel, context.getClickedPos()).ifPresent(d -> context.getPlayer().displayClientMessage((Component)Component.literal((String)d.toStringFull()), false));
            return InteractionResult.CONSUME;
        }
        return super.useOn(context);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity target, InteractionHand usedHand) {
        if (this.getCurrentMode(stack) == Mode.ANIMATION) {
            return super.interactLivingEntity(stack, player, target, usedHand);
        }
        Level level = player.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (target instanceof Mob) {
                Mob mob = (Mob)target;
                mob.travel(new Vec3(0.0, 0.0, 5.0));
            }
            return InteractionResult.SUCCESS;
        }
        return super.interactLivingEntity(stack, player, target, usedHand);
    }

    public double getRange(LivingEntity entity, ItemStack stack) {
        return super.getRange(entity, stack) + 2.0;
    }

    public void executeAttack(Player player, ItemStack stack) {
        ItemStack main = player.getMainHandItem();
        if (player instanceof ServerPlayer && player.isShiftKeyDown() && stack == main) {
            this.changeMode(stack);
        }
        player.swing(InteractionHand.MAIN_HAND, true);
    }

    private void changeMode(ItemStack stack) {
        Mode mode = this.getCurrentMode(stack);
        stack.set((DataComponentType)RuneCraftoryDataComponentTypes.DEBUG_ITEM_MODE.get(), (Object)(mode == Mode.DEFAULT ? Mode.ANIMATION : Mode.DEFAULT));
    }

    private Mode getCurrentMode(ItemStack stack) {
        return (Mode)((Object)stack.getOrDefault((DataComponentType)RuneCraftoryDataComponentTypes.DEBUG_ITEM_MODE.get(), (Object)Mode.DEFAULT));
    }

    public static enum Mode {
        DEFAULT("runecraftory.item.creative.tooltip.mode.default"),
        ANIMATION("runecraftory.item.creative.tooltip.mode.animation");

        private final String translationKey;

        private Mode(String translationKey) {
            this.translationKey = translationKey;
        }
    }
}

