/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.items.weapons;

import io.github.flemmli97.runecraftory.api.attachment.Skills;
import io.github.flemmli97.runecraftory.api.registry.action.AttackAction;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.lib.ItemTiers;
import io.github.flemmli97.runecraftory.common.network.S2CAttackDebug;
import io.github.flemmli97.runecraftory.common.network.S2CScreenShake;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttackActions;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemComponentUtils;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.common.item.ExtendedWeapon;
import io.github.flemmli97.tenshilib.common.utils.HitResultUtils;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ItemAxeBase
extends AxeItem
implements ExtendedWeapon {
    private static final Vec3[] PARTICLE_DIRECTION = ItemAxeBase.generateParticleDir(2);

    private static Vec3[] generateParticleDir(int range) {
        Vec3[] arr = new Vec3[(2 * range + 1) * (2 * range + 1) - 1];
        int i = 0;
        for (int x = -range; x <= range; ++x) {
            for (int z = -range; z <= range; ++z) {
                if (x == 0 && z == 0) continue;
                arr[i] = new Vec3((double)x, 0.0, (double)z).normalize().scale(1.2);
                ++i;
            }
        }
        return arr;
    }

    public ItemAxeBase(Item.Properties props) {
        super(ItemTiers.TIER, props);
    }

    public static void delayedRightClickAction(LivingEntity entity, ItemStack stack) {
        double reach = CombatUtils.getRange(entity, 0.0);
        S2CScreenShake.sendAround((Entity)entity, 16.0, 4, 3.0f);
        if (ItemAxeBase.performRightClickAction(stack, entity, reach, 0.7f) && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            LevelCalc.levelSkill(Platform.INSTANCE.getPlayerData((Player)player), Skills.HAMMERAXE, 5.0f);
        }
    }

    public static boolean performRightClickAction(ItemStack stack, LivingEntity entity, double range, float knockback) {
        Collection<LivingEntity> list = ItemAxeBase.getEntitiesIn(entity, range, null);
        entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.DRAGON_FIREBALL_EXPLODE, entity.getSoundSource(), 1.0f, 0.4f);
        Vec3 pos = entity.position().add(0.0, -1.0, 0.0);
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
        for (Vec3 dir : PARTICLE_DIRECTION) {
            Vec3 scaled = dir.scale(0.5);
            mut.set(Mth.floor((double)(pos.x() + dir.x())), Mth.floor((double)pos.y()), Mth.floor((double)(pos.z() + dir.z())));
            BlockState blockState = entity.level().getBlockState((BlockPos)mut);
            if (blockState.getRenderShape() == RenderShape.INVISIBLE) continue;
            ((ServerLevel)entity.level()).sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, blockState), entity.getX() + dir.x(), entity.getY() + 0.1, entity.getZ() + dir.z(), 0, (double)((float)scaled.x()), 1.5, (double)((float)scaled.z()), 1.0);
        }
        if (!list.isEmpty()) {
            Supplier<DynamicDamage.Builder> base = () -> new DynamicDamage.Builder((Entity)entity).element(ItemComponentUtils.getElement(stack)).knock(DynamicDamage.KnockBackType.UP, knockback).hurtResistant(5);
            boolean success = false;
            double damagePhys = CombatUtils.getAttributeValue((Entity)entity, (Holder<Attribute>)Attributes.ATTACK_DAMAGE) * 1.1;
            for (Entity entity2 : list) {
                if (!CombatUtils.damageWithFaintAndCrit((Entity)entity, entity2, base.get(), damagePhys, stack)) continue;
                success = true;
            }
            return success;
        }
        return false;
    }

    public static Collection<LivingEntity> getEntitiesIn(LivingEntity entity, double reach, Predicate<LivingEntity> pred) {
        double incHalf = Math.asin(0.5 / reach) * 57.2957763671875;
        float minYRot = 0.0f;
        float maxYRot = 360.0f;
        AABB aabb = new AABB(-0.5, -0.15, 0.0, 0.5, 1.15, reach);
        int rotationSteps = (int)((double)(maxYRot - minYRot) / (incHalf * 2.0)) + 2;
        float inc = (maxYRot - minYRot) / (float)rotationSteps;
        HashSet<LivingEntity> entities = new HashSet<LivingEntity>();
        Predicate<LivingEntity> predicate = e -> entity.getVehicle() != e && (pred == null || pred.test((LivingEntity)e));
        for (int steps = 0; steps <= rotationSteps; ++steps) {
            float yRot = minYRot + inc * (float)steps;
            OrientedBoundingBox obb = new OrientedBoundingBox(aabb, yRot, 0.0f, entity.position());
            entities.addAll(HitResultUtils.getEntities((LivingEntity)entity, (OrientedBoundingBox)obb, (boolean)true, (EntityTypeTest)EntityTypeTest.forClass(LivingEntity.class), predicate));
            S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTACK, (Entity)entity);
        }
        return entities;
    }

    public void executeAttack(Player player, ItemStack stack) {
        Platform.INSTANCE.getPlayerData(player).getWeaponHandler().doWeaponAttack((AttackAction)RuneCraftoryAttackActions.HAMMER_AXE.get(), stack);
    }

    public boolean attackOnBlock(LivingEntity entity, ItemStack stack) {
        return true;
    }

    public void onUseTick(Level level, LivingEntity entity, ItemStack stack, int remainingUseDuration) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            int duration = stack.getUseDuration(entity) - remainingUseDuration;
            if (duration == ItemComponentUtils.getChargeTime(entity)) {
                EntityUtils.playSoundForPlayer(player, (Holder<SoundEvent>)SoundEvents.NOTE_BLOCK_XYLOPHONE, 1.0f, 1.0f);
            }
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        boolean canCharge;
        ItemStack itemstack = player.getItemInHand(hand);
        if (hand == InteractionHand.OFF_HAND) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        PlayerData data = Platform.INSTANCE.getPlayerData(player);
        boolean bl = canCharge = (data.getSkillLevel(Skills.HAMMERAXE).getLevel() >= 5 || player.isCreative()) && data.getWeaponHandler().canExecuteAction((AttackAction)RuneCraftoryAttackActions.HAMMER_AXE_USE.get());
        if (canCharge) {
            player.startUsingItem(hand);
            return InteractionResultHolder.consume((Object)itemstack);
        }
        return InteractionResultHolder.pass((Object)itemstack);
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
        if (!level.isClientSide && stack.getUseDuration(entity) - timeLeft - 1 >= ItemComponentUtils.getChargeTime(entity)) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                Platform.INSTANCE.getPlayerData((Player)player).getWeaponHandler().doWeaponAttack((AttackAction)RuneCraftoryAttackActions.HAMMER_AXE_USE.get(), stack);
                return;
            }
            if (ItemAxeBase.performRightClickAction(stack, entity, this.getRange(entity, stack), 0.7f)) {
                entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.PLAYER_ATTACK_STRONG, entity.getSoundSource(), 1.0f, 1.0f);
            }
        }
    }

    public boolean canAttackBlock(BlockState state, Level level, BlockPos pos, Player player) {
        return !player.isCreative();
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }
}

