/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.items.weapons;

import io.github.flemmli97.runecraftory.api.attachment.Skills;
import io.github.flemmli97.runecraftory.api.registry.action.AttackAction;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttackActions;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemComponentUtils;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.common.item.AOEWeapon;
import io.github.flemmli97.tenshilib.common.item.ExtendedWeapon;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class ItemSpearBase
extends Item
implements ExtendedWeapon {
    public ItemSpearBase(Item.Properties props) {
        super(props);
    }

    public void executeAttack(Player player, ItemStack stack) {
        Platform.INSTANCE.getPlayerData(player).getWeaponHandler().doWeaponAttack((AttackAction)RuneCraftoryAttackActions.SPEAR.get(), stack);
    }

    public boolean attackOnBlock(LivingEntity entity, ItemStack stack) {
        return true;
    }

    public void onUseTick(Level level, LivingEntity entity, ItemStack stack, int remainingUseDuration) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            int duration = stack.getUseDuration(entity) - remainingUseDuration;
            if (duration == ItemComponentUtils.getChargeTime(entity)) {
                EntityUtils.playSoundForPlayer(player, (Holder<SoundEvent>)SoundEvents.NOTE_BLOCK_XYLOPHONE, 1.0f, 1.0f);
            }
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (hand == InteractionHand.OFF_HAND) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        PlayerData data = Platform.INSTANCE.getPlayerData(player);
        if (player.isCreative() || data.getSkillLevel(Skills.SPEAR).getLevel() >= 5) {
            if (player instanceof ServerPlayer) {
                if (data.getWeaponHandler().canExecuteAction((AttackAction)RuneCraftoryAttackActions.SPEAR_USE.get(), false)) {
                    data.getWeaponHandler().doWeaponAttack((AttackAction)RuneCraftoryAttackActions.SPEAR_USE.get(), itemstack);
                } else if (data.getWeaponHandler().getCurrentAction() == RuneCraftoryAttackActions.NONE.get()) {
                    player.startUsingItem(hand);
                }
            }
            return InteractionResultHolder.consume((Object)itemstack);
        }
        return InteractionResultHolder.pass((Object)itemstack);
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            PlayerData data = Platform.INSTANCE.getPlayerData((Player)serverPlayer);
            int time = stack.getUseDuration(entity) - timeLeft - 1;
            if (time >= ItemComponentUtils.getChargeTime(entity) && data.getWeaponHandler().canExecuteAction((AttackAction)RuneCraftoryAttackActions.SPEAR_USE.get())) {
                data.getWeaponHandler().doWeaponAttack((AttackAction)RuneCraftoryAttackActions.SPEAR_USE.get(), stack);
            }
        }
    }

    public boolean canAttackBlock(BlockState state, Level level, BlockPos pos, Player player) {
        return !player.isCreative();
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    public void useSpear(ServerPlayer player, ItemStack stack, boolean finishing) {
        Collection<LivingEntity> list = CombatUtils.EntityAttack.obbTargets(AOEWeapon.createOBB((LivingEntity)player, (double)this.getRange((LivingEntity)player, stack), (double)0.5, (double)0.5)).apply((LivingEntity)player, null);
        if (!list.isEmpty()) {
            LevelCalc.levelSkill(Platform.INSTANCE.getPlayerData((Player)player), Skills.SPEAR, 2.0f);
            list.forEach(e -> CombatUtils.attackWithItem((Player)player, (Entity)e, player.getMainHandItem(), 0.6f, false, false));
        }
        if (finishing) {
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)RuneCraftorySounds.PLAYER_ATTACK_SWOOSH.get(), player.getSoundSource(), 1.0f, (player.getRandom().nextFloat() - player.getRandom().nextFloat()) * 0.2f + 1.5f);
        } else {
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)RuneCraftorySounds.PLAYER_ATTACK_SWOOSH_LIGHT.get(), player.getSoundSource(), 1.0f, (player.getRandom().nextFloat() - player.getRandom().nextFloat()) * 0.2f + 1.0f);
        }
    }
}

