/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.network;

import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryCriteria;
import io.github.flemmli97.runecraftory.platform.Platform;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class C2SSetMonsterBehaviour
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<C2SSetMonsterBehaviour> TYPE = new CustomPacketPayload.Type(RuneCraftory.modRes("c2s_monster_behaviour"));
    public static final StreamCodec<RegistryFriendlyByteBuf, C2SSetMonsterBehaviour> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, C2SSetMonsterBehaviour>(){

        public C2SSetMonsterBehaviour decode(RegistryFriendlyByteBuf buf) {
            return new C2SSetMonsterBehaviour(buf.readInt(), (Action)buf.readEnum(Action.class));
        }

        public void encode(RegistryFriendlyByteBuf buf, C2SSetMonsterBehaviour pkt) {
            buf.writeInt(pkt.id);
            buf.writeEnum((Enum)pkt.type);
        }
    };
    private final int id;
    private final Action type;

    public C2SSetMonsterBehaviour(int entityID, Action type) {
        this.id = entityID;
        this.type = type;
    }

    public static C2SSetMonsterBehaviour read(RegistryFriendlyByteBuf buf) {
        return new C2SSetMonsterBehaviour(buf.readInt(), (Action)buf.readEnum(Action.class));
    }

    public static void handle(C2SSetMonsterBehaviour pkt, ServerPlayer sender) {
        Entity entity = sender.level().getEntity(pkt.id);
        if (entity instanceof BaseMonster) {
            BaseMonster monster = (BaseMonster)entity;
            if (sender.getUUID().equals(monster.getOwnerUUID())) {
                switch (pkt.type.ordinal()) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        PlayerData data = Platform.INSTANCE.getPlayerData((Player)sender);
                        if (pkt.type == Action.FOLLOW && !data.party.isPartyMember(entity) && data.party.isPartyFull()) {
                            sender.displayClientMessage((Component)Component.translatable((String)"runecraftory.monster.interact.party.full"), false);
                            return;
                        }
                        monster.setBehaviour(pkt.type.behaviour);
                        sender.displayClientMessage((Component)Component.translatable((String)monster.behaviourState().interactKey, (Object[])new Object[]{monster.getDisplayName()}), false);
                        break;
                    }
                    case 5: {
                        monster.setBehaviour(BaseMonster.Behaviour.FARM);
                        sender.displayClientMessage((Component)Component.translatable((String)monster.behaviourState().interactKey, (Object[])new Object[]{monster.getDisplayName()}), false);
                        ((PlayerTrigger)RuneCraftoryCriteria.COMMAND_FARMING.get()).trigger(sender);
                        break;
                    }
                    case 9: 
                    case 10: {
                        PlayerData data = Platform.INSTANCE.getPlayerData((Player)sender);
                        data.entitySelector.selectedEntity = monster;
                        data.entitySelector.poi = monster.getRestrictCenter();
                        data.entitySelector.apply = (player, pos) -> {
                            monster.restrictToBasedOnBehaviour((BlockPos)pos, false);
                            data.entitySelector.poi = monster.getRestrictCenter();
                        };
                        break;
                    }
                    case 6: {
                        PlayerData data = Platform.INSTANCE.getPlayerData((Player)sender);
                        data.entitySelector.selectedEntity = monster;
                        data.entitySelector.poi = monster.getCropInventory();
                        data.entitySelector.apply = (player, pos) -> {
                            if (monster.isWithinRestriction((BlockPos)pos)) {
                                monster.setCropInventory((BlockPos)pos);
                                data.entitySelector.poi = monster.getCropInventory();
                                player.displayClientMessage((Component)Component.translatable((String)"runecraftory.behaviour.inventory.harvest"), false);
                            } else {
                                player.displayClientMessage((Component)Component.translatable((String)"runecraftory.behaviour.inventory.harvest.invalid"), false);
                            }
                        };
                        break;
                    }
                    case 7: {
                        PlayerData data = Platform.INSTANCE.getPlayerData((Player)sender);
                        data.entitySelector.selectedEntity = monster;
                        data.entitySelector.poi = monster.getSeedInventory();
                        data.entitySelector.apply = (player, pos) -> {
                            if (monster.isWithinRestriction((BlockPos)pos)) {
                                monster.setSeedInventory((BlockPos)pos);
                                data.entitySelector.poi = monster.getSeedInventory();
                                player.displayClientMessage((Component)Component.translatable((String)"runecraftory.behaviour.inventory.seed"), false);
                            } else {
                                player.displayClientMessage((Component)Component.translatable((String)"runecraftory.behaviour.inventory.seed.invalid"), false);
                            }
                        };
                        break;
                    }
                    case 8: {
                        if (monster.behaviourState() != BaseMonster.Behaviour.FOLLOW && monster.behaviourState() != BaseMonster.Behaviour.FOLLOW_DISTANCE && monster.behaviourState() != BaseMonster.Behaviour.STAY) break;
                        monster.doStartRide(sender);
                    }
                }
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static enum Action {
        HOME("runecraftory.gui.companion.behaviour.home", BaseMonster.Behaviour.WANDER_HOME),
        FOLLOW("runecraftory.gui.companion.behaviour.follow", BaseMonster.Behaviour.FOLLOW),
        FOLLOW_DISTANCE("runecraftory.gui.companion.behaviour.follow_distance", BaseMonster.Behaviour.FOLLOW_DISTANCE),
        STAY("runecraftory.gui.companion.behaviour.stay", BaseMonster.Behaviour.STAY),
        WANDER("runecraftory.gui.companion.behaviour.wander", BaseMonster.Behaviour.WANDER),
        FARM("runecraftory.gui.companion.behaviour.farm", BaseMonster.Behaviour.FARM),
        HARVESTINV("runecraftory.gui.companion.behaviour.harvest", BaseMonster.Behaviour.FARM),
        SEEDINV("runecraftory.gui.companion.behaviour.seed", BaseMonster.Behaviour.FARM),
        RIDE("runecraftory.gui.companion.behaviour.ride", BaseMonster.Behaviour.FOLLOW),
        CENTER("runecraftory.gui.companion.behaviour.center", BaseMonster.Behaviour.WANDER),
        CENTER_FARM("runecraftory.gui.companion.behaviour.center", BaseMonster.Behaviour.FARM);

        public final String translation;
        public final BaseMonster.Behaviour behaviour;

        private Action(String translation, BaseMonster.Behaviour behaviour) {
            this.translation = translation;
            this.behaviour = behaviour;
        }
    }
}

