/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.network;

import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.common.components.NPCSpawnData;
import io.github.flemmli97.runecraftory.common.items.creative.NPCSpawnEgg;
import io.github.flemmli97.runecraftory.common.items.creative.RuneCraftoryEggItem;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryDataComponentTypes;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class C2SSpawnEgg
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<C2SSpawnEgg> TYPE = new CustomPacketPayload.Type(RuneCraftory.modRes("c2s_spawn_egg"));
    public static final StreamCodec<RegistryFriendlyByteBuf, C2SSpawnEgg> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, C2SSpawnEgg>(){

        public C2SSpawnEgg decode(RegistryFriendlyByteBuf buf) {
            return new C2SSpawnEgg((InteractionHand)buf.readEnum(InteractionHand.class), buf.readInt(), buf.readBoolean() ? buf.readResourceLocation() : null, buf.readBoolean() ? buf.readResourceLocation() : null);
        }

        public void encode(RegistryFriendlyByteBuf buf, C2SSpawnEgg pkt) {
            buf.writeEnum((Enum)pkt.hand);
            buf.writeInt(pkt.level);
            buf.writeBoolean(pkt.npcProfession != null);
            if (pkt.npcProfession != null) {
                buf.writeResourceLocation(pkt.npcProfession);
            }
            buf.writeBoolean(pkt.npcID != null);
            if (pkt.npcID != null) {
                buf.writeResourceLocation(pkt.npcID);
            }
        }
    };
    private final InteractionHand hand;
    private final int level;
    private final ResourceLocation npcProfession;
    private final ResourceLocation npcID;

    public C2SSpawnEgg(InteractionHand hand, int level, @Nullable ResourceLocation npcProfession, @Nullable ResourceLocation npcID) {
        this.hand = hand;
        this.level = level;
        this.npcProfession = npcProfession;
        this.npcID = npcID;
    }

    public static void handle(C2SSpawnEgg pkt, ServerPlayer sender) {
        ItemStack stack = sender.getItemInHand(pkt.hand);
        if (stack.getItem() instanceof RuneCraftoryEggItem) {
            stack.set((DataComponentType)RuneCraftoryDataComponentTypes.SPAWN_EGG_LEVEL.get(), (Object)Math.max(1, pkt.level));
            if (stack.getItem() instanceof NPCSpawnEgg) {
                NPCSpawnData data = (NPCSpawnData)stack.getOrDefault((DataComponentType)RuneCraftoryDataComponentTypes.NPC_SPAWN_DATA.get(), (Object)NPCSpawnData.DEFAULT);
                stack.set((DataComponentType)RuneCraftoryDataComponentTypes.NPC_SPAWN_DATA.get(), (Object)data.withId(pkt.npcID).withProfession((HolderLookup.Provider)sender.registryAccess(), pkt.npcProfession));
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

