/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.network;

import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.registry.NPCProfession;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryNPCProfessions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class S2CUpdateNPCData
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<S2CUpdateNPCData> TYPE = new CustomPacketPayload.Type(RuneCraftory.modRes("s2c_npc_data"));
    public static final StreamCodec<RegistryFriendlyByteBuf, S2CUpdateNPCData> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, S2CUpdateNPCData>(){

        public S2CUpdateNPCData decode(RegistryFriendlyByteBuf buf) {
            return new S2CUpdateNPCData(buf.readInt(), buf.readNbt(), buf.readNbt(), (NPCProfession)ByteBufCodecs.registry(RuneCraftoryNPCProfessions.PROFESSION_REGISTRY_KEY).decode((Object)buf));
        }

        public void encode(RegistryFriendlyByteBuf buf, S2CUpdateNPCData pkt) {
            buf.writeInt(pkt.entityID);
            buf.writeNbt((Tag)pkt.hearts);
            buf.writeNbt((Tag)pkt.schedule);
            ByteBufCodecs.registry(RuneCraftoryNPCProfessions.PROFESSION_REGISTRY_KEY).encode((Object)buf, (Object)pkt.profession);
        }
    };
    private final int entityID;
    private final CompoundTag hearts;
    private final CompoundTag schedule;
    private final NPCProfession profession;

    private S2CUpdateNPCData(int id, CompoundTag tag, CompoundTag schedule, NPCProfession profession) {
        this.entityID = id;
        this.hearts = tag;
        this.schedule = schedule;
        this.profession = profession;
    }

    public S2CUpdateNPCData(NPCEntity entity, CompoundTag hearts) {
        this.entityID = entity.getId();
        this.hearts = hearts;
        this.schedule = entity.getNPCSchedule().save();
        this.profession = entity.getProfession();
    }

    public static void handle(S2CUpdateNPCData pkt, Player player) {
        Entity e = player.level().getEntity(pkt.entityID);
        if (e instanceof NPCEntity) {
            NPCEntity npc = (NPCEntity)e;
            npc.handleUpdatePacket(player, pkt.hearts, pkt.schedule, pkt.profession);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

