/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.particles;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.IdMap;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class BlockStateParticleData
implements ParticleOptions {
    private final ParticleType<? extends BlockStateParticleData> type;
    private final BlockState state;
    private final float yaw;
    private final float pitch;
    private final int duration;

    public static MapCodec<BlockStateParticleData> codec(ParticleType<BlockStateParticleData> type) {
        return BlockState.CODEC.fieldOf("state").xmap(blockState -> new BlockStateParticleData((ParticleType<? extends BlockStateParticleData>)type, (BlockState)blockState), BlockParticleOptionEx -> BlockParticleOptionEx.state);
    }

    public static StreamCodec<RegistryFriendlyByteBuf, BlockStateParticleData> streamCodec(final ParticleType<BlockStateParticleData> type) {
        return new StreamCodec<RegistryFriendlyByteBuf, BlockStateParticleData>(){

            public BlockStateParticleData decode(RegistryFriendlyByteBuf buf) {
                return new BlockStateParticleData((ParticleType<? extends BlockStateParticleData>)type, (BlockState)ByteBufCodecs.idMapper((IdMap)Block.BLOCK_STATE_REGISTRY).decode((Object)buf), buf.readFloat(), buf.readFloat(), buf.readInt());
            }

            public void encode(RegistryFriendlyByteBuf buf, BlockStateParticleData data) {
                ByteBufCodecs.idMapper((IdMap)Block.BLOCK_STATE_REGISTRY).encode((Object)buf, (Object)data.state);
                buf.writeFloat(data.yaw);
                buf.writeFloat(data.pitch);
                buf.writeInt(data.duration);
            }
        };
    }

    public BlockStateParticleData(ParticleType<? extends BlockStateParticleData> type, BlockState state) {
        this(type, state, 0.0f, 0.0f, 40);
    }

    public BlockStateParticleData(ParticleType<? extends BlockStateParticleData> type, BlockState state, float yaw, float pitch, int duration) {
        this.type = type;
        this.state = state;
        this.yaw = yaw;
        this.pitch = pitch;
        this.duration = duration;
    }

    public BlockState getState() {
        return this.state;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public int getDuration() {
        return this.duration;
    }

    public ParticleType<? extends BlockStateParticleData> getType() {
        return this.type;
    }
}

