/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.particles;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryParticles;
import io.github.flemmli97.tenshilib.common.utils.CodecUtils;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public class SkelefangParticleData
implements ParticleOptions {
    private static final Random RANDOM = new Random();
    public static final MapCodec<SkelefangParticleData> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)CodecUtils.stringEnumCodec(SkelefangBoneType.class, (Enum)SkelefangBoneType.GENERIC).fieldOf("bone").forGetter(SkelefangParticleData::getBoneType), (App)Codec.FLOAT.fieldOf("init_x").forGetter(SkelefangParticleData::getInitialRotX), (App)Codec.FLOAT.fieldOf("init_y").forGetter(SkelefangParticleData::getInitialRotY), (App)Codec.FLOAT.fieldOf("rot_x").forGetter(SkelefangParticleData::getPitchSpin), (App)Codec.FLOAT.fieldOf("rot_y").forGetter(SkelefangParticleData::getYawSpin), (App)Codec.INT.fieldOf("max_ticks").forGetter(SkelefangParticleData::getMaxTime), (App)Codec.BOOL.fieldOf("gravity").forGetter(SkelefangParticleData::hasGravity)).apply((Applicative)builder, (bone, initX, initY, rotX, rotY, maxTick, gravity) -> new SkelefangParticleData((SkelefangBoneType)((Object)((Object)bone)), initX.floatValue(), initY.floatValue(), rotX.floatValue(), rotX.floatValue(), (int)maxTick, (boolean)gravity)));
    public static final StreamCodec<RegistryFriendlyByteBuf, SkelefangParticleData> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, SkelefangParticleData>(){

        public SkelefangParticleData decode(RegistryFriendlyByteBuf buf) {
            return new SkelefangParticleData((SkelefangBoneType)buf.readEnum(SkelefangBoneType.class), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readInt(), buf.readBoolean());
        }

        public void encode(RegistryFriendlyByteBuf buf, SkelefangParticleData data) {
            buf.writeEnum((Enum)data.getBoneType());
            buf.writeFloat(data.getInitialRotX());
            buf.writeFloat(data.getInitialRotY());
            buf.writeFloat(data.getPitchSpin());
            buf.writeFloat(data.getYawSpin());
            buf.writeInt(data.getMaxTime());
            buf.writeBoolean(data.hasGravity());
        }
    };
    private final SkelefangBoneType boneType;
    private final float initialRotX;
    private final float initialRotY;
    private final float pitchSpin;
    private final float yawSpin;
    private final int maxTime;
    private final boolean gravity;

    public SkelefangParticleData(SkelefangBoneType boneType, float initialRotX, float initialRotY, float pitchSpin, float yawSpin) {
        this(boneType, initialRotX, initialRotY, pitchSpin, yawSpin, (int)(RANDOM.nextFloat() * 10.0f + 15.0f), true);
    }

    public SkelefangParticleData(SkelefangBoneType boneType, float initialRotX, float initialRotY, float pitchSpin, float yawSpin, int maxTime, boolean gravity) {
        this.boneType = boneType;
        this.initialRotX = initialRotX;
        this.initialRotY = initialRotY;
        this.pitchSpin = pitchSpin;
        this.yawSpin = yawSpin;
        this.maxTime = maxTime;
        this.gravity = gravity;
    }

    public ParticleType<?> getType() {
        return (ParticleType)RuneCraftoryParticles.SKELEFANG_BONES.get();
    }

    public SkelefangBoneType getBoneType() {
        return this.boneType;
    }

    public float getInitialRotX() {
        return this.initialRotX;
    }

    public float getInitialRotY() {
        return this.initialRotY;
    }

    public float getPitchSpin() {
        return this.pitchSpin;
    }

    public float getYawSpin() {
        return this.yawSpin;
    }

    public int getMaxTime() {
        return this.maxTime;
    }

    public boolean hasGravity() {
        return this.gravity;
    }

    public static enum SkelefangBoneType {
        HEAD,
        NECK,
        FRONT,
        FRONT_RIBS,
        LEFT_LEG,
        RIGHT_LEG,
        BACK,
        BACK_RIBS,
        TAIL,
        TAIL_BASE,
        GENERIC,
        GENERIC2;

    }
}

