/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.quests.tasks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.simplequests_api.SimpleQuestsAPI;
import io.github.flemmli97.simplequests_api.player.PlayerQuestData;
import io.github.flemmli97.simplequests_api.player.QuestProgress;
import io.github.flemmli97.simplequests_api.quest.QuestBase;
import io.github.flemmli97.simplequests_api.quest.entry.QuestEntryKey;
import io.github.flemmli97.simplequests_api.quest.entry.QuestTask;
import io.github.flemmli97.simplequests_api.quest.entry.ResolvedQuestTask;
import io.github.flemmli97.simplequests_api.util.DescriptiveValue;
import java.util.List;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public class ShippingTask
implements QuestTask<SkillLevelTaskResolved> {
    public static final QuestEntryKey<ShippingTask> ID = new QuestEntryKey(RuneCraftory.modRes("shipping"));
    public static final MapCodec<ShippingTask> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("description").forGetter(d -> d.description), (App)ExtraCodecs.nonEmptyList((Codec)DescriptiveValue.withTranslation((Codec)ItemPredicate.CODEC).listOf()).fieldOf("item_predicates").forGetter(d -> d.itemPredicates), (App)NumberProviders.CODEC.fieldOf("amount").forGetter(d -> d.amount)).apply((Applicative)instance, ShippingTask::new));
    private final String description;
    private final List<DescriptiveValue<ItemPredicate>> itemPredicates;
    private final NumberProvider amount;

    public ShippingTask(String description, List<DescriptiveValue<ItemPredicate>> itemPredicates, NumberProvider amount) {
        this.description = description;
        this.itemPredicates = itemPredicates;
        this.amount = amount;
        if (this.description.isEmpty() && !this.simple()) {
            throw new IllegalStateException("Description is required");
        }
    }

    private boolean simple() {
        return this.itemPredicates.size() == 1 && this.amount instanceof ConstantValue;
    }

    public MutableComponent translation(ServerPlayer player) {
        if (this.description.isEmpty() && this.simple()) {
            return this.itemPredicates.getFirst().getTranslation(this.getId().toString(), new Object[]{this.amount.getInt(null)});
        }
        return Component.translatable((String)this.description);
    }

    public QuestEntryKey<?> getId() {
        return ID;
    }

    public SkillLevelTaskResolved resolve(PlayerQuestData data, QuestProgress progress, QuestBase base) {
        LootContext ctx = SimpleQuestsAPI.createContext((PlayerQuestData)data, (ResourceLocation)base.id);
        DescriptiveValue<ItemPredicate> val = this.itemPredicates.get(ctx.getRandom().nextInt(this.itemPredicates.size()));
        return new SkillLevelTaskResolved(val, this.amount.getInt(ctx));
    }

    public record SkillLevelTaskResolved(DescriptiveValue<ItemPredicate> item, int amount) implements ResolvedQuestTask
    {
        public static final MapCodec<SkillLevelTaskResolved> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DescriptiveValue.withTranslation((Codec)ItemPredicate.CODEC).fieldOf("item").forGetter(d -> d.item), (App)ExtraCodecs.POSITIVE_INT.fieldOf("amount").forGetter(d -> d.amount)).apply((Applicative)instance, SkillLevelTaskResolved::new));

        public boolean submit(ServerPlayer player) {
            return Platform.INSTANCE.getPlayerData((Player)player).getPlayerLevel().getLevel() >= this.amount;
        }

        public QuestEntryKey<ShippingTask> getId() {
            return ID;
        }

        public MutableComponent translation(ServerPlayer player) {
            return this.item.getTranslation(this.getId().toString(), new Object[]{this.amount});
        }
    }
}

