/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.inventory.PlayerBoundCraftingContainer;
import io.github.flemmli97.runecraftory.common.recipes.CraftingType;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryCrafting;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryItems;
import io.github.flemmli97.runecraftory.common.utils.CraftingUtils;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public abstract class SextupleRecipe
implements Recipe<PlayerBoundCraftingContainer> {
    private final String group;
    private final ItemStack recipeOutput;
    private final NonNullList<Ingredient> recipeItems;
    private final int craftingLevel;
    private final int baseCost;

    public SextupleRecipe(String group, int level, int baseCost, ItemStack result, NonNullList<Ingredient> ingredients) {
        this.group = group;
        this.recipeOutput = result;
        this.recipeItems = ingredients;
        this.craftingLevel = level;
        this.baseCost = baseCost;
    }

    @Nullable
    public static MatchResult calculateMatches(SextupleRecipe recipe, NonNullList<ItemStack> inv) {
        if (inv.size() > 6) {
            return null;
        }
        for (ItemStack s : inv) {
            if (recipe.areItemsFitting(s)) continue;
            return null;
        }
        NonNullList list = NonNullList.create();
        NonNullList bonus = NonNullList.create();
        block1: for (Ingredient ingredient : recipe.getIngredients()) {
            for (ItemStack stack : inv) {
                if (!ingredient.test(stack) || list.contains((Object)stack)) continue;
                list.add((Object)stack);
                continue block1;
            }
        }
        if (list.size() != recipe.getIngredients().size()) {
            return null;
        }
        for (ItemStack stack : inv) {
            if (list.contains((Object)stack)) continue;
            bonus.add((Object)stack);
        }
        if (!recipe.requireExactMatch() && !bonus.isEmpty()) {
            return null;
        }
        return new MatchResult((NonNullList<ItemStack>)list, (NonNullList<ItemStack>)bonus);
    }

    @Nullable
    public static RecipeOutput getCraftingOutput(PlayerBoundCraftingContainer inv, RecipeHolder<? extends SextupleRecipe> holder) {
        SextupleRecipe recipe = (SextupleRecipe)holder.value();
        if (!recipe.matches(inv, inv.getPlayer().level())) {
            return null;
        }
        boolean unlocked = Platform.INSTANCE.getPlayerData(inv.getPlayer()).getRecipeKeeper().isUnlocked(holder);
        if (!unlocked && !GeneralConfig.recipeSystem.allowLocked) {
            return null;
        }
        return recipe.createOutput(inv, unlocked);
    }

    public boolean matches(PlayerBoundCraftingContainer input, Level level) {
        if (input.getContainerSize() < 6) {
            return false;
        }
        NonNullList stacks = NonNullList.create();
        for (int j = 0; j < 6; ++j) {
            ItemStack itemStack = input.getItem(j);
            if (itemStack.isEmpty()) continue;
            stacks.add((Object)itemStack);
        }
        MatchResult result = SextupleRecipe.calculateMatches(this, (NonNullList<ItemStack>)stacks);
        return result != null;
    }

    public ItemStack assemble(PlayerBoundCraftingContainer input, HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= this.recipeItems.size();
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.getRecipeOutput();
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.recipeItems;
    }

    public String getGroup() {
        return this.group;
    }

    public boolean isSpecial() {
        return true;
    }

    public RecipeOutput createOutput(PlayerBoundCraftingContainer inv, boolean unlocked) {
        NonNullList stacks = NonNullList.create();
        for (int j = 0; j < 6; ++j) {
            ItemStack itemStack = inv.getItem(j);
            if (itemStack.isEmpty()) continue;
            stacks.add((Object)itemStack);
        }
        MatchResult matches = SextupleRecipe.calculateMatches(this, (NonNullList<ItemStack>)stacks);
        if (matches == null) {
            return null;
        }
        CraftingType type = CraftingType.FORGE;
        if (this.getType() == RuneCraftoryCrafting.ARMOR.get()) {
            type = CraftingType.ACCESSORY_WORKBENCH;
        }
        if (this.getType() == RuneCraftoryCrafting.CHEMISTRY.get()) {
            type = CraftingType.CHEMISTRY_SET;
        }
        if (this.getType() == RuneCraftoryCrafting.COOKING.get()) {
            type = CraftingType.COOKING_TABLE;
        }
        ItemStack trueOutput = CraftingUtils.getCraftingOutput(this.getResultItem((HolderLookup.Provider)inv.getPlayer().registryAccess()), inv, matches, type);
        return new RecipeOutput(trueOutput, unlocked ? trueOutput : new ItemStack((ItemLike)RuneCraftoryItems.UNKNOWN.get()), matches.bonusItems());
    }

    protected ItemStack getRecipeOutput() {
        return this.recipeOutput.copy();
    }

    public boolean areItemsFitting(ItemStack stack) {
        return true;
    }

    public boolean requireExactMatch() {
        return false;
    }

    public int getCraftingLevel() {
        return this.craftingLevel;
    }

    public int getAdditionalCost() {
        return this.baseCost;
    }

    public String toString() {
        return String.format("Result: %s; Required Level: %d", this.recipeOutput, this.craftingLevel);
    }

    public record MatchResult(NonNullList<ItemStack> recipeMatches, NonNullList<ItemStack> bonusItems) {
    }

    public record RecipeOutput(ItemStack serverResult, ItemStack clientResult, NonNullList<ItemStack> bonusItems) {
    }

    public static class Serializer<T extends SextupleRecipe>
    implements RecipeSerializer<T> {
        private final MapCodec<T> codec;
        private final StreamCodec<RegistryFriendlyByteBuf, T> streamCodec;

        public Serializer(Factory<T> factory) {
            this.codec = Serializer.mapCodec(factory);
            this.streamCodec = Serializer.streamCodec(factory);
        }

        protected static <T extends SextupleRecipe> MapCodec<T> mapCodec(Factory<T> factory) {
            return RecordCodecBuilder.mapCodec((T instance) -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(SextupleRecipe::getGroup), (App)ExtraCodecs.POSITIVE_INT.fieldOf("required_level").forGetter(SextupleRecipe::getCraftingLevel), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("crafting_cost").forGetter(SextupleRecipe::getAdditionalCost), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(SextupleRecipe::getRecipeOutput), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(list -> {
                Object[] ingredients = (Ingredient[])list.stream().filter(ingredient -> !ingredient.isEmpty()).toArray(Ingredient[]::new);
                if (ingredients.length == 0) {
                    return DataResult.error(() -> "No ingredients for shapeless recipe");
                }
                return ingredients.length > 9 ? DataResult.error(() -> "Too many ingredients for shapeless recipe") : DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])ingredients));
            }, DataResult::success).forGetter(SextupleRecipe::getIngredients)).apply((Applicative)instance, factory::get));
        }

        protected static <T extends SextupleRecipe> StreamCodec<RegistryFriendlyByteBuf, T> streamCodec(final Factory<T> factory) {
            return new StreamCodec<RegistryFriendlyByteBuf, T>(){

                public T decode(RegistryFriendlyByteBuf buf) {
                    return factory.get(buf.readUtf(), buf.readInt(), buf.readInt(), (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf), this.fromBuffer(buf));
                }

                private NonNullList<Ingredient> fromBuffer(RegistryFriendlyByteBuf buf) {
                    List read = buf.readList(b -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf));
                    NonNullList ingredients = NonNullList.withSize((int)read.size(), (Object)Ingredient.EMPTY);
                    for (int i = 0; i < read.size(); ++i) {
                        ingredients.set(i, (Object)((Ingredient)read.get(i)));
                    }
                    return ingredients;
                }

                public void encode(RegistryFriendlyByteBuf buf, T recipe) {
                    buf.writeUtf(((SextupleRecipe)recipe).getGroup());
                    buf.writeInt(((SextupleRecipe)recipe).getCraftingLevel());
                    buf.writeInt(((SextupleRecipe)recipe).getAdditionalCost());
                    ItemStack.STREAM_CODEC.encode((Object)buf, (Object)((SextupleRecipe)recipe).getRecipeOutput());
                    buf.writeCollection(((SextupleRecipe)recipe).getIngredients(), (b, i) -> Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, i));
                }
            };
        }

        public MapCodec<T> codec() {
            return this.codec;
        }

        public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
            return this.streamCodec;
        }

        public static interface Factory<T extends SextupleRecipe> {
            public T get(String var1, int var2, int var3, ItemStack var4, NonNullList<Ingredient> var5);
        }
    }
}

