/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.registry;

import io.github.flemmli97.tenshilib.loader.LoaderRegistryAccess;
import io.github.flemmli97.tenshilib.loader.registry.LoaderRegister;
import io.github.flemmli97.tenshilib.loader.registry.RegistryEntrySupplier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;

public class RuneCraftoryAttributes {
    public static final LoaderRegister<Attribute> ATTRIBUTES = LoaderRegistryAccess.INSTANCE.of(Registries.ATTRIBUTE, "runecraftory");
    public static final Collection<RegistryEntrySupplier<Attribute, ?>> ENTITY_ATTRIBUTES = new ArrayList();
    public static final Collection<RegistryEntrySupplier<Attribute, ?>> PLAYER_ATTRIBUTES = new ArrayList();
    public static final Comparator<Holder<Attribute>> SORTED = (h1, h2) -> {
        if (h1.value() == Attributes.MAX_HEALTH.value() && h2.value() != Attributes.MAX_HEALTH.value()) {
            return -1;
        }
        if (h1.value() != Attributes.MAX_HEALTH.value() && h2.value() == Attributes.MAX_HEALTH.value()) {
            return 1;
        }
        Object patt0$temp = h1.value();
        if (patt0$temp instanceof OrderedAttribute) {
            OrderedAttribute o1 = (OrderedAttribute)((Object)((Object)patt0$temp));
            Object patt1$temp = h2.value();
            if (patt1$temp instanceof OrderedAttribute) {
                OrderedAttribute o2 = (OrderedAttribute)((Object)((Object)patt1$temp));
                return Integer.compare(o1.order, o2.order);
            }
            return 1;
        }
        if (!(h2.value() instanceof OrderedAttribute)) {
            return h1.getRegisteredName().compareTo(h2.getRegisteredName());
        }
        return -1;
    };
    private static int ID = 0;
    public static final RegistryEntrySupplier<Attribute, OrderedAttribute> MAX_RUNEPOINTS = RuneCraftoryAttributes.registerPlayerSyncable("max_runepoints", ID++, 0.0, -2.147483648E9, 2.147483647E9);
    public static final RegistryEntrySupplier<Attribute, OrderedAttribute> HEALTH_GAIN = RuneCraftoryAttributes.registerAdditional("health_gain", ID++, 0.0, -2.147483648E9, 2.147483647E9);
    public static final RegistryEntrySupplier<Attribute, OrderedAttribute> RUNE_POINTS_GAIN = RuneCraftoryAttributes.registerAdditional("rune_points_gain", ID++, 0.0, -2.147483648E9, 2.147483647E9);
    public static final RegistryEntrySupplier<Attribute, OrderedAttribute> DEFENCE = RuneCraftoryAttributes.registerSyncable("defence", ID++, 0.0, -9999.0, 9999.0);
    public static final RegistryEntrySupplier<Attribute, OrderedAttribute> MAGIC_ATTACK = RuneCraftoryAttributes.registerSyncable("magic_attack", ID++, 0.0, -9999.0, 9999.0);
    public static final RegistryEntrySupplier<Attribute, OrderedAttribute> MAGIC_DEFENCE = RuneCraftoryAttributes.registerSyncable("magic_defence", ID++, 0.0, -9999.0, 9999.0);
    public static final RegistryEntrySupplier<Attribute, OrderedAttribute> PARALYSIS = RuneCraftoryAttributes.register("paralysis", ID++, 0.0, -100.0, 100.0);
    public static final RegistryEntrySupplier<Attribute, OrderedAttribute> POISON = RuneCraftoryAttributes.register("poison", ID++, 0.0, -100.0, 100.0);
    public static final RegistryEntrySupplier<Attribute, OrderedAttribute> SEAL = RuneCraftoryAttributes.register("seal", ID++, 0.0, -100.0, 100.0);
    public static final RegistryEntrySupplier<Attribute, OrderedAttribute> SLEEP = RuneCraftoryAttributes.register("sleep", ID++, 0.0, -100.0, 100.0);
    public static final RegistryEntrySupplier<Attribute, OrderedAttribute> FATIGUE = RuneCraftoryAttributes.register("fatigue", ID++, 0.0, -100.0, 100.0);
    public static final RegistryEntrySupplier<Attribute, OrderedAttribute> COLD = RuneCraftoryAttributes.register("cold", ID++, 0.0, -100.0, 100.0);
    public static final RegistryEntrySupplier<Attribute, OrderedAttribute> DIZZY = RuneCraftoryAttributes.register("dizzy", ID++, 0.0, -100.0, 100.0);
    public static final RegistryEntrySupplier<Attribute, OrderedAttribute> CRITICAL = RuneCraftoryAttributes.register("critical", ID++, 0.0, -100.0, 100.0);
    public static final RegistryEntrySupplier<Attribute, OrderedAttribute> STUN = RuneCraftoryAttributes.register("stun", ID++, 0.0, -100.0, 100.0);
    public static final RegistryEntrySupplier<Attribute, OrderedAttribute> FAINT = RuneCraftoryAttributes.register("faint", ID++, 0.0, -100.0, 100.0);
    public static final RegistryEntrySupplier<Attribute, OrderedAttribute> DRAIN = RuneCraftoryAttributes.register("drain", ID++, 0.0, -100.0, 100.0);
    public static final RegistryEntrySupplier<Attribute, OrderedAttribute> WATER_RESISTANCE = RuneCraftoryAttributes.register("water_resistance", ID++, 0.0, -100.0, 200.0);
    public static final RegistryEntrySupplier<Attribute, OrderedAttribute> EARTH_RESISTANCE = RuneCraftoryAttributes.register("earth_resistance", ID++, 0.0, -100.0, 200.0);
    public static final RegistryEntrySupplier<Attribute, OrderedAttribute> WIND_RESISTANCE = RuneCraftoryAttributes.register("wind_resistance", ID++, 0.0, -100.0, 200.0);
    public static final RegistryEntrySupplier<Attribute, OrderedAttribute> FIRE_RESISTANCE = RuneCraftoryAttributes.register("fire_resistance", ID++, 0.0, -100.0, 200.0);
    public static final RegistryEntrySupplier<Attribute, OrderedAttribute> DARK_RESISTANCE = RuneCraftoryAttributes.register("dark_resistance", ID++, 0.0, -100.0, 200.0);
    public static final RegistryEntrySupplier<Attribute, OrderedAttribute> LIGHT_RESISTANCE = RuneCraftoryAttributes.register("light_resistance", ID++, 0.0, -100.0, 200.0);
    public static final RegistryEntrySupplier<Attribute, OrderedAttribute> LOVE_RESISTANCE = RuneCraftoryAttributes.register("love_resistance", ID++, 0.0, -100.0, 200.0);
    public static final RegistryEntrySupplier<Attribute, OrderedAttribute> PARALYSIS_RESISTANCE = RuneCraftoryAttributes.register("paralysis_resistance", ID++, 0.0, -100.0, 100.0);
    public static final RegistryEntrySupplier<Attribute, OrderedAttribute> POISON_RESISTANCE = RuneCraftoryAttributes.register("poison_resistance", ID++, 0.0, -100.0, 100.0);
    public static final RegistryEntrySupplier<Attribute, OrderedAttribute> SEAL_RESISTANCE = RuneCraftoryAttributes.register("seal_resistance", ID++, 0.0, -100.0, 100.0);
    public static final RegistryEntrySupplier<Attribute, OrderedAttribute> SLEEP_RESISTANCE = RuneCraftoryAttributes.register("sleep_resistance", ID++, 0.0, -100.0, 100.0);
    public static final RegistryEntrySupplier<Attribute, OrderedAttribute> FATIGUE_RESISTANCE = RuneCraftoryAttributes.register("fatigue_resistance", ID++, 0.0, -100.0, 100.0);
    public static final RegistryEntrySupplier<Attribute, OrderedAttribute> COLD_RESISTANCE = RuneCraftoryAttributes.register("cold_resistance", ID++, 0.0, -100.0, 100.0);
    public static final RegistryEntrySupplier<Attribute, OrderedAttribute> DIZZY_RESISTANCE = RuneCraftoryAttributes.register("dizzy_resistance", ID++, 0.0, -100.0, 100.0);
    public static final RegistryEntrySupplier<Attribute, OrderedAttribute> CRITICAL_RESISTANCE = RuneCraftoryAttributes.register("critical_resistance", ID++, 0.0, -100.0, 100.0);
    public static final RegistryEntrySupplier<Attribute, OrderedAttribute> STUN_RESISTANCE = RuneCraftoryAttributes.register("stun_resistance", ID++, 0.0, -100.0, 100.0);
    public static final RegistryEntrySupplier<Attribute, OrderedAttribute> FAINT_RESISTANCE = RuneCraftoryAttributes.register("faint_resistance", ID++, 0.0, -100.0, 100.0);
    public static final RegistryEntrySupplier<Attribute, OrderedAttribute> DRAIN_RESISTANCE = RuneCraftoryAttributes.register("drain_resistance", ID++, 0.0, -100.0, 100.0);
    public static final RegistryEntrySupplier<Attribute, OrderedAttribute> ATTACK_SPEED = RuneCraftoryAttributes.registerPlayerSyncable("attack_speed", ID++, 1.0, 0.0, 2.0);
    public static final RegistryEntrySupplier<Attribute, OrderedAttribute> ATTACK_RANGE = RuneCraftoryAttributes.registerPlayerSyncable("attack_range", ID++, 3.0, 0.0, 9999.0);
    public static final RegistryEntrySupplier<Attribute, OrderedAttribute> ATTACK_WIDTH = RuneCraftoryAttributes.registerPlayerSyncable("attack_width", ID++, 0.0, 0.0, 9999.0);
    public static final RegistryEntrySupplier<Attribute, OrderedAttribute> CHARGE_TIME = RuneCraftoryAttributes.registerPlayerSyncable("charge_time", ID++, 20.0, 0.0, 9999.0);

    private static RegistryEntrySupplier<Attribute, OrderedAttribute> register(String name, int id, double base, double min, double max) {
        RegistryEntrySupplier sup = ATTRIBUTES.register(name, res -> new OrderedAttribute("attribute." + String.valueOf(res), id, base, min, max));
        ENTITY_ATTRIBUTES.add(sup);
        return sup;
    }

    private static RegistryEntrySupplier<Attribute, OrderedAttribute> registerSyncable(String name, int id, double base, double min, double max) {
        RegistryEntrySupplier sup = ATTRIBUTES.register(name, res -> (OrderedAttribute)new OrderedAttribute("attribute." + String.valueOf(res), id, base, min, max).setSyncable(true));
        ENTITY_ATTRIBUTES.add(sup);
        return sup;
    }

    private static RegistryEntrySupplier<Attribute, OrderedAttribute> registerPlayerSyncable(String name, int id, double base, double min, double max) {
        RegistryEntrySupplier sup = ATTRIBUTES.register(name, res -> (OrderedAttribute)new OrderedAttribute("attribute." + String.valueOf(res), id, base, min, max).setSyncable(true));
        PLAYER_ATTRIBUTES.add(sup);
        return sup;
    }

    private static RegistryEntrySupplier<Attribute, OrderedAttribute> registerAdditional(String name, int id, double base, double min, double max) {
        return ATTRIBUTES.register(name, res -> new OrderedAttribute("attribute." + String.valueOf(res), id, base, min, max));
    }

    public static class OrderedAttribute
    extends RangedAttribute {
        private final int order;

        public OrderedAttribute(String name, int order, double baseValue, double minValue, double maxValue) {
            super(name, baseValue, minValue, maxValue);
            this.order = order;
        }
    }
}

