/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.spells;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.misc.FurnitureEntity;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.ProjectileUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class FurnitureThrowSpell
extends Spell {
    @Override
    public boolean use(ServerLevel level, LivingEntity entity, ItemStack stack, float rpUseMultiplier, int amount, int lvl) {
        if (!Spell.tryUseWithCost(entity, stack, this)) {
            return false;
        }
        int furnitureAmount = entity.getRandom().nextInt(7) + 4;
        for (int i = 0; i < furnitureAmount; ++i) {
            FurnitureEntity.Type randType = FurnitureEntity.Type.values()[entity.getRandom().nextInt(FurnitureEntity.Type.values().length)];
            FurnitureEntity furniture = new FurnitureEntity((Level)level, entity, randType);
            furniture.setDamageMultiplier(CombatUtils.getAbilityDamageBonus(lvl, this));
            furniture.setNoGravity(true);
            double xRand = entity.getX() + (entity.getRandom().nextDouble() - 0.5) * 13.0;
            double yRand = entity.getY() + entity.getRandom().nextDouble() * 2.0;
            double zRand = entity.getZ() + (entity.getRandom().nextDouble() - 0.5) * 13.0;
            furniture.setPos(xRand, yRand, zRand);
            Vec3 target = ProjectileUtils.getAimTarget(entity);
            if (target == null) {
                target = furniture.position().add(entity.getViewVector(1.0f).scale(5.0));
            }
            furniture.shootAtPosition(target.x(), target.y(), target.z(), 0.1f, 30.0f);
            level.addFreshEntity((Entity)furniture);
        }
        return true;
    }
}

