/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.spells;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.utils.HealingPredicateEntity;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.spells.HealT1Spell;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class HealT3Spell
extends Spell {
    @Override
    public boolean use(ServerLevel level, LivingEntity entity, ItemStack stack, float rpUseMultiplier, int amount, int lvl) {
        if (!Spell.tryUseWithCost(entity, stack, this)) {
            return false;
        }
        List entities = level.getEntitiesOfClass(LivingEntity.class, entity.getBoundingBox().inflate(1.5), e -> {
            if (e == entity) {
                return true;
            }
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (e instanceof OwnableEntity) {
                    OwnableEntity ownable = (OwnableEntity)e;
                    if (player.getUUID().equals(ownable.getOwnerUUID())) return true;
                }
                if (e instanceof AbstractVillager) return true;
                if (e instanceof Animal) return true;
                if (!Platform.INSTANCE.getPlayerData((Player)player).party.isPartyMember((Entity)e)) return false;
                return true;
            }
            if (!(entity instanceof HealingPredicateEntity)) return false;
            HealingPredicateEntity healer = (HealingPredicateEntity)entity;
            return healer.healeableEntities().test((LivingEntity)e);
        });
        float healAmount = (float)(CombatUtils.getAttributeValue((Entity)entity, (Holder<Attribute>)RuneCraftoryAttributes.MAGIC_ATTACK.asHolder()) * (double)CombatUtils.getAbilityDamageBonus(lvl, this));
        entity.heal(healAmount);
        HealT1Spell.spawnHealParticles(entity);
        entities.forEach(e -> {
            e.heal(healAmount);
            HealT1Spell.spawnHealParticles(e);
        });
        HealT3Spell.playSound(entity, (SoundEvent)RuneCraftorySounds.SPELL_GENERIC_HEAL.get(), 1.0f, (entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.2f + 1.0f);
        return true;
    }
}

