/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.spells;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.misc.MissileEntity;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.tenshilib.common.utils.HitResultUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class MissileSpell
extends Spell {
    private final int amount;

    public MissileSpell(int amount) {
        this.amount = amount;
    }

    @Override
    public boolean use(ServerLevel level, LivingEntity entity, ItemStack stack, float rpUseMultiplier, int amount, int lvl) {
        if (!Spell.tryUseWithCost(entity, stack, this)) {
            return false;
        }
        int left = this.amount / 2;
        Vec3 dir = entity.getViewVector(1.0f);
        Vec3 side = new Vec3(dir.x, 0.0, dir.z).yRot(90.0f).normalize();
        for (int i = 0; i < left; ++i) {
            EntityHitResult res;
            Mob mob;
            MissileEntity missile = new MissileEntity((Level)level, entity);
            missile.setDamageMultiplier(CombatUtils.getAbilityDamageBonus(lvl, this));
            missile.setPos(missile.getX() + side.x() + entity.getRandom().nextGaussian() * 0.1, missile.getY(), missile.getZ() + side.z() + entity.getRandom().nextGaussian() * 0.1);
            missile.shoot((Entity)entity, 0.0f, entity.getYRot(), 0.0f, 0.18f, 8.0f);
            if (entity instanceof Mob && (mob = (Mob)entity).getTarget() != null) {
                missile.setTarget((Entity)mob.getTarget());
            } else if (entity instanceof Player && (res = MissileSpell.calculateEntityFromLook(entity, 16.0f)) != null) {
                missile.setTarget(res.getEntity());
            }
            level.addFreshEntity((Entity)missile);
        }
        int right = this.amount / left;
        for (int i = 0; i < right; ++i) {
            EntityHitResult res;
            Mob mob;
            MissileEntity missile = new MissileEntity((Level)level, entity);
            missile.setDamageMultiplier(CombatUtils.getAbilityDamageBonus(lvl, this));
            missile.setPos(missile.getX() - side.x() + entity.getRandom().nextGaussian() * 0.1, missile.getY(), missile.getZ() - side.z() + entity.getRandom().nextGaussian() * 0.1);
            missile.shoot((Entity)entity, 0.0f, entity.getYRot(), 0.0f, 0.18f, 8.0f);
            if (entity instanceof Mob && (mob = (Mob)entity).getTarget() != null) {
                missile.setTarget((Entity)mob.getTarget());
            } else if (entity instanceof Player && (res = MissileSpell.calculateEntityFromLook(entity, 16.0f)) != null) {
                missile.setTarget(res.getEntity());
            }
            level.addFreshEntity((Entity)missile);
        }
        MissileSpell.playSound(entity, (SoundEvent)RuneCraftorySounds.SPELL_GENERIC_FIRE_BALL.get(), 1.0f, (entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.2f + 1.0f);
        return true;
    }

    public static EntityHitResult calculateEntityFromLook(LivingEntity entity, float reach) {
        Vec3 loc;
        double dist;
        Vec3 dir;
        Vec3 scaledDir;
        Vec3 pos = entity.getEyePosition(1.0f);
        EntityHitResult result = HitResultUtils.rayTraceEntities((Entity)entity, (Vec3)pos, (Vec3)pos.add(scaledDir = (dir = entity.getViewVector(1.0f)).scale((double)reach)), (AABB)entity.getBoundingBox().expandTowards(scaledDir).inflate(1.0), t -> EntitySelector.NO_SPECTATORS.test(t) && t.isPickable());
        if (result != null && (dist = pos.distanceToSqr(loc = result.getLocation())) <= (double)(reach * reach)) {
            return result;
        }
        return null;
    }
}

