/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.spells;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.misc.PoisonNeedleEntity;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.ProjectileUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class PoisonNeedleSpell
extends Spell {
    @Override
    public boolean use(ServerLevel level, LivingEntity entity, ItemStack stack, float rpUseMultiplier, int amount, int lvl) {
        if (!Spell.tryUseWithCost(entity, stack, this)) {
            return false;
        }
        PoisonNeedleEntity projectile = new PoisonNeedleEntity((Level)level, entity);
        projectile.setDamageMultiplier(CombatUtils.getAbilityDamageBonus(lvl, this));
        ProjectileUtils.shoot(entity, projectile, 1.2f, entity instanceof Player ? 0.5f : (float)(4 - level.getDifficulty().getId()));
        level.playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.ARROW_SHOOT, entity.getSoundSource(), 1.0f, 1.0f / (entity.getRandom().nextFloat() * 0.4f + 0.8f));
        level.addFreshEntity((Entity)projectile);
        return true;
    }
}

