/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.spells;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.misc.SpikeEntity;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.common.utils.HitResultUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class RootSpike
extends Spell {
    @Override
    public boolean use(ServerLevel level, LivingEntity entity, ItemStack stack, float rpUseMultiplier, int amount, int lvl) {
        Player player;
        HitResult result;
        if (!Spell.tryUseWithCost(entity, stack, this)) {
            return false;
        }
        SpikeEntity spike = new SpikeEntity((Level)level, entity, 0, 10, SpikeEntity.SpikeType.ROOT);
        spike.setDamageMultiplier(CombatUtils.getAbilityDamageBonus(lvl, this));
        Vec3 targetPos = null;
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            LivingEntity target = EntityUtils.ownedProjectileTarget((Entity)mob, 14);
            if (target != null) {
                targetPos = target.position();
            }
        } else if (entity instanceof Player && (result = HitResultUtils.entityRayTrace((Entity)(player = (Player)entity), (double)12.0, (ClipContext.Block)ClipContext.Block.COLLIDER, (ClipContext.Fluid)ClipContext.Fluid.NONE, (boolean)true, (boolean)false, e -> e instanceof LivingEntity)) != null) {
            targetPos = result.getLocation();
        }
        if (targetPos != null) {
            spike.setPos(targetPos);
        }
        level.addFreshEntity((Entity)spike);
        return true;
    }
}

