/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.spells;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.tenshilib.common.utils.HitResultUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ShulkerBullet;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class ShulkerBulletSpell
extends Spell {
    @Override
    public boolean use(ServerLevel level, LivingEntity entity, ItemStack stack, float rpUseMultiplier, int amount, int lvl) {
        EntityHitResult res;
        Mob mob;
        if (!Spell.tryUseWithCost(entity, stack, this)) {
            return false;
        }
        LivingEntity target = null;
        if (entity instanceof Mob && (mob = (Mob)entity).getTarget() != null) {
            target = mob.getTarget();
        } else if (entity instanceof Player && (res = ShulkerBulletSpell.calculateEntityFromLook(entity, 15.0f)) != null) {
            target = res.getEntity();
        }
        ShulkerBullet bullet = new ShulkerBullet((Level)level, entity, (Entity)target, entity.getDirection().getAxis());
        bullet.setPos(bullet.getX(), entity.getEyeY(), bullet.getZ());
        level.addFreshEntity((Entity)bullet);
        ShulkerBulletSpell.playSound(entity, SoundEvents.SHULKER_SHOOT, 1.0f, (entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.2f + 1.0f);
        return true;
    }

    public static EntityHitResult calculateEntityFromLook(LivingEntity entity, float reach) {
        Vec3 loc;
        double dist;
        Vec3 dir;
        Vec3 scaledDir;
        Vec3 pos = entity.getEyePosition(1.0f);
        EntityHitResult result = HitResultUtils.rayTraceEntities((Entity)entity, (Vec3)pos, (Vec3)pos.add(scaledDir = (dir = entity.getViewVector(1.0f)).scale((double)reach)), (AABB)entity.getBoundingBox().expandTowards(scaledDir).inflate(1.0), t -> EntitySelector.NO_SPECTATORS.test(t) && t.isPickable());
        if (result != null && (dist = pos.distanceToSqr(loc = result.getLocation())) <= (double)(reach * reach)) {
            return result;
        }
        return null;
    }
}

