/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.spells;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.utils.ProjectileUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.DragonFireball;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SimpleVanillaProjectileSpell
extends Spell {
    public static final ProjectileFactory WITHER_SKULL = WitherSkull::new;
    public static final ProjectileFactory GHAST_FIREBALL = (level, entity, direction) -> new LargeFireball((Level)level, entity, direction, 1);
    public static final ProjectileFactory DRAGON_FIREBALL = DragonFireball::new;
    public static final ProjectileFactory SNOWBALL = (level, entity, direction) -> {
        Snowball snowball = new Snowball((Level)level, entity);
        snowball.shoot(direction.x, direction.y, direction.z, 2.0f, 1.0f);
        Vec3 vec3 = entity.getDeltaMovement();
        snowball.setDeltaMovement(snowball.getDeltaMovement().add(vec3.x, entity.onGround() ? 0.0 : vec3.y, vec3.z));
        return snowball;
    };
    private final ProjectileFactory factory;
    private final SoundEvent sound;

    public SimpleVanillaProjectileSpell(ProjectileFactory factory, SoundEvent sound) {
        this.factory = factory;
        this.sound = sound;
    }

    @Override
    public boolean use(ServerLevel level, LivingEntity entity, ItemStack stack, float rpUseMultiplier, int amount, int lvl) {
        if (!Spell.tryUseWithCost(entity, stack, this)) {
            return false;
        }
        Vec3 target = ProjectileUtils.getAimTarget(entity);
        Vec3 dir = target != null ? target.subtract(entity.getEyePosition()) : entity.getViewVector(1.0f);
        Entity proj = this.factory.create(level, entity, dir);
        proj.setPos(entity.getX(), entity.getEyeY(), entity.getZ());
        level.addFreshEntity(proj);
        SimpleVanillaProjectileSpell.playSound(entity, this.sound, 1.0f, (entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.2f + 1.0f);
        return true;
    }

    public static interface ProjectileFactory {
        public Entity create(ServerLevel var1, LivingEntity var2, Vec3 var3);
    }
}

