/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.spells;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.misc.StatusBallEntity;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class SleepBallSpell
extends Spell {
    @Override
    public boolean use(ServerLevel level, LivingEntity entity, ItemStack stack, float rpUseMultiplier, int amount, int lvl) {
        if (!Spell.tryUseWithCost(entity, stack, this)) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            double angle = (double)i / 4.0 * Math.PI * 2.0 + Math.toRadians(entity.getYRot());
            double x = Math.cos(angle) * 1.3;
            double z = Math.sin(angle) * 1.3;
            StatusBallEntity pollen = new StatusBallEntity((Level)level, entity);
            pollen.setType(StatusBallEntity.Type.SLEEP);
            pollen.setDamageMultiplier(CombatUtils.getAbilityDamageBonus(lvl, this));
            pollen.setPos(entity.getX() + x, entity.getY() + 0.4, entity.getZ() + z);
            level.addFreshEntity((Entity)pollen);
        }
        SleepBallSpell.playSound(entity, (SoundEvent)RuneCraftorySounds.SPELL_GENERIC_POOF.get(), 1.0f, (entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.2f + 1.0f);
        return true;
    }
}

