/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.spells;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import java.util.Optional;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class TeleportSpell
extends Spell {
    @Override
    public boolean use(ServerLevel serverLevel, LivingEntity entity, ItemStack stack, float rpUseMultiplier, int amount, int level) {
        Vec3 home;
        if (entity instanceof Mob) {
            Optional mem;
            Mob mob = (Mob)entity;
            if (mob.hasRestriction() && mob.distanceToSqr(home = Vec3.atCenterOf((Vec3i)mob.getRestrictCenter())) > 100.0) {
                TeleportSpell.safeTeleportTo((Entity)mob, home.x(), home.y(), home.z());
                return true;
            }
            if (mob.getBrain().hasMemoryValue(MemoryModuleType.HOME) && (mem = mob.getBrain().getMemory(MemoryModuleType.HOME)).isPresent()) {
                ServerLevel homeLevel;
                Vec3 home2 = Vec3.atCenterOf((Vec3i)((GlobalPos)mem.get()).pos());
                ResourceKey levelKey = ((GlobalPos)mem.get()).dimension();
                if (mob.level().dimension() != levelKey && (homeLevel = mob.getServer().getLevel(levelKey)) != null) {
                    TeleportSpell.changeDimension((Entity)mob, homeLevel, home2.x(), home2.y(), home2.z());
                    return true;
                }
                TeleportSpell.safeTeleportTo((Entity)mob, home2.x(), home2.y(), home2.z());
                return true;
            }
        }
        if (entity instanceof ServerPlayer) {
            ServerLevel respawnLevel;
            ResourceKey levelKey;
            ServerPlayer player = (ServerPlayer)entity;
            if (player.getRespawnPosition() != null) {
                home = Vec3.atCenterOf((Vec3i)player.getRespawnPosition());
                levelKey = player.getRespawnDimension();
                if (player.level().dimension() == levelKey && player.distanceToSqr(home) <= 100.0) {
                    home = Vec3.atCenterOf((Vec3i)player.getServer().overworld().getSharedSpawnPos());
                    levelKey = player.getServer().overworld().dimension();
                }
            } else {
                home = Vec3.atCenterOf((Vec3i)player.getServer().overworld().getSharedSpawnPos());
                levelKey = player.getServer().overworld().dimension();
            }
            if (player.level().dimension() != levelKey && (respawnLevel = player.getServer().getLevel(levelKey)) != null) {
                TeleportSpell.changeDimension((Entity)player, respawnLevel, home.x(), home.y(), home.z());
                return true;
            }
            TeleportSpell.safeTeleportTo((Entity)player, home.x(), home.y(), home.z());
            return true;
        }
        return false;
    }

    public static void safeTeleportTo(Entity entity, double x, double y, double z) {
        AABB oldBox = entity.getBoundingBox();
        entity.teleportTo(x, y, z);
        entity.resetFallDistance();
        while (!entity.level().noCollision(entity) && entity.getY() < (double)entity.level().getMaxBuildHeight()) {
            entity.setPos(entity.getX(), entity.getY() + 1.0, entity.getZ());
        }
        entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)RuneCraftorySounds.GENERIC_TELEPORT.get(), SoundSource.MASTER, 1.0f, 1.0f);
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < 32; ++i) {
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.PORTAL, entity.getX(), entity.getY() + serverLevel.random.nextDouble() * 2.0, entity.getZ(), 0, serverLevel.random.nextGaussian(), 0.0, serverLevel.random.nextGaussian(), 1.0);
            }
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            TeleportSpell.teleportNearbyImportantEntities(player, player.serverLevel(), oldBox, x, y, z);
        }
    }

    public static void changeDimension(Entity entity, ServerLevel newLevel, double x, double y, double z) {
        float yaw = entity.getYRot();
        float pitch = entity.getXRot();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.stopRiding();
            AABB oldBB = player.getBoundingBox();
            ServerLevel oldLvl = player.serverLevel();
            player.teleportTo(newLevel, x, y, z, yaw, pitch);
            if (player.isSleeping()) {
                player.stopSleepInBed(true, true);
            }
            TeleportSpell.teleportNearbyImportantEntities(player, oldLvl, oldBB, x, y, z);
        } else {
            entity.unRide();
            Entity old = entity;
            entity = old.getType().create((Level)newLevel);
            if (entity != null) {
                entity.restoreFrom(old);
                entity.moveTo(x, y, z, yaw, pitch);
                old.setRemoved(Entity.RemovalReason.CHANGED_DIMENSION);
                newLevel.addDuringTeleport(entity);
            } else {
                return;
            }
        }
        while (!newLevel.noCollision(entity) && entity.getY() < (double)newLevel.getMaxBuildHeight()) {
            entity.setPos(entity.getX(), entity.getY() + 1.0, entity.getZ());
        }
        newLevel.playSound(null, entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)RuneCraftorySounds.GENERIC_TELEPORT.get(), SoundSource.MASTER, 1.0f, 1.0f);
        for (int i = 0; i < 32; ++i) {
            newLevel.sendParticles((ParticleOptions)ParticleTypes.PORTAL, entity.getX(), entity.getY() + newLevel.random.nextDouble() * 2.0, entity.getZ(), 0, newLevel.random.nextGaussian(), 0.0, newLevel.random.nextGaussian(), 1.0);
        }
    }

    private static void teleportNearbyImportantEntities(ServerPlayer player, ServerLevel oldLevel, AABB oldBox, double x, double y, double z) {
        boolean crossDim = player.serverLevel().dimension() != oldLevel.dimension();
        for (Entity e2 : oldLevel.getEntities(EntityTypeTest.forClass(Mob.class), oldBox.inflate(24.0), e -> {
            if (e instanceof BaseMonster) {
                BaseMonster monster = (BaseMonster)e;
                return player.getUUID().equals(monster.getOwnerUUID()) && monster.behaviourState() == BaseMonster.Behaviour.FOLLOW;
            }
            if (e instanceof NPCEntity) {
                NPCEntity npc = (NPCEntity)e;
                return player.getUUID().equals(npc.getEntityToFollowUUID());
            }
            return false;
        })) {
            if (crossDim) {
                TeleportSpell.changeDimension(e2, player.serverLevel(), x + oldLevel.random.nextDouble() * 2.0 - 1.0, y, z + oldLevel.random.nextDouble() * 2.0 - 1.0);
                continue;
            }
            TeleportSpell.safeTeleportTo(e2, x + oldLevel.random.nextDouble() * 2.0 - 1.0, y, z + oldLevel.random.nextDouble() * 2.0 - 1.0);
        }
    }
}

