/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.spells;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.misc.BulletEntity;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.ProjectileUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;

public class TripleFireBulletSpell
extends Spell {
    @Override
    public boolean use(ServerLevel level, LivingEntity entity, ItemStack stack, float rpUseMultiplier, int amount, int lvl) {
        if (!Spell.tryUseWithCost(entity, stack, this)) {
            return false;
        }
        BulletEntity projectile = new BulletEntity((Level)level, entity);
        Vec3 target = ProjectileUtils.getAimTarget(entity);
        Vec3 dir = target != null ? target.subtract(projectile.position()) : entity.getViewVector(1.0f);
        projectile.setElement(ItemElement.FIRE);
        projectile.setStraight();
        projectile.shoot(dir.x, dir.y, dir.z, 1.0f, 0.0f);
        projectile.setDamageMultiplier(CombatUtils.getAbilityDamageBonus(lvl, this));
        level.addFreshEntity((Entity)projectile);
        Vec3 up = entity.getUpVector(1.0f);
        for (float y = -15.0f; y <= 15.0f; y += 30.0f) {
            Vector3d newDir = new Vector3d(dir.x(), dir.y(), dir.z()).rotateAxis((double)(y * ((float)Math.PI / 180)), up.x(), up.y(), up.z());
            BulletEntity other = new BulletEntity((Level)level, entity);
            other.setStraight();
            other.setElement(ItemElement.FIRE);
            other.setDamageMultiplier(CombatUtils.getAbilityDamageBonus(lvl, this));
            other.shoot(newDir.x(), newDir.y(), newDir.z(), 1.0f, 0.0f);
            level.addFreshEntity((Entity)other);
        }
        TripleFireBulletSpell.playSound(entity, (SoundEvent)RuneCraftorySounds.SPELL_GENERIC_FIRE_BALL.get(), 1.0f, (entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.2f + 1.0f);
        return true;
    }
}

