/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.spells;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.api.registry.action.AttackAction;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class WeaponSpell
extends Spell {
    private final Supplier<? extends AttackAction> attackAction;
    private final TagKey<Item> weapon;

    public WeaponSpell(Supplier<? extends AttackAction> attackAction, TagKey<Item> weapon) {
        this.attackAction = attackAction;
        this.weapon = weapon;
    }

    @Override
    public boolean use(ServerLevel level, LivingEntity entity, ItemStack stack, float rpUseMultiplier, int amount, int lvl) {
        boolean hasWeapon;
        boolean bl = hasWeapon = entity.getMainHandItem().is(RunecraftoryTags.Items.WEAPONS) || entity.getMainHandItem().is(RunecraftoryTags.Items.TOOLS);
        if (!hasWeapon) {
            return false;
        }
        boolean correctWeapon = entity.getMainHandItem().is(this.weapon);
        rpUseMultiplier = correctWeapon ? rpUseMultiplier * 2.0f : rpUseMultiplier;
        return Spell.tryUseWithCost(entity, stack, this, rpUseMultiplier, true);
    }

    @Override
    public boolean canUse(ServerLevel level, LivingEntity entity, ItemStack stack) {
        if (!super.canUse(level, entity, stack)) {
            return false;
        }
        return entity.getMainHandItem().is(RunecraftoryTags.Items.WEAPONS) || entity.getMainHandItem().is(RunecraftoryTags.Items.TOOLS);
    }

    @Override
    public AttackAction useAction() {
        return this.attackAction.get();
    }

    @Override
    public boolean delayedUse() {
        return false;
    }
}

