/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.spells;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.misc.WindBladeEntity;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.tenshilib.common.utils.HitResultUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class WindBladeSpell
extends Spell {
    public final int amount;
    public final float damage;
    public final float angle;

    public WindBladeSpell(int amount, float damage, float angle) {
        this.amount = amount;
        this.damage = damage;
        this.angle = angle;
    }

    @Override
    public boolean use(ServerLevel level, LivingEntity entity, ItemStack stack, float rpUseMultiplier, int amount, int lvl) {
        if (!Spell.tryUseWithCost(entity, stack, this)) {
            return false;
        }
        float angle = -this.angle;
        float inc = this.angle * 2.0f / (float)(this.amount - 1);
        for (float y = angle; y <= this.angle; y += inc) {
            EntityHitResult res;
            Mob mob;
            WindBladeEntity wind = new WindBladeEntity((Level)level, entity);
            wind.setDamageMultiplier(CombatUtils.getAbilityDamageBonus(lvl, this));
            wind.shoot((Entity)entity, entity.getXRot(), entity.getYRot() - angle, 0.0f, 0.45f, 0.0f);
            if (entity instanceof Mob && (mob = (Mob)entity).getTarget() != null) {
                wind.setTarget((Entity)mob.getTarget());
            } else if (entity instanceof Player && (res = WindBladeSpell.calculateEntityFromLook(entity, 10.0f)) != null) {
                wind.setTarget(res.getEntity());
            }
            level.addFreshEntity((Entity)wind);
        }
        WindBladeSpell.playSound(entity, (SoundEvent)RuneCraftorySounds.SPELL_GENERIC_WIND.get(), 1.0f, (entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.2f + 1.0f);
        return true;
    }

    public static EntityHitResult calculateEntityFromLook(LivingEntity entity, float reach) {
        Vec3 loc;
        double dist;
        Vec3 dir;
        Vec3 scaledDir;
        Vec3 pos = entity.getEyePosition(1.0f);
        EntityHitResult result = HitResultUtils.rayTraceEntities((Entity)entity, (Vec3)pos, (Vec3)pos.add(scaledDir = (dir = entity.getViewVector(1.0f)).scale((double)reach)), (AABB)entity.getBoundingBox().expandTowards(scaledDir).inflate(1.0), t -> EntitySelector.NO_SPECTATORS.test(t) && t.isPickable());
        if (result != null && (dist = pos.distanceToSqr(loc = result.getLocation())) <= (double)(reach * reach)) {
            return result;
        }
        return null;
    }
}

