/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.utils;

import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.attachment.Skills;
import io.github.flemmli97.runecraftory.api.registry.ArmorEffect;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.entities.utils.ElementalAttackMob;
import io.github.flemmli97.runecraftory.common.entities.utils.TargetableOpponent;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemSpell;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemStaffBase;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.network.S2CAttackDebug;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryArmorEffects;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryDataComponentTypes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEffects;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.spells.BaseStaffSpell;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemComponentUtils;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.mixin.LivingEntityAccessor;
import io.github.flemmli97.runecraftory.mixin.MobEffectInstanceAccessor;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.common.utils.HitResultUtils;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class CombatUtils {
    private static final ResourceLocation TEMP_ATTRIBUTE_MOD = RuneCraftory.modRes("combat_temp_mod");
    private static final ResourceLocation TEMP_ATTRIBUTE_MOD_MULT = RuneCraftory.modRes("combat_temp_mod_multiply");

    public static double getAttributeValue(Entity entity, Holder<Attribute> att) {
        if (!(entity instanceof LivingEntity)) {
            return 0.0;
        }
        LivingEntity attacker = (LivingEntity)entity;
        double increase = 0.0;
        if (attacker.getAttribute(att) != null) {
            increase += attacker.getAttributeValue(att);
        }
        int inc = (int)increase;
        double restRound = (double)Math.round((increase - (double)inc) * 2.0) / 2.0;
        return (double)inc + restRound;
    }

    public static Holder<Attribute> opposing(Holder<Attribute> att) {
        if (att.is(RuneCraftoryAttributes.PARALYSIS.getID())) {
            return RuneCraftoryAttributes.PARALYSIS_RESISTANCE.asHolder();
        }
        if (att.is(RuneCraftoryAttributes.POISON.getID())) {
            return RuneCraftoryAttributes.POISON_RESISTANCE.asHolder();
        }
        if (att.is(RuneCraftoryAttributes.SEAL.getID())) {
            return RuneCraftoryAttributes.SEAL_RESISTANCE.asHolder();
        }
        if (att.is(RuneCraftoryAttributes.SLEEP.getID())) {
            return RuneCraftoryAttributes.SLEEP_RESISTANCE.asHolder();
        }
        if (att.is(RuneCraftoryAttributes.FATIGUE.getID())) {
            return RuneCraftoryAttributes.FATIGUE_RESISTANCE.asHolder();
        }
        if (att.is(RuneCraftoryAttributes.COLD.getID())) {
            return RuneCraftoryAttributes.COLD_RESISTANCE.asHolder();
        }
        if (att.is(RuneCraftoryAttributes.DIZZY.getID())) {
            return RuneCraftoryAttributes.DIZZY_RESISTANCE.asHolder();
        }
        if (att.is(RuneCraftoryAttributes.CRITICAL.getID())) {
            return RuneCraftoryAttributes.CRITICAL_RESISTANCE.asHolder();
        }
        if (att.is(RuneCraftoryAttributes.STUN.getID())) {
            return RuneCraftoryAttributes.STUN_RESISTANCE.asHolder();
        }
        if (att.is(RuneCraftoryAttributes.FAINT.getID())) {
            return RuneCraftoryAttributes.FAINT_RESISTANCE.asHolder();
        }
        if (att.is(RuneCraftoryAttributes.DRAIN.getID())) {
            return RuneCraftoryAttributes.DRAIN_RESISTANCE.asHolder();
        }
        return null;
    }

    public static Skills matchingSkill(Holder<Attribute> att) {
        if (att.is(RuneCraftoryAttributes.PARALYSIS.getID())) {
            return Skills.RES_PARA;
        }
        if (att.is(RuneCraftoryAttributes.POISON.getID())) {
            return Skills.RES_POISON;
        }
        if (att.is(RuneCraftoryAttributes.SEAL.getID())) {
            return Skills.RES_SEAL;
        }
        if (att.is(RuneCraftoryAttributes.SLEEP.getID())) {
            return Skills.RES_SLEEP;
        }
        if (att.is(RuneCraftoryAttributes.FATIGUE.getID())) {
            return Skills.RES_FATIGUE;
        }
        if (att.is(RuneCraftoryAttributes.COLD.getID())) {
            return Skills.RES_COLD;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static double statusEffectValue(LivingEntity entity, Holder<Attribute> att, Entity target) {
        value = CombatUtils.getAttributeValue((Entity)entity, att) * 0.01;
        opposing = CombatUtils.opposing(att);
        if (!(target instanceof LivingEntity)) ** GOTO lbl-1000
        livingTarget = (LivingEntity)target;
        if (opposing != null) {
            v0 = CombatUtils.getAttributeValue((Entity)livingTarget, opposing);
        } else lbl-1000:
        // 2 sources

        {
            v0 = res = 0.0;
        }
        if (target instanceof Player) {
            player = (Player)target;
            matchingSkill = CombatUtils.matchingSkill(att);
            if (matchingSkill != null) {
                res += (double)Platform.INSTANCE.getPlayerData(player).getSkillLevel(matchingSkill).getLevel() * 0.005;
            }
        }
        return value * (1.0 - (res *= 0.01));
    }

    public static float reduceDamageFromStats(LivingEntity entity, DamageSource source, float amount) {
        boolean ignoreDefence;
        if (ArmorEffect.hasArmorEffect(entity, (Holder<ArmorEffect>)RuneCraftoryArmorEffects.SHIELD_RING.asHolder()) && (double)entity.getRandom().nextFloat() < 0.1) {
            return 1.0f;
        }
        float reduce = 0.0f;
        switch (GeneralConfig.defenceSystem) {
            default: {
                throw new MatchException(null, null);
            }
            case NO_DEFENCE: {
                boolean bl = true;
                break;
            }
            case VANILLA_IGNORE: {
                boolean bl;
                if (!(source instanceof DynamicDamage)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case IGNORE_VANILLA_MOBS: {
                boolean bl;
                if (!(source instanceof DynamicDamage) && source.getEntity() instanceof Mob) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case IGNORE_VANILLA_PLAYER_ATT: {
                boolean bl;
                if (!(source instanceof DynamicDamage) && source.getEntity() instanceof Player) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case IGNORE_VANILLA_PLAYER_HURT: {
                boolean bl;
                if (!(source instanceof DynamicDamage) && entity instanceof Player) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case IGNORE_VANILLA_PLAYER: {
                boolean bl = ignoreDefence = !(source instanceof DynamicDamage) && (entity instanceof Player || source.getEntity() instanceof Player);
            }
        }
        if (!ignoreDefence) {
            if (source.is(RunecraftoryTags.DamageTypes.IS_MAGIC)) {
                if (!source.is(RunecraftoryTags.DamageTypes.BYPASS_MAGIC)) {
                    reduce = (float)CombatUtils.getAttributeValue((Entity)entity, (Holder<Attribute>)RuneCraftoryAttributes.MAGIC_DEFENCE.asHolder());
                }
            } else if (!source.is(DamageTypeTags.BYPASSES_ARMOR)) {
                reduce = (float)CombatUtils.getAttributeValue((Entity)entity, (Holder<Attribute>)RuneCraftoryAttributes.DEFENCE.asHolder());
            }
        }
        float dmg = amount - reduce;
        if ((double)reduce > (double)amount * 0.8) {
            dmg = (float)Math.max(0.05 * (double)amount, (double)amount * 0.2 * Math.pow(0.997, (double)reduce - (double)amount * 0.8));
        }
        if (source instanceof DynamicDamage) {
            DynamicDamage custom = (DynamicDamage)source;
            if (GeneralConfig.randomDamage && !custom.fixedDamage()) {
                dmg = (float)((double)dmg + entity.level().random.nextGaussian() * (double)dmg / 10.0);
            }
        }
        return CombatUtils.elementalReduction(entity, source, dmg);
    }

    public static float elementalReduction(LivingEntity entity, DamageSource source, float amount) {
        if (source instanceof DynamicDamage && ((DynamicDamage)source).getElement() != ItemElement.NONE) {
            ItemElement element = ((DynamicDamage)source).getElement();
            double percent = 0.0;
            switch (element) {
                case DARK: {
                    percent = CombatUtils.getAttributeValue((Entity)entity, (Holder<Attribute>)RuneCraftoryAttributes.DARK_RESISTANCE.asHolder());
                    break;
                }
                case EARTH: {
                    percent = CombatUtils.getAttributeValue((Entity)entity, (Holder<Attribute>)RuneCraftoryAttributes.EARTH_RESISTANCE.asHolder());
                    break;
                }
                case FIRE: {
                    percent = CombatUtils.getAttributeValue((Entity)entity, (Holder<Attribute>)RuneCraftoryAttributes.FIRE_RESISTANCE.asHolder());
                    break;
                }
                case LIGHT: {
                    percent = CombatUtils.getAttributeValue((Entity)entity, (Holder<Attribute>)RuneCraftoryAttributes.LIGHT_RESISTANCE.asHolder());
                    break;
                }
                case LOVE: {
                    percent = CombatUtils.getAttributeValue((Entity)entity, (Holder<Attribute>)RuneCraftoryAttributes.LOVE_RESISTANCE.asHolder());
                    break;
                }
                case WATER: {
                    percent = CombatUtils.getAttributeValue((Entity)entity, (Holder<Attribute>)RuneCraftoryAttributes.WATER_RESISTANCE.asHolder());
                    break;
                }
                case WIND: {
                    percent = CombatUtils.getAttributeValue((Entity)entity, (Holder<Attribute>)RuneCraftoryAttributes.WIND_RESISTANCE.asHolder());
                    break;
                }
            }
            amount = percent < 0.0 ? (float)((double)amount * (1.0 + Math.abs(percent) / 100.0)) : (percent > 100.0 ? (float)((double)amount * -((percent - 100.0) / 100.0)) : (float)((double)amount * (1.0 - percent / 100.0)));
        }
        return amount;
    }

    public static void knockBackEntity(LivingEntity attacker, LivingEntity entity, float strength) {
        Vec3 distVec = entity.position().subtract(attacker.position()).normalize();
        CombatUtils.knockbackEntityIgnoreResistance(entity, strength, -distVec.x, -distVec.z);
    }

    public static void knockbackEntityIgnoreResistance(LivingEntity entity, double strength, double x, double z) {
        if (!entity.getType().is(RunecraftoryTags.EntityTypes.BOSSES)) {
            CombatUtils.applyTempAttribute(entity, (Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE, -entity.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
        }
        entity.knockback(strength, x, z);
        if (!entity.getType().is(RunecraftoryTags.EntityTypes.BOSSES)) {
            CombatUtils.removeTempAttribute(entity, (Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE);
        }
    }

    public static void knockBack(LivingEntity entity, DynamicDamage source) {
        if (source.getKnockBackType() == DynamicDamage.KnockBackType.NONE) {
            return;
        }
        Entity attacker = source.getEntity();
        float strength = source.knockAmount();
        if ((strength = (float)((double)strength * (1.0 - entity.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE)))) == 0.0f) {
            return;
        }
        double xRatio = 0.0;
        double zRatio = 0.0;
        double yRatio = strength;
        if (attacker != null) {
            switch (source.getKnockBackType()) {
                case BACK: {
                    Vec3 distVec = entity.position().subtract(attacker.position()).normalize();
                    xRatio = distVec.x;
                    zRatio = distVec.z;
                    break;
                }
                case VANILLA: {
                    xRatio = Mth.sin((float)(attacker.getYRot() * ((float)Math.PI / 180)));
                    zRatio = -Mth.cos((float)(attacker.getYRot() * ((float)Math.PI / 180)));
                    break;
                }
            }
        }
        if (source.getKnockBackType() == DynamicDamage.KnockBackType.VANILLA) {
            entity.knockback((double)strength, xRatio, zRatio);
        } else {
            Vec3 mot = entity.getDeltaMovement();
            double y = mot.y;
            entity.hasImpulse = true;
            if (xRatio != 0.0 || zRatio != 0.0) {
                float f = (float)Math.sqrt(xRatio * xRatio + zRatio * zRatio);
                mot = mot.scale(0.5).add(xRatio / (double)f * (double)strength, 0.0, zRatio / (double)f * (double)strength);
            }
            if (source.getKnockBackType() != DynamicDamage.KnockBackType.UP) {
                if (entity.onGround()) {
                    y /= 2.0;
                    if ((y += (double)strength) > (double)0.4f) {
                        y = 0.4f;
                    }
                }
            } else if (yRatio != 0.0) {
                y = yRatio;
            }
            entity.setDeltaMovement(new Vec3(mot.x, y, mot.z));
        }
    }

    public static boolean attackWithItem(Player player, Entity target, boolean resetCooldown, boolean levelSkill) {
        return CombatUtils.attackWithItem(player, target, player.getMainHandItem(), 1.0f, resetCooldown, levelSkill);
    }

    public static boolean attackWithItem(Player player, Entity target, ItemStack stack, float damageModifier, boolean resetCooldown, boolean levelSkill) {
        float damage;
        Level level = player.level();
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (target.isAttackable() && !target.skipAttackInteraction((Entity)player) && player.getCooldowns().getCooldownPercent(stack.getItem(), 0.0f) <= 0.0f && (damage = (float)(CombatUtils.getAttributeValue((Entity)player, (Holder<Attribute>)Attributes.ATTACK_DAMAGE) * (double)damageModifier)) > 0.0f) {
            Projectile projectile;
            if (target.getType().is(EntityTypeTags.REDIRECTABLE_PROJECTILE) && target instanceof Projectile && (projectile = (Projectile)target).deflect(ProjectileDeflection.AIM_DEFLECT, (Entity)player, (Entity)player, true)) {
                player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_NODAMAGE, player.getSoundSource());
                return true;
            }
            if (resetCooldown) {
                player.getCooldowns().addCooldown(stack.getItem(), Mth.ceil((double)(20.0 * EntityUtils.attackSpeedModifier((LivingEntity)player))));
            }
            boolean faint = player.level().random.nextDouble() < CombatUtils.statusEffectValue((LivingEntity)player, (Holder<Attribute>)RuneCraftoryAttributes.FAINT.asHolder(), target);
            boolean critical = player.level().random.nextDouble() < CombatUtils.statusEffectValue((LivingEntity)player, (Holder<Attribute>)RuneCraftoryAttributes.CRITICAL.asHolder(), target);
            DynamicDamage.DamageCategory damageCategory = DynamicDamage.DamageCategory.NORMAL;
            if (faint) {
                damageCategory = DynamicDamage.DamageCategory.FAINT;
            } else if (critical) {
                damageCategory = DynamicDamage.DamageCategory.IGNOREDEF;
            }
            if (stack.has((DataComponentType)RuneCraftoryDataComponentTypes.SCRAP_METAL_PLUS.get())) {
                damageCategory = DynamicDamage.DamageCategory.FIXED;
                damage = 1.0f;
            }
            DynamicDamage.Builder source = new DynamicDamage.Builder((Entity)player).element(ItemComponentUtils.getElement(stack)).damageType(damageCategory).hurtResistant(0);
            DynamicDamage tempBuild = source.get((HolderLookup.Provider)player.registryAccess());
            double enchantBonus = EnchantmentHelper.modifyDamage((ServerLevel)serverLevel, (ItemStack)stack, (Entity)player, (DamageSource)tempBuild, (float)damage) - damage;
            damage = (float)((double)damage + enchantBonus);
            float knockback = ((LivingEntityAccessor)player).getEntityKnockback(target, tempBuild) + (player.isSprinting() ? 1.0f : 0.0f);
            source.knockAmount(knockback);
            Vec3 targetMot = target.getDeltaMovement();
            if (CombatUtils.damage((Entity)player, target, source, damage, stack, false, false)) {
                ServerPlayer serverPlayer;
                if (levelSkill && player instanceof ServerPlayer) {
                    serverPlayer = (ServerPlayer)player;
                    CombatUtils.hitEntityWithItemPlayer(serverPlayer, stack);
                }
                if (knockback > 0.0f) {
                    player.setDeltaMovement(player.getDeltaMovement().multiply(0.6, 1.0, 0.6));
                    player.setSprinting(false);
                }
                if (target instanceof ServerPlayer) {
                    serverPlayer = (ServerPlayer)target;
                    if (target.hurtMarked) {
                        serverPlayer.connection.send((Packet)new ClientboundSetEntityMotionPacket(target));
                        target.hurtMarked = false;
                        target.setDeltaMovement(targetMot);
                    }
                }
                if (critical) {
                    player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_CRIT, player.getSoundSource(), 1.0f, 1.0f);
                    player.crit(target);
                    player.magicCrit(target);
                } else {
                    player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_SWEEP, player.getSoundSource(), 1.0f, 1.0f);
                }
            } else {
                player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_NODAMAGE, player.getSoundSource(), 1.0f, 1.0f);
            }
            return true;
        }
        return false;
    }

    public static boolean mobAttack(LivingEntity attacker, Entity target) {
        ItemStack stack = attacker.getMainHandItem();
        DynamicDamage.Builder source = new DynamicDamage.Builder((Entity)attacker).hurtResistant(5).element(ItemComponentUtils.getElement(stack));
        return CombatUtils.mobAttack(attacker, target, source);
    }

    public static boolean mobAttack(LivingEntity attacker, Entity target, DynamicDamage.Builder source) {
        ItemStack stack = attacker.getMainHandItem();
        double damage = CombatUtils.getAttributeValue((Entity)attacker, (Holder<Attribute>)Attributes.ATTACK_DAMAGE);
        Level level = attacker.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ((BaseStaffSpell)RuneCraftorySpells.STAFF_CAST.get()).use(serverLevel, attacker, stack);
        }
        if (stack.has((DataComponentType)RuneCraftoryDataComponentTypes.SCRAP_METAL_PLUS.get())) {
            source.damageType(DynamicDamage.DamageCategory.FIXED);
            damage = 1.0;
        }
        return CombatUtils.mobAttack(attacker, target, source, damage);
    }

    public static boolean mobAttack(LivingEntity attacker, Entity target, DynamicDamage.Builder source, double damage) {
        return CombatUtils.mobAttack(attacker, target, source, damage, null);
    }

    public static boolean mobAttack(LivingEntity attacker, Entity target, DynamicDamage.Builder source, double damage, @Nullable ItemStack stack) {
        if (target.level().getDifficulty() == Difficulty.PEACEFUL && target instanceof Player) {
            return false;
        }
        if (damage > 0.0) {
            ElementalAttackMob mob;
            ItemElement element;
            if (attacker instanceof ElementalAttackMob && (element = (mob = (ElementalAttackMob)attacker).getAttackElement()) != null) {
                source.element(element);
            }
            return CombatUtils.damageWithFaintAndCrit((Entity)attacker, target, source, damage, stack);
        }
        return false;
    }

    public static boolean damageWithFaintAndCrit(@Nullable Entity attacker, Entity target, DynamicDamage.Builder builder, double damage, @Nullable ItemStack stack) {
        return CombatUtils.damage(attacker, target, builder, damage, stack, true, true);
    }

    public static boolean damage(@Nullable Entity attacker, Entity target, DynamicDamage.Builder builder, double damage, @Nullable ItemStack stack, boolean allowCrit, boolean allowFaint) {
        LivingEntity livingAttacker;
        if (attacker instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)attacker;
            builder.getAttributesChanges().forEach((att, val) -> CombatUtils.applyTempAttribute(living, (Holder<Attribute>)att, val));
            if (allowFaint && living.level().random.nextDouble() < CombatUtils.statusEffectValue(living, (Holder<Attribute>)RuneCraftoryAttributes.FAINT.asHolder(), target)) {
                builder.damageType(DynamicDamage.DamageCategory.FAINT);
            } else if (allowCrit && living.level().random.nextDouble() < CombatUtils.statusEffectValue(living, (Holder<Attribute>)RuneCraftoryAttributes.CRITICAL.asHolder(), target)) {
                switch (builder.getDamageType()) {
                    case MAGIC: {
                        builder.damageType(DynamicDamage.DamageCategory.IGNOREMAGICDEF);
                        break;
                    }
                    case NORMAL: {
                        builder.damageType(DynamicDamage.DamageCategory.IGNOREDEF);
                    }
                }
            }
            if (builder.calculateKnockback()) {
                float knockback = ((LivingEntityAccessor)living).getEntityKnockback(target, builder.get((HolderLookup.Provider)living.registryAccess())) + (living.isSprinting() ? 1.0f : 0.0f);
                builder.knockAmount(knockback);
            }
        }
        DynamicDamage source = builder.get((HolderLookup.Provider)target.registryAccess());
        float dmg = (float)damage;
        if (source.criticalDamage()) {
            dmg = Float.MAX_VALUE;
        } else if (!source.fixedDamage()) {
            dmg = CombatUtils.modifyDmgElement(source.getElement(), target, dmg);
        }
        boolean success = source.hurtEntity(target, dmg);
        if (success) {
            CombatUtils.spawnElementalParticle(target, source.getElement());
            if (attacker instanceof LivingEntity) {
                livingAttacker = (LivingEntity)attacker;
                livingAttacker.setLastHurtMob(target);
            }
            if (target instanceof LivingEntity) {
                LivingEntity livingAttacker2;
                Level level;
                boolean handleStack;
                LivingEntity livingTarget = (LivingEntity)target;
                CombatUtils.knockBack(livingTarget, source);
                boolean bl = handleStack = attacker instanceof Player && stack != null;
                if (handleStack) {
                    handleStack = stack.hurtEnemy(livingTarget, (Player)attacker);
                }
                if (attacker instanceof LivingEntity && (level = (livingAttacker2 = (LivingEntity)attacker).level()) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    CombatUtils.applyStatusEffects(livingAttacker2, livingTarget);
                    EnchantmentHelper.doPostAttackEffects((ServerLevel)serverLevel, (Entity)target, (DamageSource)source);
                }
                if (handleStack && !stack.isEmpty()) {
                    stack.postHurtEnemy(livingTarget, (Player)attacker);
                }
                if (stack != null && attacker instanceof Player) {
                    Player player = (Player)attacker;
                    ItemStack beforeHitCopy = stack.copy();
                    if (stack.isEmpty()) {
                        Platform.INSTANCE.destroyItem(player, beforeHitCopy, InteractionHand.MAIN_HAND);
                        player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
                    }
                }
            }
            CombatUtils.elementalEffects(attacker, source.getElement(), target);
        }
        if (attacker instanceof LivingEntity) {
            livingAttacker = (LivingEntity)attacker;
            source.getAttributesChange().forEach((att, val) -> CombatUtils.removeTempAttribute(livingAttacker, (Holder<Attribute>)att));
        }
        return success;
    }

    public static float modifyDmgElement(ItemElement element, Entity target, float dmg) {
        if (!target.getType().is(RunecraftoryTags.EntityTypes.ELEMENTAL_DAMAGE_UNAFFECTED) && target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            switch (element) {
                case WATER: {
                    if (!living.fireImmune() && !living.isSensitiveToWater()) break;
                    dmg *= 1.2f;
                    break;
                }
                case FIRE: {
                    if (living.fireImmune()) {
                        dmg *= 0.8f;
                    }
                    if (!target.getType().is(EntityTypeTags.AQUATIC)) break;
                    dmg *= 1.2f;
                    break;
                }
                case LIGHT: {
                    if (!target.getType().is(EntityTypeTags.UNDEAD)) break;
                    dmg *= 1.2f;
                    break;
                }
                case LOVE: {
                    if (!target.getType().is(EntityTypeTags.ILLAGER)) break;
                    dmg *= 1.2f;
                }
            }
        }
        return dmg;
    }

    public static void elementalEffects(Entity attacker, ItemElement element, Entity target) {
        if (!target.getType().is(RunecraftoryTags.EntityTypes.ELEMENTAL_SECONDARY_UNAFFECTED) && target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            switch (element) {
                case FIRE: {
                    target.igniteForSeconds(4.0f);
                    break;
                }
                case WATER: {
                    living.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 200));
                    break;
                }
                case WIND: {
                    if (attacker == null) break;
                    living.knockback(1.5, (double)Mth.sin((float)(attacker.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(attacker.getYRot() * ((float)Math.PI / 180)))));
                    break;
                }
                case EARTH: {
                    living.addEffect(new MobEffectInstance(RuneCraftoryEffects.EARTH_ELEMENT_DEBUFF.asHolder(), 200));
                    break;
                }
                case DARK: {
                    living.addEffect(new MobEffectInstance(MobEffects.WITHER, 200));
                    break;
                }
                case LIGHT: {
                    List<MobEffectInstance> effects;
                    if (!((double)target.getRandom().nextFloat() < 0.5) || (effects = living.getActiveEffects().stream().filter(eff -> ((MobEffect)eff.getEffect().value()).isBeneficial()).toList()).isEmpty()) break;
                    MobEffectInstance inst = effects.get(attacker.getRandom().nextInt(effects.size()));
                    if (inst.getAmplifier() == 0) {
                        living.removeEffect(inst.getEffect());
                        break;
                    }
                    ((MobEffectInstanceAccessor)inst).setAmplifier(inst.getAmplifier() - 1);
                    break;
                }
                case LOVE: {
                    living.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 200, 1));
                }
            }
        }
    }

    public static void applyStatusEffects(LivingEntity attackingEntity, LivingEntity target) {
        ServerPlayer player;
        boolean poisonChance = attackingEntity.level().random.nextDouble() < CombatUtils.statusEffectValue(attackingEntity, (Holder<Attribute>)RuneCraftoryAttributes.POISON.asHolder(), (Entity)target);
        boolean sleepChance = attackingEntity.level().random.nextDouble() < CombatUtils.statusEffectValue(attackingEntity, (Holder<Attribute>)RuneCraftoryAttributes.SLEEP.asHolder(), (Entity)target);
        boolean fatigueChance = attackingEntity.level().random.nextDouble() < CombatUtils.statusEffectValue(attackingEntity, (Holder<Attribute>)RuneCraftoryAttributes.FATIGUE.asHolder(), (Entity)target);
        boolean coldChance = attackingEntity.level().random.nextDouble() < CombatUtils.statusEffectValue(attackingEntity, (Holder<Attribute>)RuneCraftoryAttributes.COLD.asHolder(), (Entity)target);
        boolean paraChance = attackingEntity.level().random.nextDouble() < CombatUtils.statusEffectValue(attackingEntity, (Holder<Attribute>)RuneCraftoryAttributes.PARALYSIS.asHolder(), (Entity)target);
        boolean sealChance = attackingEntity.level().random.nextDouble() < CombatUtils.statusEffectValue(attackingEntity, (Holder<Attribute>)RuneCraftoryAttributes.SEAL.asHolder(), (Entity)target);
        boolean dizzyChance = attackingEntity.level().random.nextDouble() < CombatUtils.statusEffectValue(attackingEntity, (Holder<Attribute>)RuneCraftoryAttributes.DIZZY.asHolder(), (Entity)target);
        double stunAmount = CombatUtils.statusEffectValue(attackingEntity, (Holder<Attribute>)RuneCraftoryAttributes.STUN.asHolder(), (Entity)target);
        if (poisonChance) {
            EntityUtils.applyPermanentEffect(target, (Holder<MobEffect>)RuneCraftoryEffects.POISON.asHolder(), 0);
            if (attackingEntity instanceof ServerPlayer) {
                player = (ServerPlayer)attackingEntity;
                LevelCalc.levelSkill(Platform.INSTANCE.getPlayerData((Player)player), Skills.RES_POISON, 5.0f);
            }
            if (target instanceof ServerPlayer) {
                player = (ServerPlayer)target;
                LevelCalc.levelSkill(Platform.INSTANCE.getPlayerData((Player)player), Skills.RES_POISON, 15.0f);
            }
        }
        if (fatigueChance) {
            EntityUtils.applyPermanentEffect(target, (Holder<MobEffect>)RuneCraftoryEffects.FATIGUE.asHolder(), 0);
            if (attackingEntity instanceof ServerPlayer) {
                player = (ServerPlayer)attackingEntity;
                LevelCalc.levelSkill(Platform.INSTANCE.getPlayerData((Player)player), Skills.RES_FATIGUE, 5.0f);
            }
            if (target instanceof ServerPlayer) {
                player = (ServerPlayer)target;
                LevelCalc.levelSkill(Platform.INSTANCE.getPlayerData((Player)player), Skills.RES_FATIGUE, 15.0f);
            }
        }
        if (coldChance) {
            EntityUtils.applyPermanentEffect(target, (Holder<MobEffect>)RuneCraftoryEffects.COLD.asHolder(), 0);
            if (attackingEntity instanceof ServerPlayer) {
                player = (ServerPlayer)attackingEntity;
                LevelCalc.levelSkill(Platform.INSTANCE.getPlayerData((Player)player), Skills.RES_COLD, 5.0f);
            }
            if (target instanceof ServerPlayer) {
                player = (ServerPlayer)target;
                LevelCalc.levelSkill(Platform.INSTANCE.getPlayerData((Player)player), Skills.RES_COLD, 15.0f);
            }
        }
        if (paraChance) {
            EntityUtils.applyPermanentEffect(target, (Holder<MobEffect>)RuneCraftoryEffects.PARALYSIS.asHolder(), 0);
            if (attackingEntity instanceof ServerPlayer) {
                player = (ServerPlayer)attackingEntity;
                LevelCalc.levelSkill(Platform.INSTANCE.getPlayerData((Player)player), Skills.RES_PARA, 5.0f);
            }
            if (target instanceof ServerPlayer) {
                player = (ServerPlayer)target;
                LevelCalc.levelSkill(Platform.INSTANCE.getPlayerData((Player)player), Skills.RES_PARA, 15.0f);
            }
        }
        if (sealChance) {
            EntityUtils.applyPermanentEffect(target, (Holder<MobEffect>)RuneCraftoryEffects.SEAL.asHolder(), 0);
            if (attackingEntity instanceof ServerPlayer) {
                player = (ServerPlayer)attackingEntity;
                LevelCalc.levelSkill(Platform.INSTANCE.getPlayerData((Player)player), Skills.RES_SEAL, 5.0f);
            }
            if (target instanceof ServerPlayer) {
                player = (ServerPlayer)target;
                LevelCalc.levelSkill(Platform.INSTANCE.getPlayerData((Player)player), Skills.RES_SEAL, 15.0f);
            }
        }
        if (dizzyChance) {
            target.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 80, 1, true, false));
        }
        if (stunAmount > 0.1 && attackingEntity.level().random.nextDouble() < stunAmount) {
            target.addEffect(new MobEffectInstance(RuneCraftoryEffects.STUNNED.asHolder(), Mth.floor((double)(Math.min(1.0, stunAmount) * 60.0)), 0, true, false));
        }
        if (sleepChance) {
            target.addEffect(new MobEffectInstance(RuneCraftoryEffects.SLEEP.asHolder(), 80, 0, true, false));
            if (attackingEntity instanceof ServerPlayer) {
                player = (ServerPlayer)attackingEntity;
                LevelCalc.levelSkill(Platform.INSTANCE.getPlayerData((Player)player), Skills.RES_SLEEP, 5.0f);
            }
            if (target instanceof ServerPlayer) {
                player = (ServerPlayer)target;
                LevelCalc.levelSkill(Platform.INSTANCE.getPlayerData((Player)player), Skills.RES_SLEEP, 15.0f);
            }
        }
    }

    public static void spawnElementalParticle(Entity target, ItemElement element) {
        Level level = target.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int color = 0xFFFFFF;
            switch (element) {
                case DARK: {
                    color = 1774399;
                    break;
                }
                case EARTH: {
                    color = 9201679;
                    break;
                }
                case FIRE: {
                    color = 12846855;
                    break;
                }
                case LIGHT: {
                    color = 0xFFFF47;
                    break;
                }
                case LOVE: {
                    color = 16221146;
                    break;
                }
                case WATER: {
                    color = 2781149;
                    break;
                }
                case WIND: {
                    color = 2204954;
                    break;
                }
            }
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            Random rand = new Random();
            for (int i = 0; i < 7; ++i) {
                serverLevel.sendParticles((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)FastColor.ARGB32.color((int)r, (int)g, (int)b)), target.getX() + (rand.nextDouble() - 0.5) * (double)target.getBbWidth(), target.getY() + 0.3 + rand.nextDouble() * (double)target.getBbHeight(), target.getZ() + (rand.nextDouble() - 0.5) * (double)target.getBbWidth(), 0, 0.0, 0.0, 0.0, 1.0);
            }
        }
    }

    public static void applyTempAttribute(LivingEntity entity, Holder<Attribute> att, double val) {
        AttributeInstance inst = entity.getAttribute(att);
        if (inst != null && inst.getModifier(TEMP_ATTRIBUTE_MOD) == null) {
            inst.addTransientModifier(new AttributeModifier(TEMP_ATTRIBUTE_MOD, val, AttributeModifier.Operation.ADD_VALUE));
        }
    }

    public static void applyTempAttributeMult(LivingEntity entity, Holder<Attribute> att, double val) {
        AttributeInstance inst = entity.getAttribute(att);
        if (inst != null && inst.getModifier(TEMP_ATTRIBUTE_MOD_MULT) == null) {
            inst.addTransientModifier(new AttributeModifier(TEMP_ATTRIBUTE_MOD_MULT, val - 1.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        }
    }

    public static void removeTempAttribute(LivingEntity entity, Holder<Attribute> att) {
        AttributeInstance inst = entity.getAttribute(att);
        if (inst != null) {
            inst.removeModifier(TEMP_ATTRIBUTE_MOD);
            inst.removeModifier(TEMP_ATTRIBUTE_MOD_MULT);
        }
    }

    public static void hitEntityWithItemPlayer(ServerPlayer player, ItemStack stack) {
        PlayerData data = Platform.INSTANCE.getPlayerData((Player)player);
        if (stack.getItem() instanceof ItemStaffBase) {
            switch (ItemComponentUtils.getElement(stack)) {
                case WATER: {
                    LevelCalc.levelSkill(data, Skills.WATER, 3.0f);
                    break;
                }
                case EARTH: {
                    LevelCalc.levelSkill(data, Skills.EARTH, 3.0f);
                    break;
                }
                case WIND: {
                    LevelCalc.levelSkill(data, Skills.WIND, 3.0f);
                    break;
                }
                case FIRE: {
                    LevelCalc.levelSkill(data, Skills.FIRE, 3.0f);
                    break;
                }
                case LIGHT: {
                    LevelCalc.levelSkill(data, Skills.LIGHT, 3.0f);
                    break;
                }
                case DARK: {
                    LevelCalc.levelSkill(data, Skills.DARK, 3.0f);
                    break;
                }
                case LOVE: {
                    LevelCalc.levelSkill(data, Skills.LOVE, 3.0f);
                }
            }
            return;
        }
        if (stack.is(RunecraftoryTags.Items.SHORTSWORDS)) {
            LevelCalc.levelSkill(data, Skills.SHORTSWORD, 2.0f);
        }
        if (stack.is(RunecraftoryTags.Items.LONGSWORDS)) {
            LevelCalc.levelSkill(data, Skills.LONGSWORD, 4.0f);
        }
        if (stack.is(RunecraftoryTags.Items.SPEARS)) {
            LevelCalc.levelSkill(data, Skills.SPEAR, 3.0f);
        }
        if (stack.is(RunecraftoryTags.Items.AXES) || stack.is(RunecraftoryTags.Items.HAMMERS)) {
            LevelCalc.levelSkill(data, Skills.HAMMERAXE, 5.0f);
        }
        if (stack.is(RunecraftoryTags.Items.DUALBLADES)) {
            LevelCalc.levelSkill(data, Skills.DUAL, 2.0f);
        }
        if (stack.is(RunecraftoryTags.Items.FISTS)) {
            LevelCalc.levelSkill(data, Skills.FIST, 2.0f);
        }
        if (stack.is(RunecraftoryTags.Items.AXE_TOOLS) || stack.is(RunecraftoryTags.Items.HAMMER_TOOLS)) {
            LevelCalc.levelSkill(data, Skills.HAMMERAXE, 1.0f);
        }
        if (stack.is(RunecraftoryTags.Items.HOES) || stack.is(RunecraftoryTags.Items.WATERINGCANS) || stack.is(RunecraftoryTags.Items.SICKLES)) {
            LevelCalc.levelSkill(data, Skills.FARMING, 1.0f);
        }
    }

    public static double getRange(LivingEntity entity, double bonus) {
        return (EntityUtils.tryGetAttribute(entity, (Holder<Attribute>)RuneCraftoryAttributes.ATTACK_RANGE.asHolder()) + bonus) * (double)entity.getScale();
    }

    public static double getWidth(LivingEntity entity, double bonus) {
        return (EntityUtils.tryGetAttribute(entity, (Holder<Attribute>)RuneCraftoryAttributes.ATTACK_WIDTH.asHolder()) + bonus) * (double)entity.getScale();
    }

    public static int getSpellLevelFromStack(ItemStack stack) {
        if (stack.getItem() instanceof ItemSpell) {
            return ItemComponentUtils.itemLevel(stack);
        }
        return 1;
    }

    public static double getAbilityDamageBonus(ItemStack stack, Supplier<? extends Spell> source) {
        return CombatUtils.getAbilityDamageBonus(CombatUtils.getSpellLevelFromStack(stack), source.get().properties().baseDamageMultiplier());
    }

    public static float getAbilityDamageBonus(int level, Spell source) {
        return CombatUtils.getAbilityDamageBonus(level, source.properties().baseDamageMultiplier());
    }

    public static float getAbilityDamageBonus(int level, float origin) {
        return origin * (1.0f + (float)(level - 1) * 0.025f);
    }

    public static Vec3 fromRelativeVector(Entity entity, Vec3 relative) {
        return CombatUtils.fromRelativeVector(entity.getYRot(), relative);
    }

    public static Vec3 fromRelativeVector(float yRot, Vec3 relative) {
        Vec3 vec3 = relative.normalize();
        float f = Mth.sin((float)(yRot * ((float)Math.PI / 180)));
        float g = Mth.cos((float)(yRot * ((float)Math.PI / 180)));
        return new Vec3(vec3.x * (double)g - vec3.z * (double)f, vec3.y, vec3.z * (double)g + vec3.x * (double)f);
    }

    public static boolean canPerform(LivingEntity entity, Skills skill, int requiredLvl) {
        if (!(entity instanceof Player)) {
            return false;
        }
        Player player = (Player)entity;
        return player.isCreative() || Platform.INSTANCE.getPlayerData(player).getSkillLevel(skill).getLevel() >= requiredLvl;
    }

    public static interface FloatMap {
        public float get(float var1);
    }

    public static class EntityAttack {
        private final LivingEntity attacker;
        private Predicate<LivingEntity> targetPred;
        private final Map<Holder<Attribute>, Double> bonusAttributes = new HashMap<Holder<Attribute>, Double>();
        private final Map<Holder<Attribute>, Double> bonusAttributesMultiplier = new HashMap<Holder<Attribute>, Double>();
        private Consumer<LivingEntity> onSuccess;
        private SoundEvent soundToPlay;
        private final BiFunction<LivingEntity, Predicate<LivingEntity>, Collection<LivingEntity>> targets;

        protected EntityAttack(LivingEntity attacker, BiFunction<LivingEntity, Predicate<LivingEntity>, Collection<LivingEntity>> targets) {
            this.attacker = attacker;
            this.targets = targets;
        }

        public static EntityAttack create(LivingEntity attacker, BiFunction<LivingEntity, Predicate<LivingEntity>, Collection<LivingEntity>> targets) {
            return new EntityAttack(attacker, targets);
        }

        public static BiFunction<LivingEntity, Predicate<LivingEntity>, Collection<LivingEntity>> circleTargets(float startRot, float endRot, float rangeBonus) {
            return EntityAttack.circleTargets(startRot, endRot, null, rangeBonus);
        }

        public static BiFunction<LivingEntity, Predicate<LivingEntity>, Collection<LivingEntity>> circleTargets(float startRot, float endRot, FloatMap xRot, float rangeBonus) {
            return (attacker, predicate) -> {
                double reach = CombatUtils.getRange(attacker, rangeBonus);
                double incHalf = Math.asin(0.5 / reach) * 57.2957763671875;
                float minYRot = Math.min(startRot, endRot);
                float maxYRot = Math.max(startRot, endRot);
                AABB aabb = new AABB(-0.5, -0.02, 0.0, 0.5, (double)attacker.getBbHeight() + 0.02, reach);
                int rotationSteps = (int)((double)(maxYRot - minYRot) / (incHalf * 2.0)) + 2;
                float inc = (maxYRot - minYRot) / (float)rotationSteps;
                HashSet entities = new HashSet();
                for (int steps = 0; steps <= rotationSteps; ++steps) {
                    float yRot = minYRot + inc * (float)steps;
                    OrientedBoundingBox obb = new OrientedBoundingBox(aabb, yRot, xRot == null ? 0.0f : xRot.get((float)steps / (float)rotationSteps), attacker.position());
                    entities.addAll(HitResultUtils.getEntities((LivingEntity)attacker, (OrientedBoundingBox)obb, (boolean)false, (EntityTypeTest)EntityTypeTest.forClass(LivingEntity.class), (Predicate)predicate));
                    S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTACK, (Entity)attacker);
                }
                return entities;
            };
        }

        public static BiFunction<LivingEntity, Predicate<LivingEntity>, Collection<LivingEntity>> circleTargetsFixedRange(float startRot, float endRot, float reach) {
            return (attacker, predicate) -> {
                double incHalf = Math.asin(0.5 / (double)reach) * 57.2957763671875;
                float minYRot = Math.min(startRot, endRot);
                float maxYRot = Math.max(startRot, endRot);
                AABB aabb = new AABB(-0.5, -0.02, 0.0, 0.5, (double)attacker.getBbHeight() + 0.02, (double)reach);
                int rotationSteps = (int)((double)(maxYRot - minYRot) / (incHalf * 2.0)) + 2;
                float inc = (maxYRot - minYRot) / (float)rotationSteps;
                HashSet entities = new HashSet();
                for (int steps = 0; steps <= rotationSteps; ++steps) {
                    float yRot = minYRot + inc * (float)steps;
                    OrientedBoundingBox obb = new OrientedBoundingBox(aabb, yRot, 0.0f, attacker.position());
                    entities.addAll(HitResultUtils.getEntities((LivingEntity)attacker, (OrientedBoundingBox)obb, (boolean)false, (EntityTypeTest)EntityTypeTest.forClass(LivingEntity.class), (Predicate)predicate));
                    S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTACK, (Entity)attacker);
                }
                return entities;
            };
        }

        public static BiFunction<LivingEntity, Predicate<LivingEntity>, Collection<LivingEntity>> aabbTargets(AABB aabb) {
            return EntityAttack.aabbTargets(aabb, true);
        }

        public static BiFunction<LivingEntity, Predicate<LivingEntity>, Collection<LivingEntity>> aabbTargets(AABB aabb, boolean relative) {
            return (attacker, predicate) -> {
                OrientedBoundingBox obb = new OrientedBoundingBox(relative ? aabb.move(attacker.position().scale(-1.0)) : aabb, attacker.getYRot(), 0.0f, attacker.position());
                S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTACK, (Entity)attacker);
                return HitResultUtils.getEntities((LivingEntity)attacker, (OrientedBoundingBox)obb, (boolean)true, (EntityTypeTest)EntityTypeTest.forClass(LivingEntity.class), (Predicate)predicate);
            };
        }

        public static BiFunction<LivingEntity, Predicate<LivingEntity>, Collection<LivingEntity>> obbTargets(float yRot, float xRot, double width, double range, boolean fixed) {
            return (attacker, predicate) -> {
                double reach = fixed ? range : CombatUtils.getRange(attacker, range);
                AABB aabb = new AABB(-width * 0.5, -0.02, 0.0, width * 0.5, (double)attacker.getBbHeight(), reach);
                OrientedBoundingBox obb = new OrientedBoundingBox(aabb, yRot, -xRot, attacker.position());
                S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTACK, (Entity)attacker);
                return HitResultUtils.getEntities((LivingEntity)attacker, (OrientedBoundingBox)obb, (boolean)false, (EntityTypeTest)EntityTypeTest.forClass(LivingEntity.class), (Predicate)predicate);
            };
        }

        public static BiFunction<LivingEntity, Predicate<LivingEntity>, Collection<LivingEntity>> obbTargets(OrientedBoundingBox obb) {
            return (attacker, predicate) -> {
                S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTACK, (Entity)attacker);
                return HitResultUtils.getEntities((LivingEntity)attacker, (OrientedBoundingBox)obb, (boolean)false, (EntityTypeTest)EntityTypeTest.forClass(LivingEntity.class), (Predicate)predicate);
            };
        }

        public EntityAttack withTargetPredicate(Predicate<LivingEntity> targetPred) {
            this.targetPred = targetPred;
            return this;
        }

        public EntityAttack withBonusAttributes(Holder<Attribute> att, double val) {
            this.bonusAttributes.put(att, val);
            return this;
        }

        public EntityAttack withBonusAttributesMultiplier(Holder<Attribute> att, double val) {
            this.bonusAttributesMultiplier.put(att, val);
            return this;
        }

        public EntityAttack doOnSuccess(Consumer<LivingEntity> onSuccess) {
            this.onSuccess = onSuccess;
            return this;
        }

        public EntityAttack withAttackSound(SoundEvent sound) {
            this.soundToPlay = sound;
            return this;
        }

        public Collection<LivingEntity> executeAttack() {
            LivingEntity livingEntity;
            if (this.attacker.level().isClientSide) {
                return List.of();
            }
            LivingEntity livingEntity2 = this.attacker;
            if (livingEntity2 instanceof TargetableOpponent) {
                TargetableOpponent pred = (TargetableOpponent)livingEntity2;
                this.targetPred = this.targetPred == null ? pred.validTargetPredicate() : pred.validTargetPredicate().and(this.targetPred);
            }
            Collection<LivingEntity> list = this.targets.apply(this.attacker, this.targetPred);
            this.bonusAttributes.forEach((att, val) -> CombatUtils.applyTempAttribute(this.attacker, (Holder<Attribute>)att, val));
            this.bonusAttributesMultiplier.forEach((att, val) -> CombatUtils.applyTempAttributeMult(this.attacker, (Holder<Attribute>)att, val));
            LivingEntity livingEntity3 = this.attacker;
            if (livingEntity3 instanceof Mob) {
                Mob mob = (Mob)livingEntity3;
                livingEntity = mob.getTarget();
            } else {
                livingEntity = null;
            }
            LivingEntity target = livingEntity;
            for (LivingEntity livingEntity4 : list) {
                boolean flag = false;
                if (target != livingEntity4 && this.attacker.getVehicle() == livingEntity4) continue;
                LivingEntity livingEntity5 = this.attacker;
                if (livingEntity5 instanceof Player) {
                    Player player = (Player)livingEntity5;
                    flag = CombatUtils.attackWithItem(player, (Entity)livingEntity4, false, false);
                } else {
                    livingEntity5 = this.attacker;
                    if (livingEntity5 instanceof Mob) {
                        Mob mob = (Mob)livingEntity5;
                        flag = mob.doHurtTarget((Entity)livingEntity4);
                    }
                }
                if (!flag) continue;
                if (this.onSuccess != null) {
                    this.onSuccess.accept(livingEntity4);
                }
                if (this.soundToPlay == null) continue;
                this.attacker.level().playSound(null, this.attacker.getX(), this.attacker.getY(), this.attacker.getZ(), this.soundToPlay, this.attacker.getSoundSource(), 1.0f, 1.0f);
            }
            this.bonusAttributes.forEach((att, val) -> CombatUtils.removeTempAttribute(this.attacker, (Holder<Attribute>)att));
            this.bonusAttributesMultiplier.forEach((att, val) -> CombatUtils.removeTempAttribute(this.attacker, (Holder<Attribute>)att));
            return list;
        }
    }
}

