/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.utils;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.api.attachment.Skills;
import io.github.flemmli97.runecraftory.api.datapack.ItemStat;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.inventory.PlayerBoundCraftingContainer;
import io.github.flemmli97.runecraftory.common.recipes.CraftingType;
import io.github.flemmli97.runecraftory.common.recipes.SextupleRecipe;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryCrafting;
import io.github.flemmli97.runecraftory.common.utils.ItemComponentUtils;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.Random;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;

public class CraftingUtils {
    public static final Random RAND = new Random();

    public static RecipeType<SextupleRecipe> getType(CraftingType type) {
        return switch (type) {
            case CraftingType.FORGE -> (RecipeType)RuneCraftoryCrafting.FORGE.get();
            case CraftingType.ACCESSORY_WORKBENCH -> (RecipeType)RuneCraftoryCrafting.ARMOR.get();
            case CraftingType.CHEMISTRY_SET -> (RecipeType)RuneCraftoryCrafting.CHEMISTRY.get();
            default -> (RecipeType)RuneCraftoryCrafting.COOKING.get();
        };
    }

    public static Pair<Integer, ItemStack> getUpgradeResult(ItemStack stack, PlayerData data, ItemStack ingredient, CraftingType type) {
        int cost = CraftingUtils.upgradeCost(type, data, stack, ingredient);
        if (cost < 0) {
            return Pair.of((Object)cost, (Object)ItemStack.EMPTY);
        }
        return Pair.of((Object)cost, (Object)ItemComponentUtils.addUpgradeItem(stack.copy(), ingredient, false, type));
    }

    public static int upgradeCost(CraftingType type, PlayerData data, ItemStack stack, ItemStack ingredient) {
        if (!GeneralConfig.useRp) {
            return 0;
        }
        if (stack.isEmpty()) {
            return -1;
        }
        return DataPackHandler.INSTANCE.itemStatManager().get(ingredient.getItem()).map(stat -> {
            if (stat.getDiff() <= 0) {
                return -1;
            }
            if (!stack.isEmpty()) {
                int result;
                int skillLevel;
                int n = skillLevel = type == CraftingType.FORGE ? data.getSkillLevel(Skills.FORGING).getLevel() : data.getSkillLevel(Skills.CRAFTING).getLevel();
                if (skillLevel >= stat.getDiff()) {
                    result = stat.getDiff() * 2 + (ItemComponentUtils.itemLevel(stack) - 1) * 2;
                } else {
                    int diff = stat.getDiff() - skillLevel;
                    int equip = ItemComponentUtils.itemLevel(stack) - 1;
                    result = (4 * diff + 2) * stat.getDiff() + 2 * stat.getDiff() * (2 * equip) + equip * 2;
                }
                return result;
            }
            return -1;
        }).orElse(-1);
    }

    public static void giveCraftingXPTo(PlayerData data, Skills skill, SextupleRecipe recipe) {
        if (GeneralConfig.skillXpMultiplier == 0.0f) {
            return;
        }
        data.increaseSkill(skill, CraftingUtils.xpForCrafting(skill, recipe, data.getSkillLevel(skill).getLevel()) * GeneralConfig.skillXpMultiplier);
    }

    private static float xpForCrafting(Skills skill, SextupleRecipe recipe, int skillLevel) {
        float mult = LevelCalc.getSkillXpMultiplier(skill);
        float xp = (float)(recipe.getCraftingLevel() * 2 + 10) * mult;
        xp = skillLevel > recipe.getCraftingLevel() ? (xp -= (float)(2 * skillLevel - recipe.getCraftingLevel())) : (xp += (float)((recipe.getCraftingLevel() - skillLevel) * recipe.getCraftingLevel()));
        if (xp < 1.0f) {
            xp = 1.0f;
        }
        return xp;
    }

    public static void giveUpgradeXPTo(PlayerData data, Skills skill, ItemStack equip, ItemStack upgrade) {
        if (GeneralConfig.skillXpMultiplier == 0.0f) {
            return;
        }
        data.increaseSkill(skill, CraftingUtils.xpForUpgrade(skill, equip, upgrade, data.getSkillLevel(skill).getLevel()) * GeneralConfig.skillXpMultiplier);
    }

    private static float xpForUpgrade(Skills skill, ItemStack equip, ItemStack upgrade, int skillLevel) {
        float mult = LevelCalc.getSkillXpMultiplier(skill) * 1.5f;
        int difficulty = DataPackHandler.INSTANCE.itemStatManager().get(upgrade.getItem()).map(ItemStat::getDiff).orElse(0);
        float xp = mult * (float)(10 + ItemComponentUtils.itemLevel(equip));
        if (skillLevel < difficulty) {
            xp += (float)(2 * difficulty - skillLevel);
        }
        return xp;
    }

    public static int craftingCost(CraftingType type, PlayerData data, SextupleRecipe recipe, NonNullList<ItemStack> bonusItems, boolean unlocked) {
        if (!GeneralConfig.useRp) {
            return 0;
        }
        if (GeneralConfig.recipeSystem.baseCost) {
            int cost = Math.max(recipe.getCraftingLevel() * 2 + recipe.getAdditionalCost(), 10);
            int additionalMaterial = 0;
            for (ItemStack items : bonusItems) {
                additionalMaterial += DataPackHandler.INSTANCE.itemStatManager().get(items.getItem()).map(ItemStat::getDiff).orElse(10).intValue();
            }
            cost += additionalMaterial;
            if (!unlocked && GeneralConfig.recipeSystem.lockedCostMore) {
                cost *= 3;
            }
            return cost;
        }
        int skillLevel = switch (type) {
            default -> throw new MatchException(null, null);
            case CraftingType.FORGE -> data.getSkillLevel(Skills.FORGING).getLevel();
            case CraftingType.ACCESSORY_WORKBENCH -> data.getSkillLevel(Skills.CRAFTING).getLevel();
            case CraftingType.CHEMISTRY_SET -> data.getSkillLevel(Skills.CHEMISTRY).getLevel();
            case CraftingType.COOKING_TABLE -> data.getSkillLevel(Skills.COOKING).getLevel();
        };
        int lvlDifference = recipe.getCraftingLevel() - skillLevel;
        int cost = recipe.getCraftingLevel() * 2;
        cost = lvlDifference <= 0 ? Math.max(cost + lvlDifference, 10) + recipe.getAdditionalCost() : Math.max(cost + recipe.getAdditionalCost(), 10) * (int)((double)(1 + lvlDifference) * 1.5);
        int additionalMaterial = 0;
        for (ItemStack items : bonusItems) {
            additionalMaterial += DataPackHandler.INSTANCE.itemStatManager().get(items.getItem()).map(s -> {
                if (skillLevel >= s.getDiff()) {
                    return s.getDiff();
                }
                return (int)((double)(s.getDiff() - skillLevel) * 1.5) * (s.getDiff() - 5);
            }).orElse(10).intValue();
        }
        cost += additionalMaterial;
        if (!unlocked && GeneralConfig.recipeSystem.lockedCostMore) {
            cost *= 3;
        }
        return cost;
    }

    public static ItemStack getCraftingOutput(ItemStack stack, PlayerBoundCraftingContainer inv, SextupleRecipe.MatchResult materials, CraftingType type) {
        if (type == CraftingType.COOKING_TABLE) {
            for (ItemStack base : materials.recipeMatches()) {
                ItemComponentUtils.addFoodBonusItem(stack, base);
            }
            for (ItemStack bonus : materials.bonusItems()) {
                ItemComponentUtils.addFoodBonusItem(stack, bonus);
            }
            return stack;
        }
        int i = 0;
        for (ItemStack bonus : materials.bonusItems()) {
            ItemComponentUtils.addUpgradeItem(stack, bonus, true, type);
            if (++i != 3) continue;
            break;
        }
        NonNullList<ItemStack> recipeStacks = materials.recipeMatches();
        RAND.setSeed(Platform.INSTANCE.getPlayerData(inv.getPlayer()).getCraftingSeed(inv.getPlayer()));
        if (recipeStacks.size() > 3) {
            while (i < 3) {
                ItemStack rand = (ItemStack)recipeStacks.get(RAND.nextInt(recipeStacks.size()));
                if (!rand.isEmpty()) {
                    recipeStacks.remove((Object)rand);
                    ItemComponentUtils.addUpgradeItem(stack, rand, true, type);
                }
                ++i;
            }
        }
        return stack;
    }
}

