/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.utils;

import io.github.flemmli97.runecraftory.api.calendar.Season;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryBlocks;
import io.github.flemmli97.runecraftory.common.world.data.Calendar;
import io.github.flemmli97.tenshilib.loader.registry.RegistryEntrySupplier;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class GrassRegrowUtil {
    private static final EnumMap<Season, List<HerbEntry>> SEASON_HERB_GROW_MAP = GrassRegrowUtil.getSeasonHerbGrowMap();

    public static void tryGrowHerb(ServerLevel level, BlockPos pos) {
        Season currentSeason = Calendar.get((Level)level).currentSeason();
        List<HerbEntry> l = SEASON_HERB_GROW_MAP.get((Object)currentSeason);
        BlockState state = WeightedRandom.getRandomItem((RandomSource)level.random, l).map(e -> ((Block)e.sup.get()).defaultBlockState()).orElse(Blocks.AIR.defaultBlockState());
        if (state.getBlock() != Blocks.AIR) {
            level.setBlock(pos, state, 3);
        }
    }

    private static EnumMap<Season, List<HerbEntry>> getSeasonHerbGrowMap() {
        EnumMap<Season, List<HerbEntry>> map = new EnumMap<Season, List<HerbEntry>>(Season.class);
        map.put(Season.SPRING, List.of(new HerbEntry(100, RuneCraftoryBlocks.WEEDS), new HerbEntry(30, RuneCraftoryBlocks.GREEN_GRASS), new HerbEntry(30, RuneCraftoryBlocks.ORANGE_GRASS), new HerbEntry(50, RuneCraftoryBlocks.ANTIDOTE_GRASS), new HerbEntry(50, RuneCraftoryBlocks.MEDICINAL_HERB), new HerbEntry(15, RuneCraftoryBlocks.BAMBOO_SPROUT)));
        map.put(Season.SUMMER, List.of(new HerbEntry(100, RuneCraftoryBlocks.WEEDS), new HerbEntry(30, RuneCraftoryBlocks.GREEN_GRASS), new HerbEntry(30, RuneCraftoryBlocks.YELLOW_GRASS), new HerbEntry(30, RuneCraftoryBlocks.BLUE_GRASS), new HerbEntry(30, RuneCraftoryBlocks.PURPLE_GRASS), new HerbEntry(50, RuneCraftoryBlocks.ANTIDOTE_GRASS), new HerbEntry(50, RuneCraftoryBlocks.MEDICINAL_HERB), new HerbEntry(15, RuneCraftoryBlocks.BAMBOO_SPROUT)));
        map.put(Season.AUTUMN, List.of(new HerbEntry(100, RuneCraftoryBlocks.WEEDS), new HerbEntry(30, RuneCraftoryBlocks.YELLOW_GRASS), new HerbEntry(20, RuneCraftoryBlocks.RED_GRASS), new HerbEntry(20, RuneCraftoryBlocks.ORANGE_GRASS), new HerbEntry(50, RuneCraftoryBlocks.ANTIDOTE_GRASS), new HerbEntry(50, RuneCraftoryBlocks.MEDICINAL_HERB), new HerbEntry(15, RuneCraftoryBlocks.BAMBOO_SPROUT)));
        map.put(Season.WINTER, List.of(new HerbEntry(100, RuneCraftoryBlocks.WEEDS), new HerbEntry(20, RuneCraftoryBlocks.WHITE_GRASS), new HerbEntry(20, RuneCraftoryBlocks.BLACK_GRASS), new HerbEntry(30, RuneCraftoryBlocks.INDIGO_GRASS), new HerbEntry(50, RuneCraftoryBlocks.ANTIDOTE_GRASS), new HerbEntry(50, RuneCraftoryBlocks.MEDICINAL_HERB), new HerbEntry(15, RuneCraftoryBlocks.BAMBOO_SPROUT)));
        return map;
    }

    private static class HerbEntry
    implements WeightedEntry {
        private final Weight weight;
        public final RegistryEntrySupplier<Block, ?> sup;

        public HerbEntry(int weight, RegistryEntrySupplier<Block, ?> sup) {
            this.weight = Weight.of((int)weight);
            this.sup = sup;
        }

        public Weight getWeight() {
            return this.weight;
        }
    }
}

